/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.properties;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.item.crystal.properties.CrystalProperties;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;

public class InstabilityCrystalProperties
extends CrystalProperties {
    private float instability = 0.0f;

    public float getInstability() {
        return this.instability;
    }

    public void setInstability(float instability) {
        this.instability = instability;
    }

    @Override
    public void addText(List<Component> tooltip, int minIndex, TooltipFlag flag, float time) {
        super.addText(tooltip, minIndex, flag, time);
        if (this.instability > 0.0f) {
            TextComponent instabilityComponent = new TextComponent("%.1f%%".formatted(Float.valueOf(this.instability * 100.0f)));
            instabilityComponent.m_6270_(Style.f_131099_.m_131148_(this.getInstabilityTextColor(Math.round(this.instability * 100.0f))));
            tooltip.add(tooltip.size() - 1, (Component)new TextComponent("Instability: ").m_7220_((Component)instabilityComponent));
        }
    }

    private TextColor getInstabilityTextColor(float instability) {
        float value;
        float saturation;
        float hue;
        float threshold = 0.5f;
        float hueDarkGreen = 0.3334f;
        float hueGold = 0.1111f;
        if (instability <= 0.5f) {
            float p = instability / 0.5f;
            hue = (1.0f - p) * 0.3334f + p * 0.1111f;
            saturation = 1.0f;
            value = (1.0f - p) * 0.8f + p;
        } else {
            float p = (instability - 0.5f) / 0.5f;
            hue = (1.0f - p) * 0.1111f;
            saturation = 1.0f - p + p * 0.8f;
            value = 1.0f - p + p * 0.8f;
        }
        return TextColor.m_131266_((int)Color.HSBtoRGB(hue, saturation, value));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.instability)).ifPresent(tag -> nbt.m_128365_("instability", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.instability = Adapters.FLOAT.readNbt(nbt.m_128423_("instability")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(nbt -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.instability)).ifPresent(tag -> nbt.add("instability", tag));
            return nbt;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.instability = Adapters.FLOAT.readJson(json.get("instability")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

