/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.recipe;

import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.INbtSerializable;
import iskallia.vault.item.crystal.recipe.AnvilMenuProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;

public class AnvilExecutor {
    public static Result test(Player player, ItemStack input, List<ItemStack> ingredients, List<ItemStack> uniqueIngredients) {
        Result result = new Result(ingredients.size());
        result.setOutput(input.m_41777_());
        AnvilExecutor.applyIngredient(player, result, 0, uniqueIngredients.get(0), result::setUniqueIngredientResult, false, true);
        AnvilExecutor.applyIngredient(player, result, 1, uniqueIngredients.get(1), result::setUniqueIngredientResult, false, true);
        for (int index = 0; index < ingredients.size(); ++index) {
            AnvilExecutor.applyIngredient(player, result, index, ingredients.get(index).m_41777_(), result::setIngredientResult, true, false);
        }
        AnvilExecutor.applyIngredient(player, result, 2, uniqueIngredients.get(2), result::setUniqueIngredientResult, false, true);
        return result;
    }

    private static void applyIngredient(Player player, Result result, int index, ItemStack ingredient, BiConsumer<Integer, ItemStack> setIngredientResult, boolean setUsedSlot, boolean uniqueIngredient) {
        setIngredientResult.accept(index, ingredient);
        boolean firstIteration = true;
        while (!(ingredient.m_41619_() || uniqueIngredient && !firstIteration)) {
            AnvilMenu anvil = new AnvilMenu(0, player.m_150109_());
            AnvilMenuProxy.of(anvil).setFake(true);
            anvil.m_38853_(0).m_5852_(result.getOutput());
            if (uniqueIngredient) {
                ItemStack singleItem = ingredient.m_41777_();
                singleItem.m_41764_(1);
                anvil.m_38853_(1).m_5852_(singleItem);
            } else {
                anvil.m_38853_(1).m_5852_(ingredient.m_41777_());
            }
            anvil.m_6640_();
            ItemStack output = anvil.m_38853_(2).m_150647_(anvil.m_38853_(2).m_7993_().m_41613_(), Integer.MAX_VALUE, player);
            if (output.m_41619_()) break;
            if (uniqueIngredient) {
                ItemStack remaining = ingredient.m_41777_();
                remaining.m_41774_(1);
                ingredient = remaining;
            } else {
                ingredient = anvil.m_38853_(1).m_7993_();
            }
            setIngredientResult.accept(index, ingredient);
            if (setUsedSlot) {
                result.addUsedSlot(index);
            }
            if (anvil.m_38853_(0).m_7993_().m_41619_()) {
                result.setOutput(output);
            } else {
                result.addExtra(output);
                result.setOutput(anvil.m_38853_(0).m_7993_().m_41777_());
            }
            firstIteration = false;
        }
    }

    public static class Result
    implements INbtSerializable<CompoundTag> {
        protected ItemStack[] uniqueIngredients;
        protected ItemStack[] ingredients;
        protected Set<Integer> usedSlots;
        protected ItemStack output;
        private List<ItemStack> extra;

        public Result() {
        }

        public Result(int size) {
            this.ingredients = new ItemStack[size];
            this.uniqueIngredients = new ItemStack[3];
            this.usedSlots = new HashSet<Integer>();
            this.output = ItemStack.f_41583_;
            this.extra = new ArrayList<ItemStack>();
            Arrays.fill(this.ingredients, ItemStack.f_41583_);
        }

        public ItemStack[] getIngredients() {
            return this.ingredients;
        }

        public ItemStack getUniqueIngredient(int index) {
            return this.uniqueIngredients[index];
        }

        public boolean hasUsedSlot(int index) {
            return this.usedSlots.contains(index);
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public List<ItemStack> getExtra() {
            return this.extra;
        }

        public void setIngredientResult(int index, ItemStack stack) {
            this.ingredients[index] = stack;
        }

        public void setUniqueIngredientResult(int index, ItemStack stack) {
            this.uniqueIngredients[index] = stack;
        }

        public void addUsedSlot(int index) {
            this.usedSlots.add(index);
        }

        public void setOutput(ItemStack stack) {
            this.output = stack;
        }

        public void addExtra(ItemStack stack) {
            this.extra.add(stack);
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            ListTag ingredients = new ListTag();
            for (ItemStack ingredient : this.ingredients) {
                Adapters.ITEM_STACK.writeNbt(ingredient).ifPresent(arg_0 -> ingredients.add(arg_0));
            }
            ListTag uniqueIngredients = new ListTag();
            for (ItemStack uniqueIngredient : this.uniqueIngredients) {
                Adapters.ITEM_STACK.writeNbt(uniqueIngredient).ifPresent(arg_0 -> uniqueIngredients.add(arg_0));
            }
            nbt.m_128365_("ingredients", (Tag)ingredients);
            nbt.m_128365_("unique_ingredients", (Tag)uniqueIngredients);
            nbt.m_128365_("used_slots", (Tag)new IntArrayTag(new ArrayList<Integer>(this.usedSlots)));
            Adapters.ITEM_STACK.writeNbt(this.output).ifPresent(output -> nbt.m_128365_("output", output));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            ListTag uniqueIngredients;
            ListTag ingredients = (ListTag)nbt.m_128423_("ingredients");
            if (ingredients != null) {
                this.ingredients = new ItemStack[ingredients.size()];
                for (int i = 0; i < ingredients.size(); ++i) {
                    this.ingredients[i] = Adapters.ITEM_STACK.readNbt(ingredients.get(i)).orElse(ItemStack.f_41583_);
                }
            }
            if ((uniqueIngredients = (ListTag)nbt.m_128423_("unique_ingredients")) != null) {
                this.uniqueIngredients = new ItemStack[uniqueIngredients.size()];
                for (int i = 0; i < uniqueIngredients.size(); ++i) {
                    this.uniqueIngredients[i] = Adapters.ITEM_STACK.readNbt(uniqueIngredients.get(i)).orElse(ItemStack.f_41583_);
                }
            }
            int[] usedSlots = nbt.m_128465_("used_slots");
            this.usedSlots = new HashSet<Integer>();
            for (int usedSlot : usedSlots) {
                this.usedSlots.add(usedSlot);
            }
            this.output = Adapters.ITEM_STACK.readNbt(nbt.m_128423_("output")).orElse(ItemStack.f_41583_);
        }

        public ItemStack[] getUniqueIngredients() {
            return this.uniqueIngredients;
        }
    }
}

