/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.recipe;

import iskallia.vault.config.gear.VaultEtchingConfig;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.recipe.AnvilContext;
import iskallia.vault.item.crystal.recipe.VanillaAnvilRecipe;
import iskallia.vault.item.gear.EtchingItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AnvilBlock;

public class EtchingAnvilRecipe
extends VanillaAnvilRecipe {
    @Override
    public boolean onSimpleCraft(AnvilContext context) {
        VaultGearItem gear;
        ItemStack secondary;
        ItemStack primary;
        block10: {
            block9: {
                if (context.getBlockState().map(state -> state.m_60734_() instanceof AnvilBlock).orElse(false).booleanValue()) {
                    return false;
                }
                primary = context.getInput()[0];
                secondary = context.getInput()[1];
                Item item = primary.m_41720_();
                if (!(item instanceof VaultGearItem)) break block9;
                gear = (VaultGearItem)item;
                if (secondary.m_41720_() == ModItems.ETCHING) break block10;
            }
            return false;
        }
        VaultGearData data = VaultGearData.read(primary);
        if (data.hasAttribute(ModGearAttributes.ETCHING)) {
            return false;
        }
        if (!data.isModifiable() || data.getRarity().equals((Object)VaultGearRarity.UNIQUE)) {
            return false;
        }
        VaultGearData etchingData = VaultGearData.read(secondary);
        ResourceLocation etchingId = etchingData.getFirstValue(ModGearAttributes.ETCHING).orElse(null);
        VaultEtchingConfig.EtchingEntry etchingConfig = ModConfigs.ETCHINGS.getEtchingConfig(etchingId);
        if (etchingId == null || etchingConfig == null) {
            return false;
        }
        List<String> groups = etchingConfig.getTypeGroups();
        if (!groups.isEmpty()) {
            VaultGearType type = gear.getGearType(primary);
            boolean allowed = groups.stream().anyMatch(g -> ModConfigs.ETCHINGS.getGroup((String)g).contains((Object)type));
            if (!allowed) {
                return false;
            }
        }
        ItemStack output = primary.m_41777_();
        VaultGearData outData = VaultGearData.read(output);
        outData.setRarity(VaultGearRarity.UNIQUE);
        outData.createOrReplaceAttributeValue(ModGearAttributes.ETCHING, etchingId);
        etchingData.getModifiers(VaultGearModifier.AffixType.IMPLICIT).forEach(modifier -> outData.addModifier(VaultGearModifier.AffixType.IMPLICIT, (VaultGearModifier<?>)modifier));
        outData.write(output);
        context.setOutput(output);
        context.onTake(context.getTake().append(() -> {
            context.getInput()[0].m_41774_(1);
            context.getInput()[1].m_41774_(1);
        }));
        return true;
    }

    @Override
    public void onRegisterJEI(IRecipeRegistration registry) {
        if (!ModConfigs.isInitialized()) {
            return;
        }
        IVanillaRecipeFactory factory = registry.getVanillaRecipeFactory();
        ArrayList primary = new ArrayList();
        ArrayList secondary = new ArrayList();
        ArrayList output = new ArrayList();
        ModConfigs.ETCHINGS.getEtchingIds().forEach(id -> {
            VaultEtchingConfig.EtchingEntry etchingConfig = ModConfigs.ETCHINGS.getEtchingConfig((ResourceLocation)id);
            if (etchingConfig != null) {
                Optional<ItemStack> etching = EtchingItem.create(id, etchingConfig, new Random(), 100);
                if (etching.isEmpty()) {
                    return;
                }
                secondary.add(etching.get());
                ItemStack gear = new ItemStack((ItemLike)ModItems.SWORD);
                VaultGearData gearData = VaultGearData.read(gear);
                gearData.setRarity(VaultGearRarity.COMMON);
                gearData.write(gear);
                primary.add(gear);
                ItemStack outputStack = gear.m_41777_();
                VaultGearData outData = VaultGearData.read(outputStack);
                outData.setRarity(VaultGearRarity.UNIQUE);
                outData.createOrReplaceAttributeValue(ModGearAttributes.ETCHING, id);
                VaultGearData etchingData = VaultGearData.read(etching.get());
                etchingData.getModifiers(VaultGearModifier.AffixType.IMPLICIT).forEach(modifier -> outData.addModifier(VaultGearModifier.AffixType.IMPLICIT, (VaultGearModifier<?>)modifier));
                outData.write(outputStack);
                output.add(outputStack);
            }
            factory.createAnvilRecipe(primary, secondary, output);
        });
    }
}

