/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.recipe;

import iskallia.vault.VaultMod;
import iskallia.vault.config.entry.recipe.ConfigInscriptionRecipe;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.crystal.layout.ArchitectCrystalLayout;
import iskallia.vault.item.crystal.recipe.AnvilContext;
import iskallia.vault.item.crystal.recipe.VanillaAnvilRecipe;
import iskallia.vault.item.data.InscriptionData;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AnvilBlock;

public class InscriptionAnvilRecipe
extends VanillaAnvilRecipe {
    @Override
    public boolean onSimpleCraft(AnvilContext context) {
        if (context.getBlockState().map(state -> state.m_60734_() instanceof AnvilBlock).orElse(false).booleanValue()) {
            return false;
        }
        ItemStack primary = context.getInput()[0];
        ItemStack secondary = context.getInput()[1];
        if (primary.m_41720_() != ModItems.VAULT_CRYSTAL || secondary.m_41720_() != ModItems.INSCRIPTION) {
            return false;
        }
        ItemStack output = primary.m_41777_();
        CrystalData crystal = CrystalData.read(output);
        InscriptionData data = InscriptionData.from(secondary);
        if (!data.apply(context.getPlayer().orElse(null), output, crystal)) {
            return false;
        }
        context.setOutput(output);
        context.onTake(context.getTake().append(() -> {
            context.getInput()[0].m_41774_(1);
            context.getInput()[1].m_41774_(1);
        }));
        return true;
    }

    @Override
    public void onRegisterJEI(IRecipeRegistration registry) {
        IVanillaRecipeFactory factory = registry.getVanillaRecipeFactory();
        ArrayList<ItemStack> primary = new ArrayList<ItemStack>();
        ArrayList<ItemStack> secondary = new ArrayList<ItemStack>();
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        primary.add(VaultCrystalItem.create(data -> data.setLayout(new ArchitectCrystalLayout())));
        for (ConfigInscriptionRecipe recipe : ModConfigs.INSCRIPTION_RECIPES.getConfigRecipes()) {
            ItemStack inscription = recipe.makeRecipe().createOutput(new ArrayList<OverSizedItemStack>(), null, 0);
            secondary.add(inscription);
            output.add(VaultCrystalItem.create((ItemStack)primary.get(0), crystal -> {
                InscriptionData data = InscriptionData.from(inscription);
                if (!data.apply(null, ItemStack.f_41583_, (CrystalData)crystal)) {
                    VaultMod.LOGGER.error("Failed to apply inscription to crystal for recipe " + String.valueOf(recipe.getId()));
                }
            }));
        }
        registry.addRecipes(RecipeTypes.ANVIL, List.of(factory.createAnvilRecipe(primary, secondary, output)));
    }
}

