/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.recipe;

import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.recipe.AnvilContext;
import iskallia.vault.item.crystal.recipe.VanillaAnvilRecipe;
import iskallia.vault.item.tool.JewelItem;
import iskallia.vault.item.tool.ToolItem;
import iskallia.vault.item.tool.ToolMaterial;
import iskallia.vault.item.tool.ToolType;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.world.item.ItemStack;

public class JewelAnvilRecipe
extends VanillaAnvilRecipe {
    public static List<VaultGearModifier<?>> PRESET_MODIFIERS = new ArrayList();

    @Override
    public boolean onSimpleCraft(AnvilContext context) {
        ItemStack primary = context.getInput()[0];
        ItemStack secondary = context.getInput()[1];
        if (primary.m_41720_() != ModItems.TOOL || secondary.m_41720_() != ModItems.JEWEL) {
            return false;
        }
        ItemStack output = primary.m_41777_();
        if (!ToolItem.applyJewel(output, secondary, true)) {
            return false;
        }
        context.setOutput(output);
        context.onTake(context.getTake().append(() -> {
            context.getInput()[0].m_41774_(1);
            context.getInput()[1].m_41774_(1);
        }));
        return true;
    }

    @Override
    public void onRegisterJEI(IRecipeRegistration registry) {
        IVanillaRecipeFactory factory = registry.getVanillaRecipeFactory();
        for (VaultGearModifier<?> modifier : PRESET_MODIFIERS) {
            ArrayList<ItemStack> primary = new ArrayList<ItemStack>();
            ArrayList<ItemStack> secondary = new ArrayList<ItemStack>();
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            ItemStack jewel = JewelItem.create(data -> {
                data.setRarity(VaultGearRarity.OMEGA);
                data.setState(VaultGearState.IDENTIFIED);
                data.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier<Integer>(ModGearAttributes.JEWEL_SIZE, 10));
                data.addModifier(VaultGearModifier.AffixType.SUFFIX, modifier);
            });
            for (ToolType type : ToolType.values()) {
                for (ToolMaterial material : ToolMaterial.values()) {
                    ItemStack tool = ToolItem.create(material, type);
                    ItemStack result = tool.m_41777_();
                    if (!ToolItem.applyJewel(result, jewel, true) || ToolType.of(tool) == ToolType.of(result)) continue;
                    primary.add(tool);
                    output.add(result);
                }
            }
            secondary.add(jewel);
            if (primary.isEmpty()) continue;
            registry.addRecipes(RecipeTypes.ANVIL, List.of(factory.createAnvilRecipe(primary, secondary, output)));
        }
    }

    static {
        PRESET_MODIFIERS.add(new VaultGearModifier<Boolean>(ModGearAttributes.PICKING, true));
        PRESET_MODIFIERS.add(new VaultGearModifier<Boolean>(ModGearAttributes.AXING, true));
        PRESET_MODIFIERS.add(new VaultGearModifier<Boolean>(ModGearAttributes.SHOVELLING, true));
        PRESET_MODIFIERS.add(new VaultGearModifier<Boolean>(ModGearAttributes.WOODEN_AFFINITY, true));
        PRESET_MODIFIERS.add(new VaultGearModifier<Boolean>(ModGearAttributes.ORNATE_AFFINITY, true));
        PRESET_MODIFIERS.add(new VaultGearModifier<Boolean>(ModGearAttributes.GILDED_AFFINITY, true));
        PRESET_MODIFIERS.add(new VaultGearModifier<Boolean>(ModGearAttributes.LIVING_AFFINITY, true));
        PRESET_MODIFIERS.add(new VaultGearModifier<Boolean>(ModGearAttributes.COIN_AFFINITY, true));
        PRESET_MODIFIERS.add(new VaultGearModifier<Boolean>(ModGearAttributes.SMELTING, true));
        PRESET_MODIFIERS.add(new VaultGearModifier<Boolean>(ModGearAttributes.PULVERIZING, true));
        PRESET_MODIFIERS.add(new VaultGearModifier<Boolean>(ModGearAttributes.HYDROVOID, true));
        PRESET_MODIFIERS.add(new VaultGearModifier<Boolean>(ModGearAttributes.SOULBOUND, true));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.MINING_SPEED, Float.valueOf(0.1f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.MINING_SPEED, Float.valueOf(1.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.MINING_SPEED, Float.valueOf(10.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Integer>(ModGearAttributes.DURABILITY, 1));
        PRESET_MODIFIERS.add(new VaultGearModifier<Integer>(ModGearAttributes.DURABILITY, 10));
        PRESET_MODIFIERS.add(new VaultGearModifier<Integer>(ModGearAttributes.DURABILITY, 100));
        PRESET_MODIFIERS.add(new VaultGearModifier<Integer>(ModGearAttributes.DURABILITY, 1000));
        PRESET_MODIFIERS.add(new VaultGearModifier<Integer>(ModGearAttributes.DURABILITY, 10000));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.COPIOUSLY, Float.valueOf(0.001f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.COPIOUSLY, Float.valueOf(0.01f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.COPIOUSLY, Float.valueOf(0.1f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.COPIOUSLY, Float.valueOf(1.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.COPIOUSLY, Float.valueOf(10.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.COPIOUSLY, Float.valueOf(100.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.ITEM_QUANTITY, Float.valueOf(0.001f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.ITEM_QUANTITY, Float.valueOf(0.01f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.ITEM_QUANTITY, Float.valueOf(0.1f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.ITEM_QUANTITY, Float.valueOf(1.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.ITEM_QUANTITY, Float.valueOf(10.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.ITEM_QUANTITY, Float.valueOf(100.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.ITEM_RARITY, Float.valueOf(0.001f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.ITEM_RARITY, Float.valueOf(0.01f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.ITEM_RARITY, Float.valueOf(0.1f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.ITEM_RARITY, Float.valueOf(1.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.ITEM_RARITY, Float.valueOf(10.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.ITEM_RARITY, Float.valueOf(100.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.TRAP_DISARMING, Float.valueOf(0.001f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.TRAP_DISARMING, Float.valueOf(0.01f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.TRAP_DISARMING, Float.valueOf(0.1f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.TRAP_DISARMING, Float.valueOf(1.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.TRAP_DISARMING, Float.valueOf(10.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.TRAP_DISARMING, Float.valueOf(100.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.IMMORTALITY, Float.valueOf(0.001f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.IMMORTALITY, Float.valueOf(0.01f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.IMMORTALITY, Float.valueOf(0.1f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.IMMORTALITY, Float.valueOf(1.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.IMMORTALITY, Float.valueOf(10.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Float>(ModGearAttributes.IMMORTALITY, Float.valueOf(100.0f)));
        PRESET_MODIFIERS.add(new VaultGearModifier<Double>(ModGearAttributes.REACH, 0.01));
        PRESET_MODIFIERS.add(new VaultGearModifier<Double>(ModGearAttributes.REACH, 0.1));
        PRESET_MODIFIERS.add(new VaultGearModifier<Double>(ModGearAttributes.REACH, 1.0));
        PRESET_MODIFIERS.add(new VaultGearModifier<Double>(ModGearAttributes.REACH, 10.0));
        PRESET_MODIFIERS.add(new VaultGearModifier<Integer>(ModGearAttributes.HAMMER_SIZE, 1));
        PRESET_MODIFIERS.add(new VaultGearModifier<Integer>(ModGearAttributes.HAMMER_SIZE, 2));
        PRESET_MODIFIERS.add(new VaultGearModifier<Integer>(ModGearAttributes.HAMMER_SIZE, 5));
    }
}

