/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.recipe;

import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.item.crystal.recipe.AnvilContext;
import iskallia.vault.item.crystal.recipe.AnvilRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;

public abstract class VanillaAnvilRecipe
extends AnvilRecipe {
    public abstract boolean onSimpleCraft(AnvilContext var1);

    @Override
    public boolean onCraft(AnvilContext context) {
        boolean result = this.onSimpleCraft(context);
        if (!result) {
            return false;
        }
        if (this.processNameChange(context)) {
            context.setLevelCost(context.getLevelCost() + 1);
        }
        context.onTake(context.getTake().append(() -> {
            this.consumeExperience(context);
            this.tryBreak(JavaRandom.ofNanoTime(), 0.12, context);
        }));
        return true;
    }

    public boolean processNameChange(AnvilContext context) {
        String name = context.getName();
        ItemStack output = context.getOutput();
        if (StringUtils.isBlank((CharSequence)name)) {
            if (output.m_41788_()) {
                output.m_41787_();
                return true;
            }
        } else if (!name.equals(output.m_41786_().getString())) {
            output.m_41714_((Component)new TextComponent(name));
            return true;
        }
        return false;
    }

    public void consumeExperience(AnvilContext context) {
        context.getPlayer().ifPresent(player -> {
            if (!player.m_150110_().f_35937_) {
                player.m_6749_(-context.getLevelCost());
            }
        });
    }

    public void tryBreak(RandomSource random, double chance, AnvilContext context) {
        context.getBlockState().ifPresent(state -> {
            Level world = context.getWorld().orElseThrow();
            BlockPos pos = context.getPos().orElseThrow();
            boolean creative = context.getPlayer().map(player -> player.m_150110_().f_35937_).orElse(false);
            if (state.m_204336_(BlockTags.f_13033_) && !creative && random.nextDouble() >= chance) {
                BlockState damaged = AnvilBlock.m_48824_((BlockState)state);
                if (damaged == null) {
                    world.m_7471_(pos, false);
                    world.m_46796_(1029, pos, 0);
                } else {
                    world.m_7731_(pos, damaged, 2);
                    world.m_46796_(1030, pos, 0);
                }
            } else {
                world.m_46796_(1030, pos, 0);
            }
        });
    }
}

