/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.data;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.generator.layout.ArchitectRoomEntry;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.crystal.layout.ArchitectCrystalLayout;
import iskallia.vault.item.crystal.layout.CompoundCrystalLayout;
import iskallia.vault.item.crystal.properties.CapacityCrystalProperties;
import iskallia.vault.item.crystal.properties.CrystalProperties;
import iskallia.vault.item.crystal.properties.InstabilityCrystalProperties;
import iskallia.vault.item.crystal.time.ValueCrystalTime;
import iskallia.vault.nbt.VListNBT;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;

public class InscriptionData
implements INBTSerializable<CompoundTag> {
    public static final String NBT_KEY = "data";
    public static final int MODELS = 23;
    private List<ResourceLocation> modifiers = new ArrayList<ResourceLocation>();
    private VListNBT<Entry, CompoundTag> entries = VListNBT.of(Entry::new);
    private Float completion;
    private Integer time;
    private Float instability;
    private Integer size;
    private int model;
    private Integer color;
    private boolean isSuper;
    private Integer echoCost;

    private InscriptionData() {
    }

    public static InscriptionData empty() {
        return new InscriptionData();
    }

    public static InscriptionData from(ItemStack stack) {
        InscriptionData data = new InscriptionData();
        if (stack.m_41782_()) {
            data.deserializeNBT(stack.m_41784_().m_128469_(NBT_KEY));
        }
        return data;
    }

    public InscriptionData write(ItemStack stack) {
        stack.m_41784_().m_128365_(NBT_KEY, (Tag)this.serializeNBT());
        return this;
    }

    public int getModel() {
        return this.model;
    }

    public Integer getColor() {
        return this.color;
    }

    public boolean isSuper() {
        return this.isSuper;
    }

    public void setSuper(boolean aSuper) {
        this.isSuper = aSuper;
    }

    public static InscriptionData createWithModifiers(InscriptionData base, List<ResourceLocation> modifiers) {
        base.setModifiers(modifiers);
        return base;
    }

    public List<ResourceLocation> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(List<ResourceLocation> modifiers) {
        this.modifiers = new ArrayList<ResourceLocation>(modifiers);
    }

    public void addModifier(ResourceLocation modifier) {
        if (!this.modifiers.contains(modifier)) {
            this.modifiers.add(modifier);
        }
    }

    public static InscriptionData createRandomSuper(int modifiers) {
        JavaRandom random = JavaRandom.ofNanoTime();
        InscriptionData data = new InscriptionData();
        data.setSuper(true);
        for (int i = 0; i < 1; ++i) {
            ArchitectRoomEntry.Type type = ArchitectRoomEntry.Type.values()[random.nextInt(ArchitectRoomEntry.Type.values().length)];
            int color = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case ArchitectRoomEntry.Type.COMMON -> 0xFFFFFF;
                case ArchitectRoomEntry.Type.CHALLENGE -> 0xFF55FF;
                case ArchitectRoomEntry.Type.OMEGA -> 0x55FF55;
            };
            data.add(type, 1, color);
        }
        data.setModel(random.nextInt(23));
        ResourceLocation pool = ModConfigs.PERSONAL_VAULT.getInscriptionModifierPool();
        for (int i = 0; i < modifiers; ++i) {
            VaultModifier<?> modifier = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(pool, 0, random).get(0);
            if (modifier == null) continue;
            data.addModifier(modifier.getId());
        }
        return data;
    }

    public Integer getEchoCost() {
        return this.echoCost;
    }

    public void setEchoCost(Integer aCost) {
        this.echoCost = aCost;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public InscriptionData add(ResourceLocation pool, int count, int color) {
        this.entries.add(new Entry(pool, null, count, color));
        return this;
    }

    public InscriptionData add(ArchitectRoomEntry.Type type, int count, int color) {
        this.entries.add(new Entry(null, type, count, color));
        return this;
    }

    public InscriptionData add(Entry entry) {
        this.entries.add(entry);
        return this;
    }

    public void setCompletion(float completion) {
        this.completion = Float.valueOf(completion);
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setInstability(float instability) {
        this.instability = Float.valueOf(instability);
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size != null ? this.size : 10;
    }

    public void setModel(int model) {
        this.model = model;
    }

    public void setColor(Integer color) {
        this.color = color;
    }

    public boolean apply(Player player, ItemStack stack, CrystalData crystal) {
        ISerializable<CompoundTag, JsonObject> uniform;
        Object entry2;
        ArchitectCrystalLayout architect;
        if (crystal.getProperties().isUnmodifiable()) {
            return false;
        }
        ArchitectCrystalLayout layout = CompoundCrystalLayout.get(crystal.getLayout(), ArchitectCrystalLayout.class);
        if (layout == null) {
            architect = new ArchitectCrystalLayout();
            crystal.setLayout(CompoundCrystalLayout.flatten(crystal.getLayout(), architect));
        } else {
            architect = layout;
        }
        for (Object entry2 : this.entries) {
            architect.add(entry2.toRoomEntry());
        }
        if (this.completion != null) {
            architect.addCompletion(this.completion.floatValue());
        }
        if (this.size != null && this.time != null && (entry2 = crystal.getTime()) instanceof ValueCrystalTime) {
            ValueCrystalTime data = (ValueCrystalTime)entry2;
            IntRoll intRoll = data.getRoll();
            if (intRoll instanceof IntRoll.Constant) {
                IntRoll.Constant constant = (IntRoll.Constant)intRoll;
                crystal.setTime(new ValueCrystalTime(IntRoll.ofConstant(constant.getCount() + this.time)));
            } else {
                intRoll = data.getRoll();
                if (intRoll instanceof IntRoll.Uniform) {
                    uniform = (IntRoll.Uniform)intRoll;
                    crystal.setTime(new ValueCrystalTime(IntRoll.ofUniform(((IntRoll.Uniform)uniform).getMin() + this.time, ((IntRoll.Uniform)uniform).getMax() + this.time)));
                }
            }
        }
        if ((uniform = crystal.getProperties()) instanceof InstabilityCrystalProperties) {
            InstabilityCrystalProperties properties = (InstabilityCrystalProperties)uniform;
            if (this.instability == null) {
                return false;
            }
            float instability = properties.getInstability();
            Random random = new Random();
            if (random.nextFloat() < instability && !stack.m_41619_()) {
                double instabilityAvoidanceChance = 0.0;
                if (random.nextDouble() > instabilityAvoidanceChance) {
                    if (random.nextFloat() < ModConfigs.VAULT_CRYSTAL.MODIFIER_STABILITY.exhaustProbability) {
                        VaultCrystalItem.scheduleTask(VaultCrystalItem.ExhaustTask.INSTANCE, stack);
                    } else {
                        VaultCrystalItem.scheduleTask(new VaultCrystalItem.AddModifiersTask(VaultMod.id("catalyst_curse"), 1), stack);
                    }
                }
            }
            properties.setInstability(instability + this.instability.floatValue());
        } else {
            CrystalProperties instability = crystal.getProperties();
            if (instability instanceof CapacityCrystalProperties) {
                CapacityCrystalProperties properties = (CapacityCrystalProperties)instability;
                Integer capacity = properties.getCapacity().orElse(null);
                Integer level = crystal.getProperties().getLevel().orElse(null);
                if (capacity == null || level == null) {
                    return false;
                }
                if (capacity < this.getSize()) {
                    ModConfigs.VAULT_MODIFIER_POOLS.getRandom(VaultMod.id("catalyst_curse"), level, JavaRandom.ofNanoTime()).forEach(modifier -> crystal.getModifiers().add(VaultModifierStack.of(modifier)));
                }
                properties.setSize(properties.getSize() + this.getSize());
            }
        }
        if (!stack.m_41619_()) {
            crystal.write(stack);
        }
        return true;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag entriesList = new ListTag();
        for (Entry entry : this.entries) {
            entriesList.add((Object)entry.serializeNBT());
        }
        nbt.m_128365_("entries", (Tag)entriesList);
        if (this.completion != null) {
            nbt.m_128350_("completion", this.completion.floatValue());
        }
        if (this.time != null) {
            nbt.m_128405_("time", this.time.intValue());
        }
        if (this.instability != null) {
            nbt.m_128350_("instability", this.instability.floatValue());
        }
        if (this.size != null) {
            nbt.m_128405_("size", this.size.intValue());
        }
        nbt.m_128405_("model", this.model);
        if (this.color != null) {
            nbt.m_128405_("color", this.color.intValue());
        }
        nbt.m_128379_("isSuper", this.isSuper);
        if (this.echoCost != null) {
            nbt.m_128405_("echoCost", this.echoCost.intValue());
        }
        if (!this.modifiers.isEmpty()) {
            ListTag modifiersList = new ListTag();
            for (ResourceLocation modifier : this.modifiers) {
                modifiersList.add((Object)StringTag.m_129297_((String)modifier.toString()));
            }
            nbt.m_128365_("modifiers", (Tag)modifiersList);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag entriesList = nbt.m_128437_("entries", 10);
        this.entries.clear();
        for (int i = 0; i < entriesList.size(); ++i) {
            Entry entry = new Entry();
            entry.deserializeNBT(entriesList.m_128728_(i));
            this.entries.add(entry);
        }
        this.completion = nbt.m_128441_("completion") ? Float.valueOf(nbt.m_128457_("completion")) : null;
        this.time = nbt.m_128441_("time") ? Integer.valueOf(nbt.m_128451_("time")) : null;
        this.instability = nbt.m_128441_("instability") ? Float.valueOf(nbt.m_128457_("instability")) : null;
        this.size = nbt.m_128441_("size") ? Integer.valueOf(nbt.m_128451_("size")) : null;
        this.model = nbt.m_128451_("model");
        this.isSuper = nbt.m_128441_("isSuper") && nbt.m_128471_("isSuper");
        this.echoCost = nbt.m_128441_("echoCost") ? Integer.valueOf(nbt.m_128451_("echoCost")) : null;
        this.modifiers.clear();
        if (nbt.m_128425_("modifiers", 9)) {
            ListTag modifiersList = nbt.m_128437_("modifiers", 8);
            for (int i = 0; i < modifiersList.size(); ++i) {
                this.modifiers.add(new ResourceLocation(modifiersList.m_128778_(i)));
            }
        }
        if (nbt.m_128425_("color", 3)) {
            this.color = nbt.m_128451_("color");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (this.completion != null) {
            tooltip.add((Component)new TextComponent("Completion: ").m_7220_((Component)new TextComponent(Math.round(this.completion.floatValue() * 100.0f) + "%").m_130948_(Style.f_131099_.m_178520_(4766456))));
        }
        if (this.time != null) {
            tooltip.add((Component)new TextComponent("Time: ").m_7220_((Component)new TextComponent(UIHelper.formatTimeString(this.time.intValue())).m_130940_(ChatFormatting.GRAY)));
        }
        if (this.instability != null) {
            tooltip.add((Component)new TextComponent("Instability: ").m_7220_((Component)new TextComponent("%.1f%%".formatted(Float.valueOf(this.instability.floatValue() * 100.0f))).m_130940_(ChatFormatting.RED)));
        }
        if (!this.isSuper) {
            tooltip.add((Component)new TextComponent("Size: ").m_7220_((Component)new TextComponent(String.valueOf(this.getSize())).m_130940_(ChatFormatting.RED)));
        }
        for (Entry entry : this.entries) {
            String roomStr = entry.count > 1 ? "Rooms" : "Room";
            MutableComponent txt = new TextComponent(" \u2022 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(entry.count)).m_130940_(ChatFormatting.GRAY)).m_130946_(" ").m_7220_(entry.toRoomEntry().getName()).m_7220_((Component)new TextComponent(" " + roomStr).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)txt);
        }
        if (!this.modifiers.isEmpty()) {
            for (ResourceLocation modifierId : this.modifiers) {
                VaultModifierRegistry.getOpt(modifierId).ifPresent(vaultModifier -> {
                    tooltip.add((Component)new TextComponent(" \u2022 " + vaultModifier.getDisplayName()).m_130948_(Style.f_131099_.m_131148_(vaultModifier.getDisplayTextColor())));
                    if (Screen.m_96638_()) {
                        tooltip.add((Component)new TextComponent("    " + vaultModifier.getDisplayDescription()).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                });
            }
        }
        if (this.echoCost != null) {
            tooltip.add((Component)new TextComponent("Echo Cost: ").m_7220_((Component)new TextComponent(String.valueOf(this.echoCost)).m_130940_(ChatFormatting.DARK_PURPLE)));
        }
    }

    public static class Entry
    implements INBTSerializable<CompoundTag> {
        @Expose
        private ResourceLocation pool;
        @Expose
        private ArchitectRoomEntry.Type type;
        @Expose
        public int count;
        @Expose
        public int color;

        public Entry() {
        }

        public Entry(ResourceLocation pool, ArchitectRoomEntry.Type type, int count, int color) {
            this.pool = pool;
            this.type = type;
            this.count = count;
            this.color = color;
        }

        public ArchitectRoomEntry toRoomEntry() {
            if (this.pool != null) {
                return (ArchitectRoomEntry)ArchitectRoomEntry.ofPool(this.pool, this.count).set(ArchitectRoomEntry.COLOR, this.color);
            }
            return (ArchitectRoomEntry)ArchitectRoomEntry.ofType(this.type, this.count).set(ArchitectRoomEntry.COLOR, this.color);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            if (this.pool != null) {
                nbt.m_128359_("pool", this.pool.toString());
            }
            if (this.type != null) {
                nbt.m_128405_("type", this.type.ordinal());
            }
            nbt.m_128405_("count", this.count);
            nbt.m_128405_("color", this.color);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            if (nbt.m_128441_("pool")) {
                this.pool = new ResourceLocation(nbt.m_128461_("pool"));
            }
            if (nbt.m_128441_("type")) {
                this.type = ArchitectRoomEntry.Type.values()[nbt.m_128451_("type")];
            }
            this.count = nbt.m_128451_("count");
            this.color = nbt.m_128451_("color");
        }
    }
}

