/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.gear;

import iskallia.vault.config.CharmConfig;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.charm.CharmEffect;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.gear.reader.DecimalModifierReader;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.core.DataTransferItem;
import iskallia.vault.item.gear.RecyclableItem;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.VHSmpUtil;
import iskallia.vault.world.data.DiscoveredTrinketsData;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Deprecated
public class CharmItem
extends BasicItem
implements ICurioItem,
DataTransferItem,
IdentifiableItem,
RecyclableItem {
    CharmConfig.Size size;
    private static final int crystalIngredientSize = 10;

    public CharmItem(ResourceLocation id, CharmConfig.Size size) {
        super(id, new Item.Properties().m_41491_(ModItems.GEAR_GROUP).m_41487_(1));
        this.size = size;
    }

    public static float getUsePercentage(ItemStack input) {
        if (input.m_41619_()) {
            return 0.0f;
        }
        if (input.m_41720_() instanceof CharmItem) {
            if (!CharmItem.isIdentified(input)) {
                return 1.0f;
            }
            return 1.0f - (float)CharmItem.getUsedVaults(input).size() / (float)CharmItem.getUses(input);
        }
        return 0.0f;
    }

    public int m_142158_(ItemStack pStack) {
        return Math.round(13.0f - (1.0f - CharmItem.getUsePercentage(pStack)) * 13.0f);
    }

    public int m_142159_(ItemStack pStack) {
        return Mth.m_14169_((float)Math.max(0.0f, CharmItem.getUsePercentage(pStack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_142522_(ItemStack pStack) {
        return CharmItem.isIdentified(pStack) && CharmItem.getUsePercentage(pStack) != 1.0f;
    }

    public int getColor() {
        if (this == ModItems.SMALL_CHARM) {
            return 11110389;
        }
        if (this == ModItems.LARGE_CHARM) {
            return 8935924;
        }
        if (this == ModItems.GRAND_CHARM) {
            return 7551734;
        }
        return 5640437;
    }

    public static Optional<CharmEffect<?>> getCharm(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof CharmItem)) {
            return Optional.empty();
        }
        CharmEffect<?> data = AttributeGearData.read(stack);
        return ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.CHARM_EFFECT);
    }

    public static int getUses(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof CharmItem)) {
            return 0;
        }
        return stack.m_41784_().m_128451_("vaultUses");
    }

    public static void setUses(ItemStack stack, int uses) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof CharmItem)) {
            return;
        }
        stack.m_41784_().m_128405_("vaultUses", uses);
    }

    public static boolean hasValue(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof CharmItem)) {
            return false;
        }
        return stack.m_41782_() && stack.m_41784_().m_128441_("charmValue");
    }

    public static float getValue(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof CharmItem)) {
            return 0.0f;
        }
        return stack.m_41784_().m_128457_("charmValue");
    }

    public static void setValue(ItemStack stack, float value) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof CharmItem)) {
            return;
        }
        stack.m_41784_().m_128350_("charmValue", value);
    }

    public static boolean hasUsesLeft(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof CharmItem)) {
            return false;
        }
        return CharmItem.getUses(stack) > CharmItem.getUsedVaults(stack).size();
    }

    public static List<UUID> getUsedVaults(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof CharmItem)) {
            return Collections.emptyList();
        }
        ListTag list = stack.m_41784_().m_128437_("usedVaults", 10);
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            if (!tag.m_128441_("id")) continue;
            ids.add(tag.m_128342_("id"));
        }
        return ids;
    }

    public static void addUsedVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof CharmItem)) {
            return;
        }
        ListTag list = stack.m_41784_().m_128437_("usedVaults", 10);
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("id", vaultId);
        list.add((Object)tag);
        stack.m_41784_().m_128365_("usedVaults", (Tag)list);
    }

    public static void addFreeUsedVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof CharmItem)) {
            return;
        }
        ListTag list = stack.m_41784_().m_128437_("freeUsedVaults", 10);
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("id", vaultId);
        list.add((Object)tag);
        stack.m_41784_().m_128365_("freeUsedVaults", (Tag)list);
    }

    public static boolean isUsableInVault(ItemStack stack, UUID vaultId) {
        return !stack.m_41619_() && stack.m_41720_() instanceof CharmItem && vaultId != null;
    }

    public static boolean isIdentified(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof CharmItem)) {
            return false;
        }
        VaultGearState data = AttributeGearData.read(stack);
        return ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED) == VaultGearState.IDENTIFIED;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        super.m_6787_(tab, items);
        if (!ModConfigs.isInitialized()) {
            return;
        }
    }

    public Component m_7626_(ItemStack stack) {
        if (!CharmItem.isIdentified(stack)) {
            return new TextComponent("Unidentified ").m_130948_(Style.f_131099_.m_178520_(this.getColor())).m_7220_((Component)super.m_7626_(stack).m_6881_());
        }
        return CharmItem.getCharm(stack).map(effect -> {
            CharmConfig.Charm cfg = effect.getCharmConfig();
            TextComponent cmp = new TextComponent(cfg.getName());
            cmp.m_130948_(Style.f_131099_.m_131148_(cfg.getComponentColor()));
            return cmp;
        }).orElseGet(() -> super.m_7626_(stack));
    }

    public static String getParticleLoc(ItemStack stack) {
        if (!CharmItem.isIdentified(stack)) {
            return null;
        }
        return CharmItem.getCharm(stack).map(effect -> effect.getCharmConfig().getParticleLoc()).orElse(null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        int totalUses = CharmItem.getUses(stack);
        int used = CharmItem.getUsedVaults(stack).size();
        int remaining = Math.max(totalUses - used, 0);
        MutableComponent usesTxt = new TextComponent("Uses: ").m_7220_((Component)new TextComponent(remaining + "/" + totalUses));
        tooltip.add((Component)usesTxt);
        CharmEffect<?> data = AttributeGearData.read(stack);
        ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.CHARM_EFFECT).ifPresent(charmEffect -> {
            DecimalModifierReader.Percentage percentage = (DecimalModifierReader.Percentage)((CharmEffect.Config)charmEffect.getCharmConfig().getConfig()).getAttribute().getReader();
            tooltip.add((Component)new TextComponent(Math.round(CharmItem.getValue(stack) * 100.0f) + "% " + percentage.getModifierName()).m_6270_(Style.f_131099_.m_178520_(percentage.getRgbColor())));
            tooltip.add((Component)new TextComponent("Size: ").m_7220_((Component)new TextComponent(String.valueOf(10))));
            tooltip.add(TextComponent.f_131282_);
        });
        MutableComponent slotsTooltip = new TranslatableComponent("curios.slot").m_130946_(": ").m_130940_(ChatFormatting.GOLD);
        TranslatableComponent type = new TranslatableComponent("curios.identifier.charm");
        type = type.m_130940_(ChatFormatting.YELLOW);
        slotsTooltip.m_7220_((Component)type);
        tooltip.add((Component)slotsTooltip);
    }

    public static int getCrystalIngredientSize() {
        return 10;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder defaultAction = super.m_7203_(world, player, hand);
        if (world.m_5776_()) {
            return defaultAction;
        }
        if (VHSmpUtil.isArenaWorld(world)) {
            return defaultAction;
        }
        if (this.tryStartIdentification(player, stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return defaultAction;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)entity;
            if (world instanceof ServerLevel && stack.m_41613_() > 1) {
                while (stack.m_41613_() > 1) {
                    stack.m_41774_(1);
                    ItemStack etching = stack.m_41777_();
                    etching.m_41764_(1);
                    MiscUtils.giveItem(sPlayer, etching);
                }
            }
            this.inventoryIdentificationTick((Player)sPlayer, stack);
        }
    }

    @Override
    public void tickRoll(ItemStack stack, @Nullable Player player) {
        CharmEffect<?> data = AttributeGearData.read(stack);
        Item item = stack.m_41720_();
        if (!(item instanceof CharmItem)) {
            return;
        }
        CharmItem charmItem = (CharmItem)item;
        CharmEffect<?> randomTrinket = ModConfigs.CHARM.getRandomTrinketSet(charmItem.size);
        if (randomTrinket != null) {
            ((AttributeGearData)((Object)data)).createOrReplaceAttributeValue(ModGearAttributes.CHARM_EFFECT, randomTrinket);
        }
        ((AttributeGearData)((Object)data)).write(stack);
    }

    @Override
    public void tickFinishRoll(ItemStack stack, @Nullable Player player, boolean identify) {
        Object data = AttributeGearData.read(stack);
        Optional<CharmEffect<?>> optCharmEffect = ((AttributeGearData)data).getFirstValue(ModGearAttributes.CHARM_EFFECT);
        if (optCharmEffect.isPresent()) {
            CharmEffect<?> trinketEffect = optCharmEffect.get();
            CharmItem.setUses(stack, trinketEffect.getCharmConfig().getRandomUses());
            CharmItem.setValue(stack, (float)trinketEffect.getCharmConfig().getRandomAffinity() / 100.0f);
            ((AttributeGearData)data).createOrReplaceAttributeValue(ModGearAttributes.STATE, (VaultGearState)VaultGearState.IDENTIFIED);
        } else {
            ((AttributeGearData)data).createOrReplaceAttributeValue(ModGearAttributes.STATE, (VaultGearState)VaultGearState.UNIDENTIFIED);
        }
        ((AttributeGearData)data).write(stack);
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            DiscoveredTrinketsData trinketData = DiscoveredTrinketsData.get(sPlayer.m_183503_().m_142572_());
            trinketData.discoverTrinketAndBroadcast(stack, (Player)sPlayer);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (!CharmItem.isIdentified(stack)) {
            return;
        }
        super.curioTick(slotContext, stack);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (!CharmItem.isIdentified(stack)) {
            return;
        }
        CharmItem.getCharm(stack).ifPresent(trinketEffect -> trinketEffect.onEquip(slotContext.entity(), stack));
        super.onEquip(slotContext, prevStack, stack);
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        super.onEquipFromUse(slotContext, stack);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent()) {
                return false;
            }
        }
        if (!CharmItem.isIdentified(stack)) {
            return false;
        }
        String slot = "charm";
        if (!slot.equals(slotContext.identifier())) {
            return false;
        }
        if (CuriosApi.getSlotHelper() != null && !CuriosApi.getSlotHelper().getSlotType(slot).map(ISlotType::isVisible).orElse(false).booleanValue()) {
            return false;
        }
        return super.canEquip(slotContext, stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (!CharmItem.isIdentified(stack)) {
            return;
        }
        CharmItem.getCharm(stack).ifPresent(trinketEffect -> trinketEffect.onUnEquip(slotContext.entity(), stack));
        super.onUnequip(slotContext, newStack, stack);
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent()) {
                return false;
            }
        }
        return super.canUnequip(slotContext, stack);
    }

    @Override
    public Optional<UUID> getUuid(ItemStack stack) {
        return AttributeGearData.readUUID(stack);
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return !input.m_41619_() && AttributeGearData.hasData(input);
    }

    @Override
    public VaultRecyclerConfig.RecyclerOutput getOutput(ItemStack input) {
        return ModConfigs.VAULT_RECYCLER.getRecyclingOutputOrDefault(input.m_41720_());
    }

    @Override
    public float getResultPercentage(ItemStack input) {
        if (input.m_41619_()) {
            return 0.0f;
        }
        if (!CharmItem.isIdentified(input)) {
            return 1.0f;
        }
        return 1.0f - (float)CharmItem.getUsedVaults(input).size() / (float)CharmItem.getUses(input);
    }
}

