/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.gear;

import iskallia.vault.config.gear.VaultEtchingConfig;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.VaultGearTooltipItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.render.EtchingItemRenderer;
import iskallia.vault.item.render.core.IManualModelLoading;
import iskallia.vault.util.TextUtil;
import iskallia.vault.world.data.DiscoveredModelsData;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EtchingItem
extends BasicItem
implements VaultGearItem,
VaultGearTooltipItem,
IManualModelLoading {
    public EtchingItem(ResourceLocation id) {
        super(id, new Item.Properties().m_41491_(ModItems.GEAR_GROUP).m_41487_(1));
    }

    public static Optional<ItemStack> create(ResourceLocation etchingId, VaultEtchingConfig.EtchingEntry entry, Random random, int level) {
        VaultGearTierConfig.AttributeGroup attributePool = entry.getAttributes();
        if (attributePool == null || attributePool.isEmpty()) {
            return Optional.empty();
        }
        WeightedList outcomes = new WeightedList();
        attributePool.forEach(group -> {
            if (group.getModifierGroup().isEmpty()) {
                return;
            }
            group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new VaultGearTierConfig.ModifierOutcome(tier, (VaultGearTierConfig.ModifierTierGroup)group), tier.getWeight()));
        });
        Optional<VaultGearModifier> modifierOptional = outcomes.getRandom(random).map(modifierOutcome -> modifierOutcome.makeModifier(random));
        if (modifierOptional.isEmpty()) {
            return Optional.empty();
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.ETCHING);
        VaultGearData data = VaultGearData.read(stack);
        data.addModifier(VaultGearModifier.AffixType.IMPLICIT, modifierOptional.get());
        data.createOrReplaceAttributeValue(ModGearAttributes.ETCHING, etchingId);
        data.setItemLevel(level);
        data.setState(VaultGearState.IDENTIFIED);
        data.write(stack);
        return Optional.of(stack);
    }

    public Component m_7626_(ItemStack stack) {
        VaultEtchingConfig.EtchingEntry entry;
        VaultGearData data = VaultGearData.read(stack);
        if (data.getState() != VaultGearState.IDENTIFIED) {
            return new TextComponent("Unidentified Etching").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));
        }
        if (!ModConfigs.isInitialized()) {
            return super.m_7626_(stack);
        }
        ResourceLocation etchingId = data.getAttributes(ModGearAttributes.ETCHING).findFirst().map(VaultGearAttributeInstance::getValue).orElse(null);
        if (etchingId != null && (entry = ModConfigs.ETCHINGS.getEtchingConfig(etchingId)) != null) {
            return new TextComponent("Etching: ").m_7220_((Component)new TextComponent(entry.getName()).m_130948_(Style.f_131099_.m_131148_(entry.getComponentColor())));
        }
        return super.m_7626_(stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        VaultGearData data = VaultGearData.read(stack);
        if (data.getState() != VaultGearState.IDENTIFIED || !ModConfigs.isInitialized()) {
            return;
        }
        ResourceLocation etchingId = data.getAttributes(ModGearAttributes.ETCHING).findFirst().map(VaultGearAttributeInstance::getValue).orElse(null);
        if (etchingId != null) {
            VaultEtchingConfig.EtchingEntry entry = ModConfigs.ETCHINGS.getEtchingConfig(etchingId);
            if (entry != null) {
                this.addTooltipItemLevel(data, stack, tooltip, this.getState(stack));
                tooltip.add((Component)TextUtil.applyColorTags(EtchingHelper.formatDescription(entry.getDescription(), EtchingHelper.getEtching(stack))));
            } else {
                tooltip.add((Component)new TextComponent("Unknown Etching").m_130940_(ChatFormatting.RED));
            }
        } else {
            tooltip.add((Component)new TextComponent("No Etching Applied").m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
    }

    @Override
    @NotNull
    public VaultGearClassification getClassification(ItemStack stack) {
        return VaultGearClassification.ETCHING;
    }

    @Override
    @NotNull
    public VaultGearType getGearType(ItemStack stack) {
        return VaultGearType.ETCHING;
    }

    @Override
    @Nullable
    public ResourceLocation getRandomModel(ItemStack stack, Random random, @Nullable Player player, @Nullable DiscoveredModelsData discoveredModelsData) {
        return null;
    }

    @Override
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        VaultEtchingConfig config = (VaultEtchingConfig)new VaultEtchingConfig().readConfig();
        ModConfigs.CONFIGS.remove(config);
        config.getEtchingConfigs().forEach(etchingEntry -> {
            String itemLocation = etchingEntry.getItemOverlay();
            if (itemLocation != null && !itemLocation.isEmpty()) {
                consumer.accept(new ModelResourceLocation(itemLocation));
            }
        });
    }

    public boolean m_5812_(ItemStack pStack) {
        return super.m_5812_(pStack);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return EtchingItemRenderer.INSTANCE;
            }
        });
    }
}

