/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.gear;

import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.config.TemporalShardConfig;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.objective.HeraldObjective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TemporalShardItem
extends BasicItem
implements IdentifiableItem {
    public TemporalShardItem(ResourceLocation id) {
        super(id, new Item.Properties().m_41491_(ModItems.GEAR_GROUP).m_41487_(1));
    }

    public static boolean isIdentified(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TemporalShardItem)) {
            return false;
        }
        VaultGearState data = AttributeGearData.read(stack);
        return ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED) == VaultGearState.IDENTIFIED;
    }

    public static void setModifierData(ItemStack stack, ResourceLocation modifier, int duration) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TemporalShardItem)) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("modifier", modifier.toString());
        tag.m_128405_("duration", duration);
    }

    public static ResourceLocation getModifier(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TemporalShardItem)) {
            return null;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("modifier")) {
            return new ResourceLocation(tag.m_128461_("modifier"));
        }
        return null;
    }

    public static int getDuration(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TemporalShardItem)) {
            return 0;
        }
        return stack.m_41784_().m_128451_("duration");
    }

    public static VaultModifier<?> getVaultModifier(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TemporalShardItem)) {
            return null;
        }
        ResourceLocation modifier = TemporalShardItem.getModifier(stack);
        if (modifier != null) {
            return VaultModifierRegistry.get(modifier);
        }
        return null;
    }

    public Component m_7626_(ItemStack stack) {
        if (this.getState(stack) == VaultGearState.UNIDENTIFIED) {
            return new TextComponent("Unidentified Temporal Relic").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE));
        }
        VaultModifier<?> modifier = TemporalShardItem.getVaultModifier(stack);
        if (modifier != null) {
            TextColor color = modifier.getDisplayTextColor();
            TextComponent component = new TextComponent("Temporal Relic: " + modifier.getDisplayName());
            return component.m_130948_(Style.f_131099_.m_131148_(color));
        }
        return super.m_7626_(stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (TemporalShardItem.isIdentified(stack)) {
            VaultModifier<?> vaultModifier = TemporalShardItem.getVaultModifier(stack);
            if (vaultModifier == null) {
                VaultGearState data = AttributeGearData.read(stack);
                ((AttributeGearData)((Object)data)).createOrReplaceAttributeValue(ModGearAttributes.STATE, (VaultGearState)VaultGearState.UNIDENTIFIED);
                return;
            }
            tooltip.add((Component)new TextComponent("Modifier: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(vaultModifier.getDisplayName()).m_130948_(Style.f_131099_.m_131148_(vaultModifier.getDisplayTextColor()))));
            if (Screen.m_96638_()) {
                tooltip.add((Component)new TextComponent("Description: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(vaultModifier.getDisplayDescription()).m_130940_(ChatFormatting.GRAY)));
            }
            tooltip.add((Component)new TextComponent("Duration: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(UIHelper.formatTimeString(TemporalShardItem.getDuration(stack))).m_130948_(Style.f_131099_.m_131148_(vaultModifier.getDisplayTextColor()))));
            tooltip.add((Component)new TextComponent("Consume this relic to gain its effects").m_130940_(ChatFormatting.GRAY));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder defaultAction = super.m_7203_(level, player, hand);
        if (level.m_5776_()) {
            return defaultAction;
        }
        if (this.tryStartIdentification(player, stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (TemporalShardItem.isIdentified(stack)) {
            ServerVaults.get(player.f_19853_).ifPresent(vault -> {
                if (!vault.get(Vault.OBJECTIVES).getAll(HeraldObjective.class).isEmpty()) {
                    return;
                }
                int duration = TemporalShardItem.getDuration(stack);
                ResourceLocation modifier = TemporalShardItem.getModifier(stack);
                stack.m_41774_(1);
                Object vaultModifier = VaultModifierRegistry.get(modifier);
                if (vaultModifier != null) {
                    JavaRandom random = JavaRandom.ofNanoTime();
                    vault.get(Vault.MODIFIERS).addModifier((VaultModifier<?>)vaultModifier, 1, true, random, context -> {
                        if (duration > 0) {
                            context.set(ModifierContext.TICKS_LEFT, duration);
                        }
                    });
                    MutableComponent text = new TextComponent("").m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_(((VaultModifier)vaultModifier).getChatDisplayNameComponent(1)).m_7220_((Component)new TextComponent(" for ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(TemporalShardItem.formatTime(duration / 20))).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
                    for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                        listener.getPlayer().ifPresent(arg_0 -> TemporalShardItem.lambda$use$1(listener, level, (Component)text, arg_0));
                    }
                }
            });
        }
        return defaultAction;
    }

    public static String formatTime(int seconds) {
        String formattedTime;
        if (seconds < 60) {
            formattedTime = seconds + (seconds == 1 ? " second" : " seconds");
        } else {
            int minutes = seconds / 60;
            int remainingSeconds = seconds % 60;
            formattedTime = minutes + (minutes == 1 ? " minute" : " minutes");
            if (remainingSeconds > 0) {
                formattedTime = formattedTime + " " + remainingSeconds + (remainingSeconds == 1 ? " second" : " seconds");
            }
        }
        return formattedTime;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, level, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            this.inventoryIdentificationTick((Player)serverPlayer, stack);
        }
    }

    @Override
    public void tickRoll(ItemStack stack, @Nullable Player player) {
        TemporalShardConfig.ModifierInfo modifierInfo;
        JavaRandom random = JavaRandom.ofNanoTime();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int playerLevel = SidedHelper.getVaultLevel((Player)serverPlayer);
            modifierInfo = ModConfigs.TEMPORAL_SHARD.getRandomModifier(playerLevel, random);
        } else {
            modifierInfo = ModConfigs.TEMPORAL_SHARD.getRandomModifier(0, random);
        }
        TemporalShardItem.setModifierData(stack, modifierInfo.getId(), modifierInfo.getDuration());
    }

    @Override
    public void tickFinishRoll(ItemStack stack, @Nullable Player player, boolean identify) {
        VaultGearState data = AttributeGearData.read(stack);
        ((AttributeGearData)((Object)data)).createOrReplaceAttributeValue(ModGearAttributes.STATE, (VaultGearState)VaultGearState.IDENTIFIED);
        ((AttributeGearData)((Object)data)).write(stack);
    }

    private static /* synthetic */ void lambda$use$1(Listener listener, Level level, Component text, ServerPlayer other) {
        if (!(listener instanceof Runner)) {
            return;
        }
        level.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
        other.m_5661_(text, false);
    }
}

