/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.gear;

import iskallia.vault.client.ClientPrestigePowersData;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.config.TrinketConfig;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.RoyaleObjective;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.core.DataTransferItem;
import iskallia.vault.item.gear.RecyclableItem;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.prestige.NoVaultUsesPrestigePower;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.VHSmpUtil;
import iskallia.vault.world.data.DiscoveredTrinketsData;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class TrinketItem
extends BasicItem
implements ICurioItem,
DataTransferItem,
RecyclableItem,
IdentifiableItem {
    public TrinketItem(ResourceLocation id) {
        super(id, new Item.Properties().m_41491_(ModItems.GEAR_GROUP).m_41487_(1));
    }

    public static ItemStack createRandomTrinket(TrinketEffect<?> trinket) {
        ItemStack stack = TrinketItem.createBaseTrinket(trinket);
        TrinketConfig.Trinket config = trinket.getTrinketConfig();
        if (config != null) {
            TrinketItem.setUses(stack, config.getRandomUses());
        }
        return stack;
    }

    public static float getUsePercentage(ItemStack input) {
        if (input.m_41619_()) {
            return 0.0f;
        }
        if (input.m_41720_() instanceof TrinketItem) {
            if (!TrinketItem.isIdentified(input)) {
                return 1.0f;
            }
            return 1.0f - (float)TrinketItem.getUsedVaults(input).size() / (float)TrinketItem.getUses(input);
        }
        return 0.0f;
    }

    public int m_142158_(ItemStack pStack) {
        return Math.round(13.0f - (1.0f - TrinketItem.getUsePercentage(pStack)) * 13.0f);
    }

    public int m_142159_(ItemStack pStack) {
        return Mth.m_14169_((float)(TrinketItem.getUsePercentage(pStack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_142522_(ItemStack pStack) {
        if (((IVaultOptions)Minecraft.m_91087_().f_91066_).getShowUsesAsStackSize()) {
            return false;
        }
        return TrinketItem.isIdentified(pStack) && TrinketItem.getUsePercentage(pStack) != 1.0f;
    }

    public static ItemStack createBaseTrinket(TrinketEffect<?> trinket) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.TRINKET);
        Object data = AttributeGearData.read(stack);
        ((AttributeGearData)data).createOrReplaceAttributeValue(ModGearAttributes.STATE, (VaultGearState)VaultGearState.IDENTIFIED);
        ((AttributeGearData)data).createOrReplaceAttributeValue(ModGearAttributes.TRINKET_EFFECT, trinket);
        ((AttributeGearData)data).write(stack);
        return stack;
    }

    public static Optional<String> getSlotIdentifier(ItemStack stack) {
        return TrinketItem.getTrinket(stack).map(TrinketEffect::getConfig).filter(TrinketEffect.Config::hasCuriosSlot).map(TrinketEffect.Config::getCuriosSlot);
    }

    public static Optional<TrinketEffect<?>> getTrinket(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return Optional.empty();
        }
        TrinketEffect<?> data = AttributeGearData.read(stack);
        return ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.TRINKET_EFFECT);
    }

    public static int getUses(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return 0;
        }
        return stack.m_41784_().m_128451_("vaultUses");
    }

    public static void setUses(ItemStack stack, int uses) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return;
        }
        stack.m_41784_().m_128405_("vaultUses", uses);
    }

    public static boolean hasUsesLeft(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return false;
        }
        return TrinketItem.getUses(stack) > TrinketItem.getUsedVaults(stack).size();
    }

    public static List<UUID> getUsedVaults(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return Collections.emptyList();
        }
        ListTag list = stack.m_41784_().m_128437_("usedVaults", 10);
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            ids.add(tag.m_128342_("id"));
        }
        return ids;
    }

    public static void addUsedVault(ItemStack stack, UUID vaultId) {
        if (stack == null || stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return;
        }
        ListTag list = stack.m_41784_().m_128437_("usedVaults", 10);
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("id", vaultId);
        list.add((Object)tag);
        stack.m_41784_().m_128365_("usedVaults", (Tag)list);
    }

    public static void addFreeUsedVault(ItemStack stack, UUID vaultId) {
        if (stack == null || stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return;
        }
        ListTag list = stack.m_41784_().m_128437_("freeUsedVaults", 10);
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("id", vaultId);
        list.add((Object)tag);
        stack.m_41784_().m_128365_("freeUsedVaults", (Tag)list);
    }

    public static boolean isUsableInVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem) || vaultId == null) {
            return false;
        }
        ListTag list = stack.m_41784_().m_128437_("usedVaults", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            if (!vaultId.equals(tag.m_128342_("id"))) continue;
            return true;
        }
        ListTag freeList = stack.m_41784_().m_128437_("freeUsedVaults", 10);
        for (int i = 0; i < freeList.size(); ++i) {
            CompoundTag tag = freeList.m_128728_(i);
            if (!vaultId.equals(tag.m_128342_("id"))) continue;
            return true;
        }
        return false;
    }

    public static boolean isIdentified(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return false;
        }
        VaultGearState data = AttributeGearData.read(stack);
        return ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED) == VaultGearState.IDENTIFIED;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        super.m_6787_(tab, items);
        if (!ModConfigs.isInitialized()) {
            return;
        }
        if (this.m_41389_(tab)) {
            TrinketEffectRegistry.getOrderedEntries().stream().map(TrinketItem::createRandomTrinket).forEach(arg_0 -> items.add(arg_0));
        }
    }

    public Component m_7626_(ItemStack stack) {
        if (!TrinketItem.isIdentified(stack)) {
            return super.m_7626_(stack).m_6881_().m_130948_(Style.f_131099_.m_178520_(16004495));
        }
        return TrinketItem.getTrinket(stack).map(effect -> {
            TrinketConfig.Trinket cfg = effect.getTrinketConfig();
            TextComponent cmp = new TextComponent(cfg.getName());
            cmp.m_130948_(Style.f_131099_.m_131148_(cfg.getComponentColor()));
            return cmp;
        }).orElseGet(() -> super.m_7626_(stack));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (!TrinketItem.isIdentified(stack)) {
            return;
        }
        if (ClientPrestigePowersData.getTree().getAll(NoVaultUsesPrestigePower.class, Skill::isUnlocked).stream().noneMatch(power -> power.getItemId().equals((Object)stack.m_41720_().getRegistryName()))) {
            int totalUses = TrinketItem.getUses(stack);
            int used = TrinketItem.getUsedVaults(stack).size();
            int remaining = Math.max(totalUses - used, 0);
            MutableComponent usesTxt = new TextComponent("Uses: ").m_7220_((Component)new TextComponent(String.valueOf(remaining)));
            tooltip.add((Component)usesTxt);
        }
        String data = AttributeGearData.read(stack);
        ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.CRAFTED_BY).ifPresent(crafter -> tooltip.add((Component)new TextComponent("Crafted by: ").m_7220_((Component)new TextComponent(crafter).m_6270_(Style.f_131099_.m_178520_(16770048)))));
        TrinketItem.getTrinket(stack).ifPresent(effect -> {
            TrinketConfig.Trinket cfg = effect.getTrinketConfig();
            for (TextComponent cmp : MiscUtils.splitDescriptionText(cfg.getEffectText())) {
                tooltip.add((Component)cmp.m_130940_(ChatFormatting.GRAY));
            }
        });
        TrinketItem.getSlotIdentifier(stack).ifPresent(slotIdentifier -> {
            MutableComponent slotsTooltip = new TranslatableComponent("curios.slot").m_130946_(": ").m_130940_(ChatFormatting.GOLD);
            TranslatableComponent type = new TranslatableComponent("curios.identifier." + slotIdentifier);
            type = type.m_130940_(ChatFormatting.YELLOW);
            slotsTooltip.m_7220_((Component)type);
            tooltip.add(TextComponent.f_131282_);
            tooltip.add((Component)slotsTooltip);
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder defaultAction = super.m_7203_(world, player, hand);
        if (world.m_5776_()) {
            return defaultAction;
        }
        if (VHSmpUtil.isArenaWorld(world)) {
            return defaultAction;
        }
        if (this.tryStartIdentification(player, stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return defaultAction;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)entity;
            if (world instanceof ServerLevel && stack.m_41613_() > 1) {
                while (stack.m_41613_() > 1) {
                    stack.m_41774_(1);
                    ItemStack etching = stack.m_41777_();
                    etching.m_41764_(1);
                    MiscUtils.giveItem(sPlayer, etching);
                }
            }
            this.inventoryIdentificationTick((Player)sPlayer, stack);
        }
    }

    @Override
    public void tickRoll(ItemStack stack, @Nullable Player player) {
        ServerPlayer sPlayer;
        DiscoveredTrinketsData trinketData;
        TrinketEffect<?> data = AttributeGearData.read(stack);
        TrinketEffect<?> randomTrinket = player instanceof ServerPlayer ? ((trinketData = DiscoveredTrinketsData.get((sPlayer = (ServerPlayer)player).m_183503_().m_142572_())).discoveredAllTrinkets((Player)sPlayer) ? ModConfigs.TRINKET.getRandomTrinketSet() : ModConfigs.TRINKET.getRandomTrinketSet((trinket, weight) -> {
            if (trinketData.hasDiscovered((Player)sPlayer, (TrinketEffect<?>)((Object)trinket))) {
                return Mth.m_14167_((float)((float)weight.intValue() * 0.16666667f));
            }
            return weight;
        })) : ModConfigs.TRINKET.getRandomTrinketSet();
        if (randomTrinket != null) {
            ((AttributeGearData)((Object)data)).createOrReplaceAttributeValue(ModGearAttributes.TRINKET_EFFECT, randomTrinket);
        }
        ((AttributeGearData)((Object)data)).write(stack);
    }

    @Override
    public void tickFinishRoll(ItemStack stack, @Nullable Player player, boolean identify) {
        Object data = AttributeGearData.read(stack);
        Optional<TrinketEffect<?>> optTrinketEffect = ((AttributeGearData)data).getFirstValue(ModGearAttributes.TRINKET_EFFECT);
        if (optTrinketEffect.isPresent()) {
            TrinketEffect<?> trinketEffect = optTrinketEffect.get();
            TrinketItem.setUses(stack, trinketEffect.getTrinketConfig().getRandomUses());
            ((AttributeGearData)data).createOrReplaceAttributeValue(ModGearAttributes.STATE, (VaultGearState)VaultGearState.IDENTIFIED);
        } else {
            ((AttributeGearData)data).createOrReplaceAttributeValue(ModGearAttributes.STATE, (VaultGearState)VaultGearState.UNIDENTIFIED);
        }
        ((AttributeGearData)data).write(stack);
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            if (identify) {
                DiscoveredTrinketsData trinketData = DiscoveredTrinketsData.get(sPlayer.m_183503_().m_142572_());
                trinketData.discoverTrinketAndBroadcast(stack, (Player)sPlayer);
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (!TrinketItem.isIdentified(stack)) {
            return;
        }
        Optional<String> id = TrinketItem.getSlotIdentifier(stack);
        if (id.isPresent()) {
            LivingEntity livingEntity;
            String identifier = id.get();
            if (!slotContext.identifier().equals(identifier) && (livingEntity = slotContext.entity()) instanceof Player) {
                Player player = (Player)livingEntity;
                if (!player.m_183503_().f_46443_) {
                    player.m_150109_().m_150079_(stack.m_41777_());
                    stack.m_41764_(0);
                }
            }
        }
        if (stack.m_41619_()) {
            return;
        }
        TrinketItem.getTrinket(stack).ifPresent(trinketEffect -> trinketEffect.onWornTick(slotContext.entity(), stack));
        super.curioTick(slotContext, stack);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (!TrinketItem.isIdentified(stack)) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent() && !ServerVaults.get(player.f_19853_).get().get(Vault.OBJECTIVES).getAll(RoyaleObjective.class).isEmpty()) {
                TrinketItem.addFreeUsedVault(stack, ServerVaults.get(player.f_19853_).get().get(Vault.ID));
            }
        }
        TrinketItem.getTrinket(stack).ifPresent(trinketEffect -> trinketEffect.onEquip(slotContext.entity(), stack));
        super.onEquip(slotContext, prevStack, stack);
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        super.onEquipFromUse(slotContext, stack);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent() && ServerVaults.get(player.f_19853_).get().get(Vault.OBJECTIVES).getAll(RoyaleObjective.class).isEmpty()) {
                return false;
            }
        }
        if (!TrinketItem.isIdentified(stack)) {
            return false;
        }
        String slot = TrinketItem.getSlotIdentifier(stack).orElse(null);
        if (slot == null || !slot.equals(slotContext.identifier())) {
            return false;
        }
        if (CuriosApi.getSlotHelper() != null && !CuriosApi.getSlotHelper().getSlotType(slot).map(ISlotType::isVisible).orElse(false).booleanValue()) {
            return false;
        }
        return super.canEquip(slotContext, stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (!TrinketItem.isIdentified(stack)) {
            return;
        }
        TrinketItem.getTrinket(stack).ifPresent(trinketEffect -> trinketEffect.onUnEquip(slotContext.entity(), stack));
        super.onUnequip(slotContext, newStack, stack);
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent()) {
                return false;
            }
        }
        return super.canUnequip(slotContext, stack);
    }

    @Override
    public Optional<UUID> getUuid(ItemStack stack) {
        return AttributeGearData.readUUID(stack);
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return !input.m_41619_() && AttributeGearData.hasData(input);
    }

    @Override
    public float getResultPercentage(ItemStack input) {
        if (input.m_41619_()) {
            return 0.0f;
        }
        if (!TrinketItem.isIdentified(input)) {
            return 1.0f;
        }
        return 1.0f - (float)TrinketItem.getUsedVaults(input).size() / (float)TrinketItem.getUses(input);
    }
}

