/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.client.ClientPrestigePowersData;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.config.gear.VaultGearCraftingConfig;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.objective.RoyaleObjective;
import iskallia.vault.gear.GearRollHelper;
import iskallia.vault.gear.GodCharmRollHelper;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.custom.RandomGodVaultModifierAttribute;
import iskallia.vault.gear.attribute.custom.effect.EffectAvoidanceListGearAttribute;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.CuriosGearItem;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.prestige.NoVaultUsesPrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.PlayerReputationData;
import iskallia.vault.world.data.ServerVaults;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class VaultCharmItem
extends BasicItem
implements VaultGearItem,
CuriosGearItem,
ICurioItem {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.##");

    public VaultCharmItem(ResourceLocation id) {
        super(id, new Item.Properties().m_41491_(ModItems.GEAR_GROUP).m_41487_(1));
    }

    public static float getUsePercentage(ItemStack input) {
        if (input.m_41619_() || !(input.m_41720_() instanceof VaultCharmItem)) {
            return 0.0f;
        }
        if (!VaultCharmItem.isIdentified(input)) {
            return 1.0f;
        }
        return 1.0f - (float)VaultCharmItem.getUsedVaults(input).size() / (float)VaultCharmItem.getUses(input);
    }

    public static Optional<ItemStack> getCharm(LivingEntity entity) {
        if (entity.m_5833_()) {
            return Optional.empty();
        }
        return CuriosApi.getCuriosHelper().getCuriosHandler(entity).map(handler -> handler).flatMap(handler -> handler.getStacksHandler("charm")).map(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStacks().getStackInSlot(i);
                if (!(stack.m_41720_() instanceof VaultCharmItem)) continue;
                return stack;
            }
            return null;
        }).map(stack -> {
            Player player;
            Vault vault;
            VaultGearData data = VaultGearData.read(stack);
            Vault vault2 = vault = entity.f_19853_.f_46443_ ? (Vault)ClientVaults.getActive().orElse(null) : (Vault)ServerVaults.get(entity.f_19853_).orElse(null);
            if (vault != null && VaultCharmItem.isUsableInVault(stack, vault.get(Vault.ID))) {
                return stack;
            }
            if (!VaultCharmItem.hasUsesLeft(stack)) {
                return null;
            }
            if (entity instanceof Player && SidedHelper.getVaultLevel(player = (Player)entity) < data.getItemLevel()) {
                return null;
            }
            return stack;
        });
    }

    public static boolean isUsable(ItemStack charmStack, Player player) {
        Vault vault;
        VaultGearData data = (VaultGearData)AttributeGearData.read(charmStack);
        if (data.getState() != VaultGearState.IDENTIFIED) {
            return false;
        }
        if (PrestigeHelper.getPrestige(player).getAll(NoVaultUsesPrestigePower.class, Skill::isUnlocked).stream().anyMatch(power -> power.getItemId().equals((Object)charmStack.m_41720_().getRegistryName()))) {
            return true;
        }
        Vault vault2 = vault = player.f_19853_.f_46443_ ? (Vault)ClientVaults.getActive().orElse(null) : (Vault)ServerVaults.get(player.f_19853_).orElse(null);
        if (vault == null) {
            return VaultCharmItem.hasUsesLeft(charmStack);
        }
        return VaultCharmItem.isUsableInVault(charmStack, vault.get(Vault.ID));
    }

    public static String getParticleLoc(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem)) {
            return "particle/charm";
        }
        VaultGearData data = VaultGearData.read(stack);
        VaultGod god = data.getFirstValue(ModGearAttributes.CHARM_VAULT_GOD).orElse(null);
        if (god != null) {
            return "particle/charm/" + god.m_7912_() + "/" + data.getRarity().name().toLowerCase();
        }
        return "particle/charm";
    }

    public int m_142158_(ItemStack pStack) {
        return Math.round(13.0f - (1.0f - VaultCharmItem.getUsePercentage(pStack)) * 13.0f);
    }

    public int m_142159_(ItemStack pStack) {
        return Mth.m_14169_((float)Math.max(0.0f, VaultCharmItem.getUsePercentage(pStack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_142522_(ItemStack pStack) {
        if (((IVaultOptions)Minecraft.m_91087_().f_91066_).getShowUsesAsStackSize()) {
            return false;
        }
        return VaultCharmItem.isIdentified(pStack) && VaultCharmItem.getUsePercentage(pStack) != 1.0f;
    }

    public static Optional<?> getBaseModifierValue(ItemStack stack, VaultGearModifier<?> modifier) {
        VaultGearModifier<?> baseModifier;
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem)) {
            return Optional.empty();
        }
        int storedReputation = VaultCharmItem.getGodReputation(stack);
        if (storedReputation <= 0) {
            return Optional.empty();
        }
        float inverseScaleFactor = 1.0f / (float)(storedReputation + 1);
        if (modifier.getValue() instanceof Number) {
            Object t = modifier.getValue();
            if (t instanceof Float) {
                Float floatValue = (Float)t;
                return Optional.of(Float.valueOf(floatValue.floatValue() * inverseScaleFactor));
            }
            t = modifier.getValue();
            if (t instanceof Integer) {
                Integer intValue = (Integer)t;
                return Optional.of(Float.valueOf((float)intValue.intValue() * inverseScaleFactor));
            }
            t = modifier.getValue();
            if (t instanceof Double) {
                Double doubleValue = (Double)t;
                return Optional.of(doubleValue * (double)inverseScaleFactor);
            }
        }
        if ((baseModifier = modifier.getAttribute().scaleValue(modifier, inverseScaleFactor)) != null) {
            return Optional.of(baseModifier.getValue());
        }
        return Optional.empty();
    }

    public static int getUses(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem)) {
            return 0;
        }
        return stack.m_41784_().m_128451_("vaultUses");
    }

    public static void setUses(ItemStack stack, int uses) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem)) {
            return;
        }
        stack.m_41784_().m_128405_("vaultUses", uses);
    }

    public static boolean hasUsesLeft(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem)) {
            return false;
        }
        return VaultCharmItem.getUses(stack) > VaultCharmItem.getUsedVaults(stack).size();
    }

    public static List<UUID> getUsedVaults(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem)) {
            return Collections.emptyList();
        }
        ListTag list = stack.m_41784_().m_128437_("usedVaults", 10);
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            if (!tag.m_128441_("id")) continue;
            ids.add(tag.m_128342_("id"));
        }
        return ids;
    }

    public static void addUsedVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem)) {
            return;
        }
        ListTag list = stack.m_41784_().m_128437_("usedVaults", 10);
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("id", vaultId);
        list.add((Object)tag);
        stack.m_41784_().m_128365_("usedVaults", (Tag)list);
    }

    public static void addFreeUsedVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return;
        }
        ListTag list = stack.m_41784_().m_128437_("freeUsedVaults", 10);
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("id", vaultId);
        list.add((Object)tag);
        stack.m_41784_().m_128365_("freeUsedVaults", (Tag)list);
    }

    public static boolean isUsableInVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem) || vaultId == null) {
            return false;
        }
        ListTag list = stack.m_41784_().m_128437_("usedVaults", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            if (!vaultId.equals(tag.m_128342_("id"))) continue;
            return true;
        }
        ListTag freeList = stack.m_41784_().m_128437_("freeUsedVaults", 10);
        for (int i = 0; i < freeList.size(); ++i) {
            CompoundTag tag = freeList.m_128728_(i);
            if (!vaultId.equals(tag.m_128342_("id"))) continue;
            return true;
        }
        return false;
    }

    public static boolean isIdentified(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem)) {
            return false;
        }
        VaultGearData data = (VaultGearData)AttributeGearData.read(stack);
        return data.getState() == VaultGearState.IDENTIFIED;
    }

    public static int getGodReputation(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem)) {
            return 0;
        }
        return stack.m_41784_().m_128451_("godReputation");
    }

    public static void setGodReputation(ItemStack stack, int reputation) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem)) {
            return;
        }
        stack.m_41784_().m_128405_("godReputation", reputation);
    }

    public static Optional<VaultGod> getGod(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem)) {
            return Optional.empty();
        }
        VaultGearData data = VaultGearData.read(stack);
        return data.getFirstValue(ModGearAttributes.CHARM_VAULT_GOD);
    }

    public static boolean shouldUpdateItem(ItemStack stack, Player player) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem)) {
            return false;
        }
        VaultGearData data = (VaultGearData)AttributeGearData.read(stack);
        if (data.getState() != VaultGearState.IDENTIFIED) {
            return false;
        }
        if (VaultCharmItem.getGodReputation(stack) > 50) {
            return false;
        }
        return VaultCharmItem.getGodReputation(stack) != PlayerReputationData.getReputation(player.m_142081_(), VaultCharmItem.getGod(stack).orElse(null));
    }

    public static void updateCharm(ItemStack stack, Player player) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultCharmItem)) {
            return;
        }
        VaultGearData data = (VaultGearData)AttributeGearData.read(stack);
        if (data.getState() != VaultGearState.IDENTIFIED) {
            return;
        }
        VaultGod god = VaultCharmItem.getGod(stack).orElse(null);
        if (god == null) {
            return;
        }
        int storedReputation = VaultCharmItem.getGodReputation(stack);
        int currentReputation = PlayerReputationData.getReputation(player.m_142081_(), god);
        if (currentReputation == storedReputation) {
            return;
        }
        if (storedReputation <= 0) {
            storedReputation = 0;
        }
        float scalingFactor = (float)(currentReputation + 1) / (float)(storedReputation + 1);
        ArrayList modifiers = new ArrayList(data.getModifiers(VaultGearModifier.AffixType.PREFIX));
        for (VaultGearModifier vaultGearModifier : modifiers) {
            VaultGearModifier<?> newModifier = vaultGearModifier.getAttribute().scaleValue(vaultGearModifier, scalingFactor);
            newModifier.setRolledTier(vaultGearModifier.getRolledTier());
            newModifier.setModifierGroup(vaultGearModifier.getModifierGroup());
            newModifier.setModifierIdentifier(vaultGearModifier.getModifierIdentifier());
            vaultGearModifier.getCategories().forEach(newModifier::addCategory);
            if (!VaultGearCraftingConfig.ProficiencyStep.isModifierAllowed(stack, newModifier.getModifierIdentifier())) continue;
            data.removeModifier(vaultGearModifier);
            data.addModifier(VaultGearModifier.AffixType.PREFIX, newModifier);
        }
        VaultCharmItem.setGodReputation(stack, currentReputation);
        data.write(stack);
    }

    public Component m_7626_(ItemStack stack) {
        VaultGod god;
        if (this.getState(stack) == VaultGearState.IDENTIFIED && (god = (VaultGod)VaultCharmItem.getGod(stack).orElse(null)) != null) {
            TranslatableComponent name = new TranslatableComponent(super.m_5671_(stack) + "." + god.m_7912_());
            return name.m_130948_(Style.f_131099_.m_131140_(god.getChatColor()));
        }
        return VaultGearHelper.getDisplayName(stack, super.m_7626_(stack));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder defaultAction = super.m_7203_(world, player, hand);
        if (world.m_5776_()) {
            return defaultAction;
        }
        if (this.tryStartIdentification(player, stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return defaultAction;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            this.vaultGearTick(stack, serverPlayer);
            if (world.m_46467_() % 10L == 0L) {
                if (!stack.m_41784_().m_128441_("godReputation")) {
                    VaultCharmItem.setGodReputation(stack, 0);
                }
                if (VaultCharmItem.shouldUpdateItem(stack, (Player)serverPlayer)) {
                    VaultCharmItem.updateCharm(stack, (Player)serverPlayer);
                }
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        List<VaultGearModifier<?>> prefixes;
        if (this.getState(stack) == VaultGearState.IDENTIFIED && ClientPrestigePowersData.getTree().getAll(NoVaultUsesPrestigePower.class, Skill::isUnlocked).stream().noneMatch(power -> power.getItemId().equals((Object)stack.m_41720_().getRegistryName()))) {
            int totalUses = VaultCharmItem.getUses(stack);
            int used = VaultCharmItem.getUsedVaults(stack).size();
            int remaining = Math.max(totalUses - used, 0);
            MutableComponent usesTxt = new TextComponent("Uses: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(remaining)).m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)usesTxt);
        }
        int reputation = VaultCharmItem.getGodReputation(stack);
        MutableComponent reputationTxt = new TextComponent("Reputation: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(reputation)).m_130940_(ChatFormatting.WHITE));
        tooltip.add((Component)reputationTxt);
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        boolean shiftDown = InputConstants.m_84830_((long)window, (int)340) || InputConstants.m_84830_((long)window, (int)344);
        VaultGearData data = VaultGearData.read(stack);
        VaultGearState state = data.getState();
        if (VaultCharmItem.getGod(stack).isPresent()) {
            VaultGod god = VaultCharmItem.getGod(stack).get();
            MutableComponent godTxt = new TextComponent("Vault God: ").m_7220_((Component)new TextComponent(god.getName()).m_130948_(Style.f_131099_.m_131140_(god.getChatColor())));
            tooltip.add((Component)godTxt);
        }
        if (shiftDown || state == VaultGearState.UNIDENTIFIED) {
            this.addTooltipRarity(data, stack, tooltip, state);
        }
        if (state == VaultGearState.IDENTIFIED && !(prefixes = data.getModifiers(VaultGearModifier.AffixType.PREFIX)).isEmpty()) {
            this.addTooltipAffixGroupWithBaseValue(data, VaultGearModifier.AffixType.PREFIX, stack, tooltip, GearTooltip.itemTooltip().displayModifierDetail(), shiftDown);
            tooltip.add(TextComponent.f_131282_);
        }
    }

    public void addTooltipAffixGroupWithBaseValue(VaultGearData data, VaultGearModifier.AffixType type, ItemStack stack, List<Component> tooltip, boolean displayDetails, boolean showBaseValue) {
        List<VaultGearModifier<?>> affixes = data.getModifiers(type);
        VaultGearAttribute<Integer> affixAttribute = type == VaultGearModifier.AffixType.PREFIX ? ModGearAttributes.PREFIXES : ModGearAttributes.SUFFIXES;
        int emptyAffixes = data.getFirstValue(affixAttribute).orElse(0);
        if (displayDetails) {
            tooltip.add((Component)new TextComponent(type.getPlural() + ":").m_130940_(ChatFormatting.GRAY));
        }
        if (showBaseValue && type == VaultGearModifier.AffixType.PREFIX) {
            VaultGod god = VaultCharmItem.getGod(stack).orElse(null);
            for (VaultGearModifier<?> modifier2 : affixes) {
                Optional<MutableComponent> displayOpt = modifier2.getDisplay(data, type, stack, displayDetails);
                if (displayOpt.isEmpty()) continue;
                MutableComponent original = displayOpt.get();
                MutableComponent enhancedDisplay = original.m_6881_();
                Optional<?> baseValueOpt = VaultCharmItem.getBaseModifierValue(stack, modifier2);
                Object value = modifier2.getValue();
                int repMax = Math.max(1, VaultCharmItem.getGodReputation(stack) + 1);
                if (value instanceof Float) {
                    currentValue = ((Float)value).floatValue();
                    baseValue = baseValueOpt.map(val -> (Float)val).orElse(Float.valueOf(currentValue / (float)repMax)).floatValue();
                    enhancedDisplay.m_7220_((Component)new TextComponent(String.format(" (+%.1f%% Per Reputation)", Float.valueOf(baseValue * 100.0f))).m_130940_(ChatFormatting.GRAY));
                } else if (value instanceof Double) {
                    double currentValue = (Double)value;
                    double baseValue = baseValueOpt.map(val -> (Double)val).orElse(currentValue / (double)repMax);
                    enhancedDisplay.m_7220_((Component)new TextComponent(String.format(" (+%.1f%% Per Reputation)", baseValue * 100.0)).m_130940_(ChatFormatting.GRAY));
                } else if (value instanceof Integer) {
                    int currentValue = (Integer)value;
                    int baseValue = baseValueOpt.map(val -> (Integer)val).orElse(currentValue / repMax);
                    enhancedDisplay.m_7220_((Component)new TextComponent(String.format(" (+%d Per Reputation)", baseValue)).m_130940_(ChatFormatting.GRAY));
                } else if (value instanceof RandomGodVaultModifierAttribute) {
                    RandomGodVaultModifierAttribute attr = (RandomGodVaultModifierAttribute)value;
                    float inverseScaleFactor = 1.0f / (float)repMax;
                    enhancedDisplay.m_7220_((Component)new TextComponent(String.format(" (+%s seconds per reputation)", FORMAT.format((float)attr.getTime() * inverseScaleFactor / 20.0f))).m_130940_(ChatFormatting.GRAY));
                } else if (value instanceof EffectAvoidanceListGearAttribute) {
                    EffectAvoidanceListGearAttribute attr = (EffectAvoidanceListGearAttribute)value;
                    currentValue = attr.getChance();
                    if (baseValueOpt.isPresent()) {
                        Object baseObj = baseValueOpt.get();
                        if (baseObj instanceof Float) {
                            baseValue = ((Float)baseObj).floatValue();
                        } else if (baseObj instanceof EffectAvoidanceListGearAttribute) {
                            EffectAvoidanceListGearAttribute baseAttr = (EffectAvoidanceListGearAttribute)baseObj;
                            baseValue = baseAttr.getChance();
                        } else {
                            baseValue = currentValue / (float)repMax;
                        }
                    } else {
                        baseValue = currentValue / (float)repMax;
                    }
                    enhancedDisplay.m_7220_((Component)new TextComponent(String.format(" (+%.1f%% Per Reputation)", Float.valueOf(baseValue * 100.0f))).m_130940_(ChatFormatting.GRAY));
                }
                enhancedDisplay.m_6270_(original.m_7383_());
                tooltip.add((Component)enhancedDisplay);
            }
        } else {
            affixes.forEach(modifier -> modifier.getDisplay(data, type, stack, displayDetails).ifPresent(tooltip::add));
        }
        if (displayDetails && type != VaultGearModifier.AffixType.IMPLICIT) {
            for (int i = 0; i < emptyAffixes - affixes.size(); ++i) {
                tooltip.add(this.addTooltipEmptyAffixes(type));
            }
        }
    }

    @Override
    public Component addTooltipEmptyAffixes(VaultGearModifier.AffixType type) {
        return new TextComponent("- Empty " + type.getSingular() + " -").m_130940_(ChatFormatting.DARK_GRAY);
    }

    @Override
    public void addTooltipRarity(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
        if (data == null || !ModConfigs.isInitialized()) {
            return;
        }
        switch (state) {
            case UNIDENTIFIED: {
                data.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE).flatMap(ModConfigs.VAULT_GEAR_TYPE_CONFIG::getRollPool).ifPresent(pool -> tooltip.add((Component)new TextComponent("Roll: ").m_7220_((Component)new TextComponent(pool.getName()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)pool.getColor()))))));
                break;
            }
            case IDENTIFIED: {
                MutableComponent rarityText = new TextComponent("Rarity: ").m_7220_((Component)data.getRarity().getDisplayName().m_6881_().m_130948_(Style.f_131099_.m_131148_(data.getRarity().getColor())));
                tooltip.add((Component)rarityText);
            }
        }
    }

    @Override
    public boolean tryStartIdentification(Player player, ItemStack stack) {
        if (this.getState(stack) != VaultGearState.UNIDENTIFIED) {
            return false;
        }
        if (player.m_21120_(InteractionHand.OFF_HAND).m_150930_((Item)ModItems.IDENTIFICATION_TOME)) {
            this.instantIdentify(player, stack);
            return true;
        }
        this.setState(stack, VaultGearState.ROLLING);
        return true;
    }

    @Override
    public void inventoryIdentificationTick(Player player, ItemStack stack) {
        if (this.getState(stack) == VaultGearState.ROLLING) {
            GearRollHelper.tickToll(stack, player, (tickStack, tickPlayer) -> this.tickRoll((ItemStack)tickStack, (Player)tickPlayer), finishStack -> this.tickFinishRoll((ItemStack)finishStack, player));
        }
    }

    @Override
    public void tickRoll(ItemStack stack, @Nullable Player player) {
        GodCharmRollHelper.tickGearRoll(stack, player);
    }

    @Override
    public void tickFinishRoll(ItemStack stack, @Nullable Player player, boolean identify) {
        VaultGearData data = VaultGearData.read(stack);
        data.setState(VaultGearState.IDENTIFIED);
        data.write(stack);
        GodCharmRollHelper.initializeGodCharm(stack, player);
    }

    @Override
    public void instantIdentify(@Nullable Player player, ItemStack stack) {
        if (this.getState(stack) == VaultGearState.UNIDENTIFIED) {
            this.tickRoll(stack, player);
            this.tickFinishRoll(stack, player);
        }
    }

    @Override
    @NotNull
    public VaultGearClassification getClassification(ItemStack stack) {
        return VaultGearClassification.CHARM;
    }

    @Override
    @NotNull
    public VaultGearType getGearType(ItemStack stack) {
        return VaultGearType.CHARM;
    }

    @Override
    @Nullable
    public ResourceLocation getRandomModel(ItemStack stack, Random random, @Nullable Player player, @Nullable DiscoveredModelsData discoveredModelsData) {
        return null;
    }

    @Override
    public Optional<UUID> getUuid(ItemStack stack) {
        return VaultGearData.readUUID(stack);
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return !input.m_41619_() && VaultGearData.hasData(input);
    }

    @Override
    public VaultRecyclerConfig.RecyclerOutput getOutput(ItemStack input) {
        return ModConfigs.VAULT_RECYCLER.getRecyclingOutputOrDefault(input.m_41720_());
    }

    @Override
    public float getResultPercentage(ItemStack input) {
        if (input.m_41619_()) {
            return 0.0f;
        }
        if (!VaultCharmItem.isIdentified(input)) {
            return 1.0f;
        }
        return 1.0f - (float)VaultCharmItem.getUsedVaults(input).size() / (float)VaultCharmItem.getUses(input);
    }

    @Override
    public boolean isIntendedSlot(ItemStack stack, String slot) {
        return "charm".equals(slot);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext context, UUID uuid, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_36335_().m_41519_(stack.m_41720_())) {
            return ImmutableMultimap.of();
        }
        if (!VaultCharmItem.hasUsesLeft(stack)) {
            return ImmutableMultimap.of();
        }
        return "charm".equals(context.identifier()) ? VaultGearHelper.getModifiers(VaultGearData.read(stack)) : ImmutableMultimap.of();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (!VaultCharmItem.isIdentified(stack)) {
            return;
        }
        super.curioTick(slotContext, stack);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (!VaultCharmItem.isIdentified(stack)) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent() && !ServerVaults.get(player.f_19853_).get().get(Vault.OBJECTIVES).getAll(RoyaleObjective.class).isEmpty()) {
                VaultCharmItem.addFreeUsedVault(stack, ServerVaults.get(player.f_19853_).get().get(Vault.ID));
            }
        }
        super.onEquip(slotContext, prevStack, stack);
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        super.onEquipFromUse(slotContext, stack);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent() && ServerVaults.get(player.f_19853_).get().get(Vault.OBJECTIVES).getAll(RoyaleObjective.class).isEmpty()) {
                return false;
            }
        }
        if (!VaultCharmItem.isIdentified(stack)) {
            return false;
        }
        String slot = "charm";
        if (!slot.equals(slotContext.identifier())) {
            return false;
        }
        if (CuriosApi.getSlotHelper() != null && !CuriosApi.getSlotHelper().getSlotType(slot).map(ISlotType::isVisible).orElse(false).booleanValue()) {
            return false;
        }
        return super.canEquip(slotContext, stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (!VaultCharmItem.isIdentified(stack)) {
            return;
        }
        super.onUnequip(slotContext, newStack, stack);
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent()) {
                return false;
            }
        }
        return super.canUnequip(slotContext, stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return VaultGearHelper.shouldPlayGearReequipAnimation(oldStack, newStack, slotChanged);
    }

    @Override
    public void addTooltipDurability(List<Component> tooltip, ItemStack stack) {
    }

    @Override
    public void addTooltipGearModel(VaultGearData data, ItemStack stack, List<Component> tooltip) {
    }

    @Override
    public void addRepairTooltip(List<Component> tooltip, int usedRepairs, int totalRepairs) {
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        return Collections.emptyList();
    }
}

