/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.config.AbilitiesGUIConfig;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.RoyaleObjective;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.UsesGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.CuriosGearItem;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.gear.IStaticRarity;
import iskallia.vault.item.gear.VaultNecklaceItemRenderer;
import iskallia.vault.item.render.core.IManualModelLoading;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.prestige.NoVaultUsesPrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.ServerVaults;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class VaultNecklaceItem
extends Item
implements VaultGearItem,
CuriosGearItem,
ICurioItem,
IStaticRarity,
IManualModelLoading {
    public static final String SLOT = "necklace";

    public VaultNecklaceItem(ResourceLocation id) {
        super(new Item.Properties().m_41491_(ModItems.GEAR_GROUP).m_41487_(1));
        this.setRegistryName(id);
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public static float getUsePercentage(ItemStack input) {
        if (input.m_41619_()) {
            return 0.0f;
        }
        if (input.m_41720_() instanceof VaultNecklaceItem) {
            VaultGearState state;
            VaultGearState data = AttributeGearData.read(input);
            if (data instanceof VaultGearData) {
                VaultGearData gearData = (VaultGearData)((Object)data);
                state = gearData.getState();
            } else {
                state = ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED);
            }
            if (state != VaultGearState.IDENTIFIED) {
                return 1.0f;
            }
            return 1.0f - (float)VaultNecklaceItem.getUsedVaults(input).size() / (float)VaultNecklaceItem.getUses(input);
        }
        return 0.0f;
    }

    public int m_142158_(ItemStack pStack) {
        return Math.round(13.0f - (1.0f - VaultNecklaceItem.getUsePercentage(pStack)) * 13.0f);
    }

    public int m_142159_(ItemStack pStack) {
        return Mth.m_14169_((float)(VaultNecklaceItem.getUsePercentage(pStack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_142522_(ItemStack pStack) {
        if (((IVaultOptions)Minecraft.m_91087_().f_91066_).getShowUsesAsStackSize()) {
            return false;
        }
        return this.getState(pStack) == VaultGearState.IDENTIFIED && VaultNecklaceItem.getUsePercentage(pStack) != 1.0f;
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return super.getDefaultTooltipHideFlags(stack) | ItemStack.TooltipPart.MODIFIERS.m_41809_();
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        return Collections.emptyList();
    }

    public static int getUses(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultNecklaceItem)) {
            return 0;
        }
        UsesGearData data = (UsesGearData)AttributeGearData.read(stack);
        return data.getVaultUses();
    }

    public static void setUses(ItemStack stack, int uses) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultNecklaceItem)) {
            return;
        }
        UsesGearData data = (UsesGearData)AttributeGearData.read(stack);
        data.setVaultUses(uses);
        data.write(stack);
    }

    public static List<UUID> getUsedVaults(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultNecklaceItem)) {
            return Collections.emptyList();
        }
        UsesGearData data = (UsesGearData)AttributeGearData.read(stack);
        return data.getUsedVaults();
    }

    public static List<UUID> getFreeUsedVaults(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultNecklaceItem)) {
            return Collections.emptyList();
        }
        UsesGearData data = (UsesGearData)AttributeGearData.read(stack);
        return data.getFreeVaultUses();
    }

    public static void addUsedVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultNecklaceItem)) {
            return;
        }
        UsesGearData data = (UsesGearData)AttributeGearData.read(stack);
        data.getUsedVaults().add(vaultId);
        data.write(stack);
    }

    public static void addFreeUsedVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultNecklaceItem)) {
            return;
        }
        UsesGearData data = (UsesGearData)AttributeGearData.read(stack);
        data.getFreeVaultUses().add(vaultId);
        data.write(stack);
    }

    public boolean isStackIdentified(ItemStack stack) {
        return VaultNecklaceItem.isIdentified(stack);
    }

    public static boolean hasUsesLeft(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultNecklaceItem)) {
            return false;
        }
        return VaultNecklaceItem.getUses(stack) > VaultNecklaceItem.getUsedVaults(stack).size();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext context, UUID uuid, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_36335_().m_41519_(stack.m_41720_())) {
            return ImmutableMultimap.of();
        }
        if (!VaultNecklaceItem.hasUsesLeft(stack)) {
            return ImmutableMultimap.of();
        }
        return SLOT.equals(context.identifier()) ? VaultGearHelper.getModifiers(VaultGearData.read(stack)) : ImmutableMultimap.of();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return VaultGearHelper.shouldPlayGearReequipAnimation(oldStack, newStack, slotChanged);
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6881_().m_130948_(Style.f_131099_.m_178520_(3536064));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.getState(stack) == VaultGearState.IDENTIFIED) {
            int totalUses = VaultNecklaceItem.getUses(stack);
            int used = VaultNecklaceItem.getUsedVaults(stack).size();
            int remaining = Math.max(totalUses - used, 0);
            MutableComponent usesTxt = new TextComponent("Uses: ").m_7220_((Component)new TextComponent(String.valueOf(remaining)));
            tooltip.add((Component)usesTxt);
        }
        tooltip.addAll(this.createTooltip(stack, GearTooltip.itemTooltip()));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        EquipmentSlot slot;
        ItemStack heldStack = player.m_21120_(hand);
        InteractionResultHolder defaultAction = this.canEquip(heldStack, slot = Mob.m_147233_((ItemStack)heldStack), (Entity)player) ? super.m_7203_(level, player, hand) : InteractionResultHolder.m_19100_((Object)heldStack);
        return VaultGearHelper.rightClick(level, player, hand, (InteractionResultHolder<ItemStack>)defaultAction);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, level, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            this.vaultGearTick(stack, serverPlayer);
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (!VaultNecklaceItem.isIdentified(stack)) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent() && !ServerVaults.get(player.f_19853_).get().get(Vault.OBJECTIVES).getAll(RoyaleObjective.class).isEmpty()) {
                VaultNecklaceItem.addFreeUsedVault(stack, ServerVaults.get(player.f_19853_).get().get(Vault.ID));
            }
        }
        super.onEquip(slotContext, prevStack, stack);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        ServerPlayer player;
        PlayerVaultStatsData stats;
        int level;
        if (VaultGearData.read(stack).getState() != VaultGearState.IDENTIFIED) {
            return false;
        }
        if (!slotContext.identifier().equals(SLOT)) {
            return false;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer && (level = (stats = PlayerVaultStatsData.get((player = (ServerPlayer)livingEntity).m_183503_())).getVaultStats((Player)player).getVaultLevel()) < VaultGearData.read(stack).getItemLevel()) {
            return false;
        }
        return super.canEquip(slotContext, stack);
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return !input.m_41619_() && AttributeGearData.hasData(input);
    }

    @Override
    public VaultRecyclerConfig.RecyclerOutput getOutput(ItemStack input) {
        return ModConfigs.VAULT_RECYCLER.getRecyclingOutputOrDefault(this.getRegistryName());
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent()) {
                return false;
            }
        }
        return super.canUnequip(slotContext, stack);
    }

    @Override
    public ResourceLocation getRandomModel(ItemStack stack, Random random, @Nullable Player player, @Nullable DiscoveredModelsData discoveredModelsData) {
        VaultGearData data = VaultGearData.read(stack);
        return ModConfigs.VAULT_NECKLACE.getRandomModel(random);
    }

    @Override
    public void addTooltipRarity(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
    }

    @Override
    @NotNull
    public VaultGearClassification getClassification(ItemStack stack) {
        return VaultGearClassification.NECKLACE;
    }

    @Override
    @NotNull
    public VaultGearType getGearType(ItemStack stack) {
        return VaultGearType.NECKLACE;
    }

    @Override
    public boolean isIntendedSlot(ItemStack stack, String slot) {
        return SLOT.equals(slot);
    }

    public static boolean isIdentified(ItemStack stack) {
        VaultGearState data = AttributeGearData.read(stack);
        if (data instanceof VaultGearData) {
            VaultGearData gearData = (VaultGearData)((Object)data);
            return gearData.getState().equals((Object)VaultGearState.IDENTIFIED);
        }
        return ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED).equals((Object)VaultGearState.IDENTIFIED);
    }

    @Override
    public void addTooltipDurability(List<Component> tooltip, ItemStack stack) {
    }

    @Override
    public void addRepairTooltip(List<Component> tooltip, int usedRepairs, int totalRepairs) {
    }

    public void m_6787_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            VaultGearData data = VaultGearData.read(stack);
            data.setState(VaultGearState.UNIDENTIFIED);
            data.write(stack);
            items.add((Object)stack);
        }
    }

    @Override
    public void tickFinishRoll(ItemStack stack, @Nullable Player player, boolean identify) {
        VaultGearItem.super.tickFinishRoll(stack, player, identify);
        VaultNecklaceItem.setUses(stack, ModConfigs.VAULT_NECKLACE.getUses(JavaRandom.ofNanoTime()));
    }

    @Override
    public void addTooltipCraftingPotential(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
    }

    @Override
    public void addTooltipGearModel(VaultGearData data, ItemStack stack, List<Component> tooltip) {
    }

    @Override
    public VaultGearRarity getStaticRarity() {
        return VaultGearRarity.SCRAPPY;
    }

    @Override
    public boolean canStoreRepairSlots(ItemStack stack) {
        return false;
    }

    public static boolean isUsableInVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VaultNecklaceItem) || vaultId == null) {
            return false;
        }
        List<UUID> list = VaultNecklaceItem.getUsedVaults(stack);
        for (UUID id : list) {
            if (!vaultId.equals(id)) continue;
            return true;
        }
        List<UUID> freeList = VaultNecklaceItem.getFreeUsedVaults(stack);
        for (UUID id : freeList) {
            if (!vaultId.equals(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUsable(ItemStack voidStone, Player player) {
        Vault vault;
        UsesGearData data = (UsesGearData)AttributeGearData.read(voidStone);
        if (data.getState() != VaultGearState.IDENTIFIED) {
            return false;
        }
        if (PrestigeHelper.getPrestige(player).getAll(NoVaultUsesPrestigePower.class, Skill::isUnlocked).stream().anyMatch(power -> power.getItemId().equals((Object)voidStone.m_41720_().getRegistryName()))) {
            return true;
        }
        Vault vault2 = vault = player.f_19853_.f_46443_ ? (Vault)ClientVaults.getActive().orElse(null) : (Vault)ServerVaults.get(player.f_19853_).orElse(null);
        if (vault == null) {
            return VaultNecklaceItem.hasUsesLeft(voidStone);
        }
        return VaultNecklaceItem.isUsableInVault(voidStone, vault.get(Vault.ID));
    }

    public static Optional<ItemStack> getNecklace(LivingEntity entity) {
        if (entity.m_5833_()) {
            return Optional.empty();
        }
        return CuriosApi.getCuriosHelper().getCuriosHandler(entity).map(handler -> handler).flatMap(handler -> handler.getStacksHandler(SLOT)).map(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStacks().getStackInSlot(i);
                if (stack.m_41720_() != ModItems.VAULT_NECKLACE) continue;
                return stack;
            }
            return null;
        }).map(stack -> {
            Player player;
            Vault vault;
            VaultGearData data = VaultGearData.read(stack);
            Vault vault2 = vault = entity.f_19853_.f_46443_ ? (Vault)ClientVaults.getActive().orElse(null) : (Vault)ServerVaults.get(entity.f_19853_).orElse(null);
            if (vault != null && VaultNecklaceItem.isUsableInVault(stack, vault.get(Vault.ID))) {
                return stack;
            }
            if (!VaultNecklaceItem.hasUsesLeft(stack)) {
                return null;
            }
            if (entity instanceof Player && SidedHelper.getVaultLevel(player = (Player)entity) < data.getItemLevel()) {
                return null;
            }
            return stack;
        });
    }

    @Override
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        consumer.accept(new ModelResourceLocation("the_vault:gear/pendants/pendant", "inventory"));
        for (AbilitiesGUIConfig.Type type : AbilitiesGUIConfig.Type.values()) {
            consumer.accept(new ModelResourceLocation("the_vault:gear/pendants/pendant_" + type.name().toLowerCase() + "_front", "inventory"));
            consumer.accept(new ModelResourceLocation("the_vault:gear/pendants/pendant_" + type.name().toLowerCase() + "_back", "inventory"));
        }
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return VaultNecklaceItemRenderer.INSTANCE;
            }
        });
    }
}

