/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.gear;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.config.AbilitiesGUIConfig;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.ability.AbilityLevelAttribute;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.gear.VaultNecklaceItem;
import iskallia.vault.item.render.core.SpecialItemRenderer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class VaultNecklaceItemRenderer
extends SpecialItemRenderer {
    private static final Cache<UUID, String> ABILITIES_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(10L).build();
    public static final VaultNecklaceItemRenderer INSTANCE = new VaultNecklaceItemRenderer();

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType pTransformType, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        if (!(stack.m_41720_() instanceof VaultNecklaceItem)) {
            return;
        }
        VaultGearData data = VaultGearData.read(stack);
        String abilityId = VaultNecklaceItemRenderer.getAbilityId(data);
        if (abilityId.equals("empty")) {
            this.renderModel(new ModelResourceLocation("the_vault:gear/pendants/pendant", "inventory"), 0xFFFFFF, stack, pTransformType, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, false);
            return;
        }
        ResourceLocation icon = ModConfigs.ABILITIES_GUI.getIconOrFirst(abilityId);
        if (icon == null) {
            return;
        }
        String[] split = icon.toString().split("/");
        String last = split[split.length - 1];
        ModelResourceLocation model = new ModelResourceLocation("the_vault:skills/" + last + "#inventory");
        AbilitiesGUIConfig.Type type = ModConfigs.ABILITIES_GUI.getType(abilityId);
        String name = type == null ? "utility" : type.name().toLowerCase();
        this.renderModel(new ModelResourceLocation("the_vault:gear/pendants/pendant_" + name + "_back", "inventory"), 0xFFFFFF, stack, pTransformType, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, false, () -> {});
        this.renderModel(model, 0xFFFFFF, stack, pTransformType, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, false, () -> {
            pPoseStack.m_85841_(0.5f, 0.5f, 1.0f);
            pPoseStack.m_85837_(0.5, 0.25, (double)0.01f);
        });
        this.renderModel(new ModelResourceLocation("the_vault:gear/pendants/pendant_" + name + "_front", "inventory"), 0xFFFFFF, stack, pTransformType, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, false, () -> pPoseStack.m_85837_(0.0, 0.0, (double)0.015f));
    }

    private static String getAbilityId(VaultGearData data) {
        VaultGearAttributeInstance attribute = data.getModifiers(ModGearAttributes.ABILITY_LEVEL, VaultGearData.Type.SUFFIXES).stream().findFirst().orElse(null);
        if (attribute == null) {
            return "empty";
        }
        String id = ((AbilityLevelAttribute)attribute.getValue()).getAbility();
        ABILITIES_CACHE.put((Object)data.getIdentifier(), (Object)id);
        return id;
    }
}

