/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.util.ThemeBlockRetriever;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.RoyaleObjective;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.UsesGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.research.StageManager;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.VoidStoneBlacklistData;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class VoidStoneItem
extends Item
implements VaultGearItem,
ICurioItem {
    public static final String SLOT = "necklace";

    public VoidStoneItem(ResourceLocation id) {
        super(new Item.Properties().m_41487_(1));
        this.setRegistryName(id);
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public static float getUsePercentage(ItemStack input) {
        if (input.m_41619_()) {
            return 0.0f;
        }
        if (input.m_41720_() instanceof VoidStoneItem) {
            VaultGearState state;
            VaultGearState data = AttributeGearData.read(input);
            if (data instanceof VaultGearData) {
                VaultGearData gearData = (VaultGearData)((Object)data);
                state = gearData.getState();
            } else {
                state = ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED);
            }
            if (state != VaultGearState.IDENTIFIED) {
                return 1.0f;
            }
            return 1.0f - (float)VoidStoneItem.getUsedVaults(input).size() / (float)VoidStoneItem.getUses(input);
        }
        return 0.0f;
    }

    public int m_142158_(ItemStack pStack) {
        return Math.round(13.0f - (1.0f - VoidStoneItem.getUsePercentage(pStack)) * 13.0f);
    }

    public int m_142159_(ItemStack pStack) {
        return Mth.m_14169_((float)(VoidStoneItem.getUsePercentage(pStack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_142522_(ItemStack pStack) {
        if (((IVaultOptions)Minecraft.m_91087_().f_91066_).getShowUsesAsStackSize()) {
            return false;
        }
        return this.getState(pStack) == VaultGearState.IDENTIFIED && VoidStoneItem.getUsePercentage(pStack) != 1.0f;
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return super.getDefaultTooltipHideFlags(stack) | ItemStack.TooltipPart.MODIFIERS.m_41809_();
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        return Collections.emptyList();
    }

    public static int getUses(ItemStack itemStack) {
        if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof VoidStoneItem)) {
            return 0;
        }
        UsesGearData data = (UsesGearData)AttributeGearData.read(itemStack);
        return data.getVaultUses();
    }

    public static void setUses(ItemStack stack, int uses) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VoidStoneItem)) {
            return;
        }
        UsesGearData data = (UsesGearData)AttributeGearData.read(stack);
        data.setVaultUses(uses);
        data.write(stack);
    }

    public static boolean hasUsesLeft(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VoidStoneItem)) {
            return false;
        }
        return VoidStoneItem.getUses(stack) > VoidStoneItem.getUsedVaults(stack).size();
    }

    public static List<UUID> getUsedVaults(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VoidStoneItem)) {
            return Collections.emptyList();
        }
        UsesGearData data = (UsesGearData)AttributeGearData.read(stack);
        return data.getUsedVaults();
    }

    public static List<UUID> getFreeUsedVaults(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VoidStoneItem)) {
            return Collections.emptyList();
        }
        UsesGearData data = (UsesGearData)AttributeGearData.read(stack);
        return data.getFreeVaultUses();
    }

    public static void addUsedVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VoidStoneItem)) {
            return;
        }
        UsesGearData data = (UsesGearData)AttributeGearData.read(stack);
        data.getUsedVaults().add(vaultId);
        data.write(stack);
    }

    public static void addFreeUsedVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VoidStoneItem)) {
            return;
        }
        UsesGearData data = (UsesGearData)AttributeGearData.read(stack);
        data.getFreeVaultUses().add(vaultId);
        data.write(stack);
    }

    public static boolean isUsableInVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof VoidStoneItem) || vaultId == null) {
            return false;
        }
        List<UUID> list = VoidStoneItem.getUsedVaults(stack);
        for (UUID id : list) {
            if (!vaultId.equals(id)) continue;
            return true;
        }
        List<UUID> freeList = VoidStoneItem.getFreeUsedVaults(stack);
        for (UUID id : freeList) {
            if (!vaultId.equals(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUsable(ItemStack voidStone, Player player) {
        Vault vault;
        UsesGearData data = (UsesGearData)AttributeGearData.read(voidStone);
        if (data.getState() != VaultGearState.IDENTIFIED) {
            return false;
        }
        Vault vault2 = vault = player.f_19853_.f_46443_ ? (Vault)ClientVaults.getActive().orElse(null) : (Vault)ServerVaults.get(player.f_19853_).orElse(null);
        if (vault == null) {
            return VoidStoneItem.hasUsesLeft(voidStone);
        }
        return VoidStoneItem.isUsableInVault(voidStone, vault.get(Vault.ID));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext context, UUID uuid, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_36335_().m_41519_(stack.m_41720_())) {
            return ImmutableMultimap.of();
        }
        if (!VoidStoneItem.hasUsesLeft(stack)) {
            return ImmutableMultimap.of();
        }
        return SLOT.equals(context.identifier()) ? VaultGearHelper.getModifiers(VaultGearData.read(stack)) : ImmutableMultimap.of();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return VaultGearHelper.shouldPlayGearReequipAnimation(oldStack, newStack, slotChanged);
    }

    public Component m_7626_(ItemStack stack) {
        return VaultGearHelper.getDisplayName(stack, super.m_7626_(stack));
    }

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (ModConfigs.isInitialized() && !StageManager.RESEARCH_TREE.isResearched(ModConfigs.RESEARCHES.getByName("Junk Management"))) {
            tooltip.add((Component)new TextComponent("Unlock \"Junk Management\" to equip").m_130940_(ChatFormatting.RED));
            tooltip.add(TextComponent.f_131282_);
        }
        if (this.getState(stack) == VaultGearState.IDENTIFIED) {
            int totalUses = VoidStoneItem.getUses(stack);
            int used = VoidStoneItem.getUsedVaults(stack).size();
            int remaining = Math.max(totalUses - used, 0);
            MutableComponent usesTxt = new TextComponent("Uses: ").m_7220_((Component)new TextComponent(String.valueOf(remaining)));
            tooltip.add((Component)usesTxt);
        }
        tooltip.addAll(this.createTooltip(stack, GearTooltip.itemTooltip()));
    }

    @Override
    public boolean tryStartIdentification(Player player, ItemStack stack) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        EquipmentSlot slot;
        ItemStack heldStack = player.m_21120_(hand);
        InteractionResultHolder defaultAction = this.canEquip(heldStack, slot = Mob.m_147233_((ItemStack)heldStack), (Entity)player) ? super.m_7203_(level, player, hand) : InteractionResultHolder.m_19100_((Object)heldStack);
        return VaultGearHelper.rightClick(level, player, hand, (InteractionResultHolder<ItemStack>)defaultAction);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, level, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            this.vaultGearTick(stack, serverPlayer);
        }
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent() && ServerVaults.get(player.f_19853_).get().get(Vault.OBJECTIVES).getAll(RoyaleObjective.class).isEmpty()) {
                return false;
            }
        }
        if (this.getState(stack) != VaultGearState.IDENTIFIED) {
            return false;
        }
        if (!slotContext.identifier().equals(SLOT)) {
            return false;
        }
        livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer) {
            player = (ServerPlayer)livingEntity;
            PlayerVaultStatsData stats = PlayerVaultStatsData.get(player.m_183503_());
            int vaultLevel = stats.getVaultStats(player).getVaultLevel();
            if (vaultLevel < VaultGearData.read(stack).getItemLevel()) {
                return false;
            }
            if (!StageManager.getResearchTree(player).isResearched(ModConfigs.RESEARCHES.getByName("Junk Management"))) {
                return false;
            }
        }
        if (CuriosApi.getSlotHelper() != null && !CuriosApi.getSlotHelper().getSlotType(SLOT).map(ISlotType::isVisible).orElse(false).booleanValue()) {
            return false;
        }
        return super.canEquip(slotContext, stack);
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent()) {
                return false;
            }
        }
        return super.canUnequip(slotContext, stack);
    }

    @Override
    public Optional<UUID> getUuid(ItemStack stack) {
        return AttributeGearData.readUUID(stack);
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return !input.m_41619_() && AttributeGearData.hasData(input);
    }

    @Override
    public VaultRecyclerConfig.RecyclerOutput getOutput(ItemStack input) {
        return null;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (!VoidStoneItem.isIdentified(stack)) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent() && !ServerVaults.get(player.f_19853_).get().get(Vault.OBJECTIVES).getAll(RoyaleObjective.class).isEmpty()) {
                VoidStoneItem.addFreeUsedVault(stack, ServerVaults.get(player.f_19853_).get().get(Vault.ID));
            }
        }
        super.onEquip(slotContext, prevStack, stack);
    }

    @Override
    public float getResultPercentage(ItemStack input) {
        if (input.m_41619_()) {
            return 0.0f;
        }
        if (this.getState(input) != VaultGearState.IDENTIFIED) {
            return 1.0f;
        }
        return 1.0f - (float)VoidStoneItem.getUsedVaults(input).size() / (float)VoidStoneItem.getUses(input);
    }

    public void m_6787_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            VaultGearData data = VaultGearData.read(stack);
            data.setState(VaultGearState.UNIDENTIFIED);
            data.write(stack);
            items.add((Object)stack);
        }
    }

    @Override
    public void tickFinishRoll(ItemStack stack, @Nullable Player player, boolean identify) {
        VaultGearItem.super.tickFinishRoll(stack, player, identify);
        VaultGearData data = VaultGearData.read(stack);
        if (data.getRarity() != null) {
            VoidStoneItem.setUses(stack, ModConfigs.VOID_STONE.getUses(data.getRarity(), JavaRandom.ofNanoTime()));
        } else {
            VoidStoneItem.setUses(stack, ModConfigs.VOID_STONE.getUses(VaultGearRarity.SCRAPPY, JavaRandom.ofNanoTime()));
        }
    }

    @Override
    @NotNull
    public VaultGearClassification getClassification(ItemStack stack) {
        return VaultGearClassification.VOID_STONE;
    }

    @Override
    @NotNull
    public VaultGearType getGearType(ItemStack stack) {
        return VaultGearType.VOID_STONE;
    }

    @Override
    public ResourceLocation getRandomModel(ItemStack stack, Random random, @javax.annotation.Nullable Player player, @javax.annotation.Nullable DiscoveredModelsData discoveredModelsData) {
        VaultGearData data = VaultGearData.read(stack);
        return ModConfigs.VOID_STONE.getRandomModel(data.getRarity(), random);
    }

    public static Optional<ItemStack> getVoidStone(LivingEntity entity) {
        if (entity.m_5833_()) {
            return Optional.empty();
        }
        return CuriosApi.getCuriosHelper().getCuriosHandler(entity).map(handler -> handler).flatMap(handler -> handler.getStacksHandler(SLOT)).map(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStacks().getStackInSlot(i);
                if (stack.m_41720_() != ModItems.VOID_STONE) continue;
                return stack;
            }
            return null;
        }).map(stack -> {
            Player player;
            Vault vault;
            VaultGearData data = VaultGearData.read(stack);
            Vault vault2 = vault = entity.f_19853_.f_46443_ ? (Vault)ClientVaults.getActive().orElse(null) : (Vault)ServerVaults.get(entity.f_19853_).orElse(null);
            if (vault != null && VoidStoneItem.isUsableInVault(stack, vault.get(Vault.ID))) {
                return stack;
            }
            if (!VoidStoneItem.hasUsesLeft(stack)) {
                return null;
            }
            if (entity instanceof Player && SidedHelper.getVaultLevel(player = (Player)entity) < data.getItemLevel()) {
                return null;
            }
            return stack;
        });
    }

    @Override
    public void addTooltipDurability(List<Component> tooltip, ItemStack stack) {
    }

    @Override
    public void addRepairTooltip(List<Component> tooltip, int usedRepairs, int totalRepairs) {
    }

    public static boolean isIdentified(ItemStack stack) {
        VaultGearState data = AttributeGearData.read(stack);
        if (data instanceof VaultGearData) {
            VaultGearData gearData = (VaultGearData)((Object)data);
            return gearData.getState().equals((Object)VaultGearState.IDENTIFIED);
        }
        return ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED).equals((Object)VaultGearState.IDENTIFIED);
    }

    public static boolean shouldVoidItem(ServerPlayer player, ItemEntity itemEntity, ServerLevel world, ResourceLocation theme) {
        if (ServerVaults.get((Level)world).isEmpty()) {
            return false;
        }
        if (VoidStoneItem.getVoidStone((LivingEntity)player).isEmpty()) {
            return false;
        }
        if (itemEntity == null || itemEntity.m_32055_().m_41619_()) {
            return false;
        }
        if (theme == null || theme.toString().isEmpty()) {
            return false;
        }
        ItemStack stack = itemEntity.m_32055_();
        if (stack.m_41619_() || stack.m_41720_().getRegistryName() == null) {
            return false;
        }
        VoidStoneBlacklistData data = VoidStoneBlacklistData.get(world);
        List<ResourceLocation> blacklist = data.getInventory(player).getBlacklist();
        ResourceLocation itemId = stack.m_41720_().getRegistryName();
        if (itemId != null) {
            BlockItem blockItem;
            if (blacklist.contains(itemId)) {
                return false;
            }
            Item item = stack.m_41720_();
            if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof AnvilBlock && blacklist.contains(Blocks.f_50322_.getRegistryName())) {
                return false;
            }
        }
        if (!ThemeBlockRetriever.allowVaultBlock(stack.m_41720_().getRegistryName())) {
            return false;
        }
        List<ResourceLocation> themes = ThemeBlockRetriever.getBlocksForTheme(theme);
        List<ResourceLocation> specialRooms = ModConfigs.VOID_CRUCIBLE_CUSTOM_ROOMS.getAllItems();
        return themes.contains(stack.m_41720_().getRegistryName()) || specialRooms.contains(stack.m_41720_().getRegistryName());
    }
}

