/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.render;

import iskallia.vault.client.util.color.ColorUtil;
import java.util.ArrayList;
import java.util.List;
import oshi.util.tuples.Pair;

public class ColorBlender {
    private final float speed;
    private final List<Pair<Integer, Float>> sequence = new ArrayList<Pair<Integer, Float>>();
    private float totalTime;

    public ColorBlender(float speed) {
        this.speed = speed;
    }

    public ColorBlender add(int color, float interval) {
        this.sequence.add((Pair<Integer, Float>)new Pair((Object)color, (Object)Float.valueOf(interval)));
        this.totalTime += interval;
        return this;
    }

    public int getColor(float time) {
        if (this.totalTime == 0.0f) {
            return 0xFFFFFF;
        }
        float value = time * this.speed % this.totalTime;
        float ratio = 0.0f;
        int color1 = 0;
        int color2 = 0;
        for (int j = 0; j < this.sequence.size(); ++j) {
            Pair<Integer, Float> pair = this.sequence.get(j);
            int color = (Integer)pair.getA();
            float interval = ((Float)pair.getB()).floatValue();
            if (value < interval) {
                color1 = color;
                color2 = (Integer)this.sequence.get((j + 1) % this.sequence.size()).getA();
                ratio = value / interval;
                break;
            }
            value -= interval;
        }
        return ColorUtil.blendColors(color2, color1, ratio);
    }
}

