/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.render;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.config.gear.VaultEtchingConfig;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.gear.EtchingItem;
import iskallia.vault.item.render.core.SpecialItemRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class EtchingItemRenderer
extends SpecialItemRenderer {
    public static final EtchingItemRenderer INSTANCE = new EtchingItemRenderer();

    public void m_108829_(@NotNull ItemStack stack, @NotNull ItemTransforms.TransformType transformType, @NotNull PoseStack matrices, @NotNull MultiBufferSource buffer, int light, int overlay) {
        if (!(stack.m_41720_() instanceof EtchingItem)) {
            return;
        }
        VaultGearData data = VaultGearData.read(stack);
        if (!data.hasAttribute(ModGearAttributes.ETCHING)) {
            return;
        }
        ResourceLocation etching = data.getFirstValue(ModGearAttributes.ETCHING).orElse(null);
        if (etching == null) {
            return;
        }
        VaultEtchingConfig.EtchingEntry entry = ModConfigs.ETCHINGS.getEtchingConfig(etching);
        if (entry == null || entry.getItemOverlay() == null) {
            return;
        }
        ModelResourceLocation base = new ModelResourceLocation(entry.getItemOverlay());
        this.renderModel(base, 0xFFFFFF, stack, transformType, matrices, buffer, light, overlay, null);
    }
}

