/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.tool;

import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.core.DataInitializationItem;
import iskallia.vault.item.core.DataTransferItem;
import iskallia.vault.item.crystal.recipe.JewelAnvilRecipe;
import iskallia.vault.item.render.ColorBlender;
import iskallia.vault.world.data.DiscoveredModelsData;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class JewelItem
extends Item
implements VaultGearItem,
DataInitializationItem,
DataTransferItem {
    public JewelItem(ResourceLocation id, Item.Properties properties) {
        super(properties);
        this.setRegistryName(id);
    }

    public Component m_7626_(@NotNull ItemStack stack) {
        int color = JewelItem.getColor(stack);
        GearDataCache cache = GearDataCache.of(stack);
        if (cache.getState() == VaultGearState.UNIDENTIFIED) {
            return new TranslatableComponent(this.m_5671_(stack) + ".unidentified");
        }
        VaultGearRarity rarity = (VaultGearRarity)((Object)ObjectUtils.firstNonNull((Object[])new VaultGearRarity[]{cache.getRarity(), VaultGearRarity.SCRAPPY}));
        if (rarity == VaultGearRarity.SCRAPPY) {
            return super.m_7626_(stack).m_6881_().m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color)));
        }
        GearDataCache clientCache = GearDataCache.of(stack);
        String customName = clientCache.getGearName();
        if (customName != null) {
            return new TextComponent(customName).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color)));
        }
        String prefix = this.m_5524_() + "." + rarity.name().toLowerCase(Locale.ROOT);
        return new TranslatableComponent(prefix).m_7220_(super.m_7626_(stack)).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.addAll(this.createTooltip(stack, GearTooltip.itemTooltip()));
    }

    @Override
    public void addTooltipDurability(List<Component> tooltip, ItemStack stack) {
    }

    @Override
    public void addRepairTooltip(List<Component> tooltip, int usedRepairs, int totalRepairs) {
    }

    @Override
    public void addTooltipRarity(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
    }

    @Override
    public void addTooltipCraftingPotential(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return VaultGearHelper.shouldPlayGearReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.vaultGearTick(stack, player);
        }
    }

    public void m_6787_(@Nonnull CreativeModeTab category, @Nonnull NonNullList<ItemStack> items) {
        if (category != ModItems.GEAR_GROUP) {
            return;
        }
        ArrayList<ItemStack> jewels = new ArrayList<ItemStack>();
        for (VaultGearModifier<?> modifier : JewelAnvilRecipe.PRESET_MODIFIERS) {
            jewels.add(JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.SUFFIX, modifier)));
        }
        for (ItemStack jewel : jewels) {
            VaultGearData data2 = VaultGearData.read(jewel);
            data2.setRarity(VaultGearRarity.OMEGA);
            data2.setState(VaultGearState.IDENTIFIED);
            data2.createOrReplaceAttributeValue(ModGearAttributes.JEWEL_SIZE, 1);
            data2.write(jewel);
        }
        items.addAll(jewels);
    }

    @Override
    public void initialize(ItemStack stack, RandomSource random) {
        this.instantIdentify(null, stack);
    }

    @Override
    public void onIdentify(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("ignoreJewelSize") && tag.m_128471_("ignoreJewelSize")) {
            return;
        }
        ModConfigs.JEWEL_SIZE.getSize(data.getRarity()).ifPresent(size -> {
            data.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier<Integer>(ModGearAttributes.JEWEL_SIZE, size.getRandom(random)));
            data.write(stack);
        });
    }

    @Override
    public VaultRecyclerConfig.RecyclerOutput getOutput(ItemStack input) {
        return ModConfigs.VAULT_RECYCLER.getRecyclingOutputOrDefault(input.m_41720_());
    }

    @Override
    public float getResultPercentage(ItemStack input) {
        return 1.0f;
    }

    @Override
    @Nonnull
    public VaultGearClassification getClassification(ItemStack stack) {
        return VaultGearClassification.JEWEL;
    }

    @Override
    @Nonnull
    public VaultGearType getGearType(ItemStack stack) {
        return VaultGearType.JEWEL;
    }

    @Override
    @Nullable
    public ResourceLocation getRandomModel(ItemStack stack, Random random, @Nullable Player player, @Nullable DiscoveredModelsData discoveredModelsData) {
        return null;
    }

    public static int getColor(ItemStack stack) {
        GearDataCache clientCache = GearDataCache.of(stack);
        if (clientCache.getState() == VaultGearState.UNIDENTIFIED) {
            return -12632257;
        }
        ColorBlender blender = new ColorBlender(1.0f);
        Optional.ofNullable(clientCache.getJewelColorComponents()).ifPresent(colors -> colors.forEach(color -> blender.add((int)color, 60.0f)));
        float time = ClientScheduler.INSTANCE.getTick();
        return blender.getColor(time);
    }

    public static ItemStack create(Consumer<VaultGearData> consumer) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.JEWEL);
        VaultGearData data = VaultGearData.read(stack);
        consumer.accept(data);
        data.write(stack);
        return stack;
    }
}

