/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.tool;

import iskallia.vault.VaultMod;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.tool.JewelItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;

public class Smelting {
    public static void handle(ServerLevel world, List<ItemStack> loot) {
        ArrayList<ItemStack> extraSmelted = new ArrayList<ItemStack>();
        for (int i = loot.size() - 1; i >= 0; --i) {
            ItemStack raw = loot.get(i);
            Optional recipe = world.m_7465_().m_44015_(net.minecraft.world.item.crafting.RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{raw}), (Level)world.m_6018_());
            if (!recipe.isPresent()) continue;
            ItemStack smelted = ((SmeltingRecipe)recipe.get()).m_8043_().m_41777_();
            int remainingCount = raw.m_41613_() * smelted.m_41613_();
            while (remainingCount > 0) {
                smelted.m_41764_(Math.min(smelted.m_41741_(), remainingCount));
                extraSmelted.add(smelted);
                if ((remainingCount -= smelted.m_41613_()) <= 0) continue;
                smelted = smelted.m_41777_();
            }
            loot.remove(i);
        }
        loot.addAll(extraSmelted);
    }

    public static void register(IRecipeCategoryRegistration registration) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            registration.addRecipeCategories(new IRecipeCategory[]{new Category(registration.getJeiHelpers().getGuiHelper())});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void register(IRecipeRegistration registration) {
        ClientLevel world = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        ArrayList recipes = new ArrayList();
        for (Item item : ForgeRegistries.ITEMS) {
            Optional opt = world.m_7465_().m_44015_(net.minecraft.world.item.crafting.RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{new ItemStack((ItemLike)item)}), (Level)world);
            opt.ifPresent(recipe -> recipes.add(new Recipe(new ItemStack((ItemLike)item), recipe.m_8043_().m_41777_())));
        }
        registration.addRecipes(Category.RECIPE_TYPE, recipes);
    }

    public static void register(IRecipeCatalystRegistration registration) {
        ItemStack tool = new ItemStack((ItemLike)ModItems.TOOL);
        VaultGearData data = VaultGearData.read(tool);
        data.setState(VaultGearState.IDENTIFIED);
        data.addModifier(VaultGearModifier.AffixType.SUFFIX, new VaultGearModifier<Boolean>(ModGearAttributes.SMELTING, true));
        data.write(tool);
        registration.addRecipeCatalyst(tool, new RecipeType[]{Category.RECIPE_TYPE});
    }

    private static class Category
    implements IRecipeCategory<Recipe> {
        public static final RecipeType<Recipe> RECIPE_TYPE = RecipeType.create((String)"the_vault", (String)"smelting", Recipe.class);
        private static final ResourceLocation TEXTURE = VaultMod.id("textures/gui/vault_recycler_jei.png");
        private final IDrawable background;
        private final IDrawable icon;

        public Category(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(TEXTURE, 33, 30, 104, 26);
            this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)JewelItem.create(data -> data.addModifier(VaultGearModifier.AffixType.PREFIX, new VaultGearModifier<Boolean>(ModGearAttributes.SMELTING, true))));
        }

        @Nonnull
        public Component getTitle() {
            return new TextComponent("Smelting");
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        @Nonnull
        public IDrawable getIcon() {
            return this.icon;
        }

        @ParametersAreNonnullByDefault
        public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 5).addItemStack(recipe.getInput());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 49, 5).addItemStack(recipe.getOutput());
        }

        @Nonnull
        public RecipeType<Recipe> getRecipeType() {
            return RECIPE_TYPE;
        }

        @Nonnull
        public ResourceLocation getUid() {
            return this.getRecipeType().getUid();
        }

        @Nonnull
        public Class<? extends Recipe> getRecipeClass() {
            return this.getRecipeType().getRecipeClass();
        }
    }

    private static class Recipe {
        private final ItemStack input;
        private final ItemStack output;

        public Recipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }
    }
}

