/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.tool;

import com.mojang.blaze3d.platform.NativeImage;
import iskallia.vault.VaultMod;
import iskallia.vault.item.tool.ToolMaterial;
import iskallia.vault.mixin.AccessorInfo;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ToolHeadSprite
extends TextureAtlasSprite {
    public ToolHeadSprite(TextureAtlas atlas, TextureAtlasSprite.Info info, int mipLevel, int storageX, int storageZ, int x, int y, NativeImage image) {
        super(atlas, info, mipLevel, storageX, storageZ, x, y, image);
    }

    public static ToolHeadSprite create(TextureAtlas atlas, TextureAtlasSprite.Info info, int mipLevel, int storageX, int storageZ, int x, int y, ResourceLocation material, ResourceLocation baseId) {
        NativeImage baseImage;
        NativeImage image;
        AnimationMetadataSection meta = ((AccessorInfo)info).getMetaData();
        int frameWidth = meta.m_119031_(info.m_118434_());
        int frameHeight = meta.m_119026_(info.m_118437_());
        try {
            image = NativeImage.m_85058_((InputStream)Minecraft.m_91087_().m_91098_().m_142591_(material).m_6679_());
            baseImage = NativeImage.m_85058_((InputStream)Minecraft.m_91087_().m_91098_().m_142591_(baseId).m_6679_());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        for (int offsetY = 0; offsetY < image.m_85084_(); offsetY += frameHeight) {
            for (int frameX = 0; frameX < frameWidth; ++frameX) {
                for (int frameY = 0; frameY < frameHeight; ++frameY) {
                    int pixel1 = image.m_84985_(frameX, frameY + offsetY);
                    int pixel2 = baseImage.m_84985_(frameX, frameY);
                    int red = (pixel1 & 0xFF) * (pixel2 & 0xFF) / 255;
                    int green = (pixel1 >>> 8 & 0xFF) * (pixel2 >>> 8 & 0xFF) / 255;
                    int blue = (pixel1 >>> 16 & 0xFF) * (pixel2 >>> 16 & 0xFF) / 255;
                    int alpha = (pixel1 >> 24 & 0xFF) * (pixel2 >> 24 & 0xFF) / 255;
                    int color = alpha << 24 | blue << 16 | green << 8 | red;
                    image.m_84988_(frameX, frameY + offsetY, color);
                }
            }
        }
        return new ToolHeadSprite(atlas, info, mipLevel, storageX, storageZ, x, y, image);
    }

    @SubscribeEvent
    public static void onStitchPre(TextureStitchEvent.Pre event) {
        for (ToolMaterial material : ToolMaterial.values()) {
            event.addSprite(VaultMod.id("item/tool/material/" + material.getId()));
        }
    }
}

