/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.tool;

import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import iskallia.vault.VaultMod;
import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.block.entity.VaultChestTileEntity;
import iskallia.vault.config.UniqueGearConfig;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.iterator.MappingIterator;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.core.DataInitializationItem;
import iskallia.vault.item.render.ToolItemRenderer;
import iskallia.vault.item.render.core.IManualModelLoading;
import iskallia.vault.item.tool.IHammer;
import iskallia.vault.item.tool.Pulverizing;
import iskallia.vault.item.tool.Smelting;
import iskallia.vault.item.tool.ToolMaterial;
import iskallia.vault.item.tool.ToolType;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.prestige.ToolDurabilityPrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.ServerVaults;
import it.unimi.dsi.fastutil.ints.IntIterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.MendingEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ToolItem
extends TieredItem
implements VaultGearItem,
Vanishable,
IManualModelLoading,
DataInitializationItem {
    public static final ResourceLocation SPAWNER_ID = new ResourceLocation("ispawner", "spawner");

    public ToolItem(ResourceLocation id, Item.Properties properties) {
        super((Tier)Tiers.NETHERITE, properties);
        this.setRegistryName(id);
    }

    @Override
    public boolean shouldPreventAnvilCombination(ItemStack other) {
        return !other.m_150930_((Item)ModItems.JEWEL) && !other.m_150930_(Items.f_42690_);
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return VaultGearData.read(stack).get(ModGearAttributes.DURABILITY, VaultGearAttributeTypeMerger.intSum());
    }

    public boolean m_6832_(@NotNull ItemStack toRepair, @NotNull ItemStack material) {
        return false;
    }

    @NotNull
    public Component m_7626_(@Nonnull ItemStack stack) {
        ToolType type = ToolType.of(stack);
        ToolMaterial material = ToolItem.getMaterial(stack);
        if (type != null && material != null) {
            return new TranslatableComponent(material.getDescription()).m_130946_(" ").m_7220_((Component)new TranslatableComponent(type.getDescription()));
        }
        if (type != null) {
            return new TranslatableComponent(type.getDescription());
        }
        if (material != null) {
            return new TranslatableComponent(material.getDescription()).m_130946_(" ").m_7220_(super.m_7626_(stack));
        }
        return super.m_7626_(stack);
    }

    public static ToolMaterial getMaterial(@NotNull ItemStack stack) {
        return VaultGearData.read(stack).get(ModGearAttributes.TOOL_MATERIAL, VaultGearAttributeTypeMerger.of(() -> null, (a, b) -> b));
    }

    public static boolean canUse(ItemStack stack, Entity entity) {
        if (!(entity instanceof Player)) {
            return true;
        }
        Player player = (Player)entity;
        int playerLevel = SidedHelper.getVaultLevel(player);
        return playerLevel >= VaultGearData.read(stack).getItemLevel();
    }

    @SubscribeEvent
    public static void onBlockClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getItemStack().m_41720_() == ModItems.TOOL && !ToolItem.canUse(event.getItemStack(), event.getEntity())) {
            event.setCanceled(true);
        }
    }

    public float m_8102_(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        if (this.hasAffinity(stack, state)) {
            return VaultGearData.read(stack).get(ModGearAttributes.MINING_SPEED, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        }
        return 1.0f;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.hasAffinity(stack, state);
    }

    public boolean hasAffinity(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        VaultGearItem gearItem;
        Item item = stack.m_41720_();
        if (item instanceof VaultGearItem && (gearItem = (VaultGearItem)item).isBroken(stack)) {
            return false;
        }
        VaultGearData data = VaultGearData.read(stack);
        if (data.get(ModGearAttributes.PICKING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue() && state.m_204336_(BlockTags.f_144282_)) {
            return true;
        }
        if (data.get(ModGearAttributes.AXING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue() && state.m_204336_(BlockTags.f_144280_)) {
            return true;
        }
        if (data.get(ModGearAttributes.SHOVELLING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue() && state.m_204336_(BlockTags.f_144283_)) {
            return true;
        }
        if (data.get(ModGearAttributes.REAPING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue() && (state.m_204336_(BlockTags.f_144281_) || Items.f_42393_.m_8102_(stack, state) > 1.0f || Items.f_42393_.isCorrectToolForDrops(stack, state) || Items.f_42574_.m_8102_(stack, state) > 1.0f || Items.f_42574_.isCorrectToolForDrops(stack, state))) {
            return true;
        }
        if (data.get(ModGearAttributes.WOODEN_AFFINITY, VaultGearAttributeTypeMerger.anyTrue()).booleanValue() && (state.m_60713_(ModBlocks.WOODEN_CHEST) || state.m_60713_(ModBlocks.HARDENED_CHEST) || state.m_60713_(ModBlocks.WOODEN_BARREL) || state.m_60713_((Block)ModBlocks.UNIQUE_CRATE))) {
            return true;
        }
        if (data.get(ModGearAttributes.ORNATE_AFFINITY, VaultGearAttributeTypeMerger.anyTrue()).booleanValue() && (state.m_60713_(ModBlocks.ORNATE_CHEST) || state.m_60713_(ModBlocks.ORNATE_STRONGBOX) || state.m_60713_(ModBlocks.FLESH_CHEST) || state.m_60713_(ModBlocks.ENIGMA_CHEST) || state.m_60713_(ModBlocks.ORNATE_BARREL))) {
            return true;
        }
        if (data.get(ModGearAttributes.GILDED_AFFINITY, VaultGearAttributeTypeMerger.anyTrue()).booleanValue() && (state.m_60713_(ModBlocks.GILDED_CHEST) || state.m_60713_(ModBlocks.GILDED_STRONGBOX) || state.m_60713_(ModBlocks.FLESH_CHEST) || state.m_60713_(ModBlocks.ENIGMA_CHEST) || state.m_60713_(ModBlocks.GILDED_BARREL))) {
            return true;
        }
        if (data.get(ModGearAttributes.LIVING_AFFINITY, VaultGearAttributeTypeMerger.anyTrue()).booleanValue() && (state.m_60713_(ModBlocks.LIVING_CHEST) || state.m_60713_(ModBlocks.LIVING_STRONGBOX) || state.m_60713_(ModBlocks.FLESH_CHEST) || state.m_60713_(ModBlocks.ENIGMA_CHEST) || state.m_60713_(ModBlocks.LIVING_BARREL))) {
            return true;
        }
        if (data.get(ModGearAttributes.COIN_AFFINITY, VaultGearAttributeTypeMerger.anyTrue()).booleanValue() && state.m_60713_((Block)ModBlocks.COIN_PILE)) {
            return true;
        }
        if (SPAWNER_ID.equals((Object)state.m_60734_().getRegistryName())) {
            return true;
        }
        return state.m_60734_() instanceof LiquidBlock;
    }

    @NotNull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        VaultGearItem gearItem;
        InteractionResult result = InteractionResult.PASS;
        Item item = context.m_43722_().m_41720_();
        if (item instanceof VaultGearItem && (gearItem = (VaultGearItem)item).isBroken(context.m_43722_())) {
            return result;
        }
        if (ToolItem.canUse(context.m_43722_(), (Entity)context.m_43723_())) {
            VaultGearData data = VaultGearData.read(context.m_43722_());
            if (data.get(ModGearAttributes.PICKING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                result = this.getResultFit(Items.f_42395_.m_6225_(context), result);
            }
            if (data.get(ModGearAttributes.AXING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                result = this.getResultFit(Items.f_42396_.m_6225_(context), result);
            }
            if (data.get(ModGearAttributes.SHOVELLING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                result = this.getResultFit(Items.f_42394_.m_6225_(context), result);
            }
            if (data.get(ModGearAttributes.REAPING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                result = this.getResultFit(Items.f_42397_.m_6225_(context), result);
                result = this.getResultFit(Items.f_42393_.m_6225_(context), result);
                result = this.getResultFit(Items.f_42574_.m_6225_(context), result);
            }
        }
        return result;
    }

    @NotNull
    public InteractionResult m_6880_(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity target, @Nonnull InteractionHand hand) {
        VaultGearItem gearItem;
        InteractionResult result = InteractionResult.PASS;
        Item item = stack.m_41720_();
        if (item instanceof VaultGearItem && (gearItem = (VaultGearItem)item).isBroken(stack)) {
            return result;
        }
        if (ToolItem.canUse(stack, (Entity)target)) {
            VaultGearData data = VaultGearData.read(stack);
            if (data.get(ModGearAttributes.PICKING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                result = this.getResultFit(Items.f_42395_.m_6880_(stack, player, target, hand), result);
            }
            if (data.get(ModGearAttributes.AXING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                result = this.getResultFit(Items.f_42396_.m_6880_(stack, player, target, hand), result);
            }
            if (data.get(ModGearAttributes.SHOVELLING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                result = this.getResultFit(Items.f_42394_.m_6880_(stack, player, target, hand), result);
            }
            if (data.get(ModGearAttributes.REAPING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                result = this.getResultFit(Items.f_42397_.m_6880_(stack, player, target, hand), result);
                result = this.getResultFit(Items.f_42574_.m_6880_(stack, player, target, hand), result);
                result = this.getResultFit(Items.f_42393_.m_6880_(stack, player, target, hand), result);
            }
        }
        return result;
    }

    public InteractionResult getResultFit(InteractionResult ... results) {
        InteractionResult min = InteractionResult.FAIL;
        for (InteractionResult result : results) {
            if (result.ordinal() >= min.ordinal()) continue;
            min = result;
        }
        return min;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        VaultGearItem gearItem;
        Item item = stack.m_41720_();
        if (item instanceof VaultGearItem && (gearItem = (VaultGearItem)item).isBroken(stack)) {
            return false;
        }
        VaultGearData data = VaultGearData.read(stack);
        if (data.get(ModGearAttributes.PICKING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue() && ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(action)) {
            return true;
        }
        if (data.get(ModGearAttributes.AXING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue() && ToolActions.DEFAULT_AXE_ACTIONS.contains(action)) {
            return true;
        }
        if (data.get(ModGearAttributes.SHOVELLING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue() && ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(action)) {
            return true;
        }
        return data.get(ModGearAttributes.REAPING, VaultGearAttributeTypeMerger.anyTrue()) != false && (ToolActions.DEFAULT_HOE_ACTIONS.contains(action) || ToolActions.DEFAULT_SHEARS_ACTIONS.contains(action) || ToolActions.DEFAULT_SWORD_ACTIONS.contains(action));
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean m_6813_(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity owner) {
        double damage;
        block6: {
            block7: {
                VaultChestTileEntity chest;
                Block block;
                block5: {
                    if (world.f_46443_ || state.m_60800_((BlockGetter)world, pos) == 0.0f) {
                        return true;
                    }
                    damage = 1.0;
                    if (!(owner instanceof ServerPlayer)) break block5;
                    ServerPlayer player = (ServerPlayer)owner;
                    if (!((IHammer)player.f_8941_).getHammer().contains(pos)) break block5;
                    damage = 0.0;
                    break block6;
                }
                if (!this.hasAffinity(stack, state) || !((block = state.m_60734_()) instanceof VaultChestBlock)) break block7;
                VaultChestBlock block2 = (VaultChestBlock)block;
                block = world.m_7702_(pos);
                if (!(block instanceof VaultChestTileEntity) || !block2.hasStepBreaking(chest = (VaultChestTileEntity)block)) break block7;
                if (block2 == ModBlocks.WOODEN_CHEST || block2 == ModBlocks.ORNATE_STRONGBOX || block2 == ModBlocks.GILDED_STRONGBOX || block2 == ModBlocks.LIVING_STRONGBOX || block2 == ModBlocks.HARDENED_CHEST) {
                    damage = 3.0;
                    break block6;
                } else if (block2 == ModBlocks.GILDED_CHEST || block2 == ModBlocks.LIVING_CHEST || block2 == ModBlocks.ORNATE_CHEST || block2 == ModBlocks.FLESH_CHEST || block2 == ModBlocks.ENIGMA_CHEST) {
                    damage = 0.25;
                }
                break block6;
            }
            if (SPAWNER_ID.equals((Object)state.m_60734_().getRegistryName())) {
                damage = 10.0;
            }
        }
        this.hurt(stack, world, owner, damage);
        return true;
    }

    public boolean m_7579_(@Nonnull ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity attacker) {
        this.hurt(stack, target.f_19853_, attacker, 1.0);
        return true;
    }

    public boolean hurt(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull LivingEntity owner, double damage) {
        VaultGearItem gearItem;
        Item item = stack.m_41720_();
        if (item instanceof VaultGearItem && (gearItem = (VaultGearItem)item).isBroken(stack)) {
            return false;
        }
        int result = (int)damage + ((double)world.m_5822_().nextFloat() < damage - (double)((int)damage) ? 1 : 0);
        if (result <= 0) {
            return false;
        }
        stack.m_41622_(result, owner, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        Level world = entity.f_19853_;
        VaultGearData data = VaultGearData.read(stack);
        if (world.m_5822_().nextFloat() < data.get(ModGearAttributes.IMMORTALITY, VaultGearAttributeTypeMerger.floatSum()).floatValue()) {
            Optional<Vault> vaultOpt = ServerVaults.get(world);
            if (vaultOpt.isEmpty()) {
                return 0;
            }
            Vault vault = vaultOpt.get();
            if (VaultUtils.isRawVault(vault) || VaultUtils.isTrialVault(vault)) {
                return 0;
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ToolDurabilityPrestigePower power : PrestigeHelper.getPrestige(player).getAll(ToolDurabilityPrestigePower.class, Skill::isUnlocked)) {
                amount = power.getReducedDamage(amount);
            }
        }
        return amount;
    }

    @Override
    public boolean isImmuneToDamage(ItemStack stack, @Nullable Player player) {
        return false;
    }

    @Override
    public boolean doesDurabilityReductionApply(ItemStack stack, @Nullable Player player) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return VaultGearHelper.getModifiers(stack, slot);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return VaultGearHelper.shouldPlayGearReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment instanceof MendingEnchantment) {
            return false;
        }
        if (enchantment.f_44672_ == EnchantmentCategory.DIGGER) {
            return true;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.addAll(this.createTooltip(stack, GearTooltip.toolTooltip()));
        if (Screen.m_96638_()) {
            if (!tooltip.isEmpty()) {
                tooltip.add(TextComponent.f_131282_);
            }
            Style unqiueColorStyle = Style.f_131099_.m_131148_(VaultGearRarity.UNIQUE.getColor());
            tooltip.add((Component)new TextComponent("Applied Unique Jewels:").m_130948_(unqiueColorStyle));
            ToolItem.getAppliedUniques(stack).forEach(entry -> tooltip.add((Component)new TextComponent("- " + entry.getName()).m_130948_(unqiueColorStyle)));
        }
    }

    @Override
    public void addTooltipRarity(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
    }

    public void m_6787_(@Nonnull CreativeModeTab category, @Nonnull NonNullList<ItemStack> items) {
        if (!this.m_41389_(category)) {
            return;
        }
        for (ToolMaterial material : ToolMaterial.values()) {
            for (ToolType type : ToolType.values()) {
                items.add((Object)ToolItem.create(material, type));
            }
        }
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return ToolItemRenderer.INSTANCE;
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        for (ToolType type : ToolType.values()) {
            consumer.accept(new ModelResourceLocation("the_vault:tool/%s/handle#inventory".formatted(type.getId())));
            for (ToolMaterial material : ToolMaterial.values()) {
                consumer.accept(new ModelResourceLocation("the_vault:tool/%s/head/%s#inventory".formatted(type.getId(), material.getId())));
            }
        }
    }

    public static ItemStack create(ToolMaterial material, ToolType type) {
        return ToolItem.create(material, type, data -> {});
    }

    public static ItemStack create(ToolMaterial material, ToolType type, Consumer<VaultGearData> consumer) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.TOOL);
        VaultGearData data = VaultGearData.read(stack);
        data.setState(VaultGearState.IDENTIFIED);
        data.setItemLevel(material.getLevel());
        data.setRepairSlots(material.getRepairs());
        data.createOrReplaceAttributeValue(ModGearAttributes.TOOL_CAPACITY, material.getCapacity());
        data.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier<Float>(ModGearAttributes.MINING_SPEED, Float.valueOf(material.getMiningSpeed())));
        data.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier<Integer>(ModGearAttributes.DURABILITY, material.getDurability()));
        if (type.has(ToolType.HAMMER)) {
            data.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier<Integer>(ModGearAttributes.HAMMER_SIZE, 1));
        }
        data.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier<ToolMaterial>(ModGearAttributes.TOOL_MATERIAL, material));
        for (VaultGearAttribute<Boolean> attribute : type.getAttributes()) {
            data.addModifier(VaultGearModifier.AffixType.PREFIX, new VaultGearModifier<Boolean>(attribute, true));
        }
        consumer.accept(data);
        data.write(stack);
        stack.m_41784_().m_128356_("offset", 0L);
        return stack;
    }

    public static void offset(ItemStack stack, int right, int up) {
        VaultGearData data = VaultGearData.read(stack);
        int size = data.get(ModGearAttributes.HAMMER_SIZE, VaultGearAttributeTypeMerger.intSum());
        long offset = stack.m_41784_().m_128454_("offset");
        int offsetRight = Mth.m_14045_((int)((int)(offset >>> 32) + right), (int)(-size), (int)size);
        int offsetUp = Mth.m_14045_((int)((int)offset + up), (int)(-size), (int)size);
        stack.m_41784_().m_128356_("offset", (long)offsetRight << 32 | Integer.toUnsignedLong(offsetUp));
    }

    public static Iterator<BlockPos> getHammerPositions(Level world, ItemStack stack, BlockPos origin, Direction face, Entity entity) {
        if (!ToolItem.canUse(stack, entity)) {
            return Collections.emptyIterator();
        }
        VaultGearData data = VaultGearData.read(stack);
        int size = data.get(ModGearAttributes.HAMMER_SIZE, VaultGearAttributeTypeMerger.intSum());
        long offset = stack.m_41784_().m_128454_("offset");
        int offsetRight = (int)(offset >>> 32);
        int offsetUp = (int)offset;
        Direction right = switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> entity.m_6350_().m_122427_();
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> face.m_122428_();
        };
        Direction up = switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> entity.m_6350_().m_122424_();
            case Direction.UP -> entity.m_6350_();
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> Direction.UP;
        };
        BlockState originState = world.m_8055_(origin);
        return Iterators.concat(new MappingIterator<Integer, MappingIterator>((Iterator<Integer>)IntIterators.fromTo((int)(-size), (int)(size + 1)), r -> new MappingIterator<Integer, BlockPos>((Iterator<Integer>)IntIterators.fromTo((int)(-size), (int)(size + 1)), u -> {
            Player player;
            PlayerInteractEvent.LeftClickBlock event;
            BlockPos pos = origin.m_5484_(right, r + offsetRight).m_5484_(up, u + offsetUp);
            BlockState state = world.m_8055_(pos);
            if (pos.m_123342_() < world.m_141937_() || pos.m_123342_() >= world.m_151558_()) {
                return null;
            }
            if (!(originState.m_60734_() instanceof VaultChestBlock) && state.m_60734_() instanceof VaultChestBlock) {
                return null;
            }
            if (entity instanceof Player && ((event = ForgeHooks.onLeftClickBlock((Player)(player = (Player)entity), (BlockPos)pos, (Direction)face)).isCanceled() || !player.m_7500_() && event.getUseItem() == Event.Result.DENY)) {
                return null;
            }
            return pos;
        })));
    }

    public static boolean applyJewel(ItemStack tool, ItemStack jewel, boolean checkCapacity) {
        VaultGearData toolData = VaultGearData.read(tool);
        List<ResourceLocation> appliedUniqueKeys = ToolItem.getAppliedUniqueKeys(tool);
        VaultGearData jewelData = VaultGearData.read(jewel);
        List<ResourceLocation> jewelUniqueKeys = jewelData.get(ModGearAttributes.UNIQUE_ITEM_KEY, VaultGearAttributeTypeMerger.asList());
        if (jewelUniqueKeys.stream().anyMatch(appliedUniqueKeys::contains)) {
            return false;
        }
        int capacity = toolData.getFirstValue(ModGearAttributes.TOOL_CAPACITY).orElse(0);
        int size = jewelData.getFirstValue(ModGearAttributes.JEWEL_SIZE).orElse(0);
        if (checkCapacity && capacity - size < 0) {
            return false;
        }
        toolData.createOrReplaceAttributeValue(ModGearAttributes.TOOL_CAPACITY, capacity - size);
        for (VaultGearModifier.AffixType affix : VaultGearModifier.AffixType.explicits()) {
            for (VaultGearModifier<?> jewelModifier : jewelData.getModifiers(affix)) {
                if (jewelModifier.getAttribute() == ModGearAttributes.HAMMER_SIZE && !toolData.get(ModGearAttributes.HAMMERING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) continue;
                ToolItem.mergeModifier(affix, toolData, jewelModifier);
            }
        }
        for (VaultGearAttributeInstance vaultGearAttributeInstance : toolData.getModifiers(ModGearAttributes.HAMMER_SIZE, VaultGearData.Type.ALL_MODIFIERS)) {
            vaultGearAttributeInstance.setValue(Math.min((Integer)vaultGearAttributeInstance.getValue(), 7));
        }
        toolData.setItemLevel(Math.max(toolData.getItemLevel(), jewelData.getItemLevel()));
        toolData.write(tool);
        jewelUniqueKeys.forEach(key -> ToolItem.addAppliedUnique(tool, key));
        return true;
    }

    public static <T> void mergeModifier(VaultGearModifier.AffixType affix, VaultGearData targetData, VaultGearModifier<T> toAdd) {
        List matching = targetData.getModifiers(toAdd.getAttribute(), VaultGearData.Type.EXPLICIT_MODIFIERS);
        if (matching.isEmpty()) {
            targetData.addModifier(affix, new VaultGearModifier(toAdd.getAttribute(), toAdd.getValue()));
        } else {
            matching.stream().findFirst().ifPresent(current -> {
                Object newValue = ToolItem.merge(current, toAdd.getValue()).orElse(null);
                if (newValue != null) {
                    current.setValue(newValue);
                } else {
                    targetData.addModifier(affix, toAdd);
                }
            });
        }
    }

    private static <T> Optional<T> merge(VaultGearAttributeInstance<T> attributeInstance, T toAdd) {
        Object result;
        VaultGearAttribute<T> attribute = attributeInstance.getAttribute();
        if (attribute.getAttributeComparator() != null && (result = attribute.getAttributeComparator().merge(attributeInstance.getValue(), toAdd).orElse(null)) != null) {
            return Optional.of(result);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public VaultGearClassification getClassification(ItemStack stack) {
        return VaultGearClassification.TOOL;
    }

    @Override
    @Nonnull
    public VaultGearType getGearType(ItemStack stack) {
        return VaultGearType.TOOL;
    }

    @Override
    @Nullable
    public ResourceLocation getRandomModel(ItemStack stack, Random random, @Nullable Player player, @Nullable DiscoveredModelsData discoveredModelsData) {
        return null;
    }

    public static void addAppliedUnique(ItemStack stack, ResourceLocation uniqueKey) {
        if (!(stack.m_41720_() instanceof ToolItem)) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        ListTag uniques = tag.m_128437_("addedUniques", 8);
        uniques.add((Object)StringTag.m_129297_((String)uniqueKey.toString()));
        tag.m_128365_("addedUniques", (Tag)uniques);
    }

    public static List<UniqueGearConfig.Entry> getAppliedUniques(ItemStack stack) {
        return ToolItem.getAppliedUniqueKeys(stack).stream().map(key -> ModConfigs.UNIQUE_GEAR.getEntry((ResourceLocation)key)).filter(Optional::isPresent).map(Optional::get).toList();
    }

    public static List<ResourceLocation> getAppliedUniqueKeys(ItemStack stack) {
        if (!(stack.m_41720_() instanceof ToolItem)) {
            return Collections.emptyList();
        }
        CompoundTag tag = stack.m_41784_();
        ListTag uniques = tag.m_128437_("addedUniques", 8);
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        for (Tag unique : uniques) {
            result.add(new ResourceLocation(unique.m_7916_()));
        }
        return result;
    }

    public static boolean handleLoot(LootContext context, List<ItemStack> loot) {
        ItemStack stack = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        return ToolItem.handleLoot(context.m_78952_(), stack, entity, loot);
    }

    public static boolean handleLoot(LootContext.Builder context, List<ItemStack> loot) {
        ItemStack stack = (ItemStack)context.m_78982_(LootContextParams.f_81463_);
        Entity entity = (Entity)context.m_78982_(LootContextParams.f_81455_);
        return ToolItem.handleLoot(context.m_78962_(), stack, entity, loot);
    }

    public static boolean handleLoot(ServerLevel world, ItemStack stack, Entity entity, List<ItemStack> loot) {
        if (stack == null || stack.m_41720_() != ModItems.TOOL) {
            return false;
        }
        VaultGearData data = VaultGearData.read(stack);
        if (entity != null && entity.m_6144_()) {
            if (data.get(ModGearAttributes.SMELTING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                Smelting.handle(world, loot);
            }
            if (data.get(ModGearAttributes.PULVERIZING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                Pulverizing.handle(loot);
            }
        } else {
            if (data.get(ModGearAttributes.PULVERIZING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                Pulverizing.handle(loot);
            }
            if (data.get(ModGearAttributes.SMELTING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                Smelting.handle(world, loot);
            }
        }
        return true;
    }

    @Deprecated
    public static void addCapacity(ItemStack tool, int amount) {
        VaultGearData data = VaultGearData.read(tool);
        if (!data.hasAttribute(ModGearAttributes.TOOL_MATERIAL) || !data.hasAttribute(ModGearAttributes.TOOL_CAPACITY)) {
            return;
        }
        int capacity = data.getFirstValue(ModGearAttributes.TOOL_CAPACITY).orElse(0);
        data.createOrReplaceAttributeValue(ModGearAttributes.TOOL_CAPACITY, capacity + amount);
        data.write(tool);
    }

    @Override
    public void initialize(ItemStack stack, RandomSource rand) {
        String prebuiltTool;
        if (stack.m_41784_().m_128441_("vaultPrebuiltTool") && !(prebuiltTool = stack.m_41784_().m_128461_("vaultPrebuiltTool")).isEmpty()) {
            if (ModConfigs.PRE_BUILT_TOOLS.apply(prebuiltTool, stack)) {
                stack.m_41784_().m_128473_("vaultPrebuiltTool");
            } else {
                VaultMod.LOGGER.warn("Failed to apply prebuilt tool: {} to stack: {}", (Object)prebuiltTool, (Object)stack);
            }
        }
    }
}

