/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import iskallia.vault.init.ModLootConditions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public class HasBlockEntityTagCondition
implements LootItemCondition {
    private final String tagName;

    public HasBlockEntityTagCondition(String tagName) {
        this.tagName = tagName;
    }

    public boolean test(LootContext context) {
        BlockEntity blockEntity = (BlockEntity)context.m_78953_(LootContextParams.f_81462_);
        if (blockEntity == null) {
            return false;
        }
        CompoundTag nbt = blockEntity.m_187482_();
        return nbt.m_128441_(this.tagName);
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ModLootConditions.HAS_BLOCK_ENTITY_TAG.get();
    }

    public static class ConditionSerializer
    implements Serializer<HasBlockEntityTagCondition> {
        public void serialize(JsonObject json, HasBlockEntityTagCondition condition, @NotNull JsonSerializationContext context) {
            json.addProperty("tag", condition.tagName);
        }

        @NotNull
        public HasBlockEntityTagCondition deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            return new HasBlockEntityTagCondition(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
        }
    }
}

