/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.item.LegacyMagnetItem;
import iskallia.vault.item.MagnetItem;
import iskallia.vault.item.crystal.VaultCrystalItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity {
    private ItemStack previousStack;

    @Shadow
    public abstract ItemStack m_32055_();

    public ItemEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo ci) {
        Item item = this.m_32055_().m_41720_();
        if (item instanceof VaultCrystalItem) {
            VaultCrystalItem crystalItem = (VaultCrystalItem)item;
            crystalItem.onWorldTick(this.f_19853_, (ItemEntity)this);
        }
    }

    @Inject(method={"playerTouch"}, at={@At(value="RETURN", ordinal=1)})
    public void onPickupEventCancelled(Player entity, CallbackInfo ci) {
        LegacyMagnetItem.onAfterItemPickup(entity, (ItemEntity)this);
    }

    @Inject(method={"playerTouch"}, at={@At(value="RETURN", ordinal=2)})
    public void onPartialStackPickup(Player entity, CallbackInfo ci) {
        LegacyMagnetItem.onAfterItemPickup(entity, (ItemEntity)this);
    }

    @Inject(method={"playerTouch"}, at={@At(value="HEAD")})
    public void onPickupHead(Player entity, CallbackInfo ci) {
        this.previousStack = this.m_32055_().m_41777_();
    }

    @Inject(method={"playerTouch"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;onItemPickup(Lnet/minecraft/world/entity/item/ItemEntity;)V")})
    public void onPickupVanilla(Player entity, CallbackInfo ci) {
        MagnetItem.onPlayerPickup(entity, (ItemEntity)this);
    }

    @Inject(method={"playerTouch"}, at={@At(value="RETURN", ordinal=2)})
    public void onPickupModded(Player player, CallbackInfo ci) {
        if (!ItemStack.m_41728_((ItemStack)this.m_32055_(), (ItemStack)this.previousStack)) {
            MagnetItem.onPlayerPickup(player, (ItemEntity)this);
        }
    }

    @Inject(method={"playerTouch"}, at={@At(value="RETURN", ordinal=1)})
    public void onPickupCanceled(Player player, CallbackInfo ci) {
        if (!ItemStack.m_41728_((ItemStack)this.m_32055_(), (ItemStack)this.previousStack)) {
            MagnetItem.onPlayerPickup(player, (ItemEntity)this);
            this.previousStack = this.m_32055_().m_41777_();
        }
    }
}

