/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.item.IAnvilPreventCombination;
import iskallia.vault.item.crystal.recipe.AnvilContext;
import iskallia.vault.item.crystal.recipe.AnvilMenuProxy;
import iskallia.vault.item.crystal.recipe.AnvilRecipe;
import iskallia.vault.item.crystal.recipe.AnvilRecipes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={AnvilMenu.class}, priority=1001)
public abstract class MixinAnvilMenu
extends ItemCombinerMenu
implements AnvilMenuProxy {
    @Shadow
    private String f_39001_;
    @Shadow
    @Final
    private DataSlot f_39002_;
    @Shadow
    public int f_39000_;
    @Unique
    private AnvilContext context;
    @Unique
    private AnvilRecipe recipe;
    @Unique
    private boolean fake;

    public MixinAnvilMenu(@Nullable MenuType<?> p_39773_, int p_39774_, Inventory p_39775_, ContainerLevelAccess p_39776_) {
        super(p_39773_, p_39774_, p_39775_, p_39776_);
    }

    @Override
    public boolean isFake() {
        return this.fake;
    }

    @Override
    public void setFake(boolean fake) {
        this.fake = fake;
    }

    @Inject(method={"createResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getEnchantments(Lnet/minecraft/world/item/ItemStack;)Ljava/util/Map;", ordinal=1)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    protected void preventRepairResult(CallbackInfo ci, ItemStack inputLeft, int cost, int baseCost, int costIncrease, ItemStack inputLeftCopy, ItemStack inputRight) {
        IAnvilPreventCombination preventCombination;
        if (inputLeftCopy.m_41619_() || inputRight.m_41619_()) {
            return;
        }
        Item item = inputLeftCopy.m_41720_();
        if (item instanceof IAnvilPreventCombination && (preventCombination = (IAnvilPreventCombination)item).shouldPreventAnvilCombination(inputRight)) {
            ci.cancel();
        }
        if ((item = inputRight.m_41720_()) instanceof IAnvilPreventCombination && (preventCombination = (IAnvilPreventCombination)item).shouldPreventAnvilCombination(inputLeft)) {
            ci.cancel();
        }
    }

    @Inject(method={"createResult"}, at={@At(value="HEAD")}, cancellable=true)
    public void createResult(CallbackInfo ci) {
        this.f_39768_.m_6836_(0, ItemStack.f_41583_);
        this.context = AnvilContext.ofAnvil(this.f_39770_, this.f_39771_, this.f_39769_, this.f_39001_);
        this.recipe = AnvilRecipes.get(this.context).orElse(null);
        if (this.recipe != null) {
            this.f_39000_ = 0;
            this.f_39002_.m_6422_(this.context.getLevelCost());
            this.f_39768_.m_6836_(0, this.context.getOutput());
            this.m_38946_();
            ci.cancel();
        }
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onTake(Player player, ItemStack stack, CallbackInfo ci) {
        if (this.recipe != null) {
            this.context.getTake().run();
            this.f_39769_.m_6836_(0, this.context.getInput()[0]);
            this.f_39769_.m_6836_(1, this.context.getInput()[1]);
            ci.cancel();
        }
    }

    @Inject(method={"mayPickup"}, at={@At(value="HEAD")}, cancellable=true)
    protected void mayPickup(Player player, boolean nonEmpty, CallbackInfoReturnable<Boolean> cir) {
        if (this.recipe != null) {
            cir.setReturnValue((Object)(player.m_150110_().f_35937_ || player.f_36078_ >= this.f_39002_.m_6501_() ? 1 : 0));
        }
    }
}

