/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.OverlevelEnchantHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public abstract class MixinItem {
    @Inject(method={"getName"}, cancellable=true, at={@At(value="RETURN")})
    public void appendOverlevelPrefix(ItemStack stack, CallbackInfoReturnable<Component> info) {
        MutableComponent formatted;
        int overLevels;
        if (stack.m_41720_() == Items.f_42690_ && (overLevels = OverlevelEnchantHelper.getOverlevels(stack)) != -1 && (formatted = ModConfigs.OVERLEVEL_ENCHANT.format((Component)info.getReturnValue(), overLevels)) != null) {
            info.setReturnValue((Object)formatted);
            info.cancel();
        }
    }

    @Inject(method={"getBarWidth"}, at={@At(value="RETURN")}, cancellable=true)
    public void applyBrokenVaultGearBarWidth(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        VaultGearItem item;
        Item item2 = stack.m_41720_();
        if (item2 instanceof VaultGearItem && (item = (VaultGearItem)item2).isBroken(stack)) {
            cir.setReturnValue((Object)13);
        }
    }

    @Inject(method={"getBarColor"}, at={@At(value="RETURN")}, cancellable=true)
    public void applyBrokenVaultGearBarColor(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        VaultGearItem item;
        Item item2 = stack.m_41720_();
        if (item2 instanceof VaultGearItem && (item = (VaultGearItem)item2).isBroken(stack)) {
            cir.setReturnValue((Object)0xFF0000);
        }
    }

    @Inject(method={"isBarVisible"}, at={@At(value="RETURN")}, cancellable=true)
    public void setBrokenVaultGearBarVisible(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        VaultGearItem item;
        Item item2 = stack.m_41720_();
        if (item2 instanceof VaultGearItem && (item = (VaultGearItem)item2).isBroken(stack)) {
            cir.setReturnValue((Object)true);
        }
    }
}

