/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.AntiqueItem;
import iskallia.vault.item.CoinPouchItem;
import iskallia.vault.item.ItemVaultKeyring;
import iskallia.vault.item.bottle.BottleItem;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.item.gear.VaultCharmItem;
import iskallia.vault.item.gear.VoidStoneItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemRenderer.class})
public class MixinItemRenderer {
    @Inject(method={"renderGuiItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;drawInBatch(Ljava/lang/String;FFIZLcom/mojang/math/Matrix4f;Lnet/minecraft/client/renderer/MultiBufferSource;ZII)I")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void preStackCount(Font font, ItemStack stack, int x, int y, String text, CallbackInfo ci, PoseStack matrixStack) {
        boolean isAntique = stack.m_150930_((Item)ModItems.ANTIQUE);
        if (!(isAntique || text == null && stack.m_41613_() >= 1000)) {
            return;
        }
        String countStr = (text = ChatFormatting.m_126649_((String)text)) != null ? text : String.valueOf(stack.m_41613_());
        int strLength = countStr.length();
        if (isAntique) {
            strLength = Math.max(strLength, 5);
        }
        String countLengthStr = Strings.repeat((String)"8", (int)strLength);
        String comparisonLength = Strings.repeat((String)"8", (int)3);
        float width = font.m_92895_(countLengthStr);
        float compareWidth = font.m_92895_(comparisonLength);
        float posX = x + 19 - 2;
        Objects.requireNonNull(font);
        float posY = y + 6 + 3 + 9;
        matrixStack.m_85837_((double)posX, (double)posY, 0.0);
        float scale = compareWidth / width;
        matrixStack.m_85841_(scale, scale, 1.0f);
        matrixStack.m_85837_((double)(-posX), (double)(-posY - 1.0f), 0.0);
    }

    @ModifyVariable(method={"renderGuiItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at=@At(value="HEAD"), index=5, argsOnly=true)
    public String overrideText(String ovrText, Font font, ItemStack stack, int x, int y, String text) {
        if (stack.m_150930_((Item)ModItems.ANTIQUE)) {
            text = AntiqueItem.buildAntiqueCountText(text, stack);
        }
        if (((IVaultOptions)Minecraft.m_91087_().f_91066_).getShowUsesAsStackSize()) {
            if (stack.m_150930_((Item)ModItems.TRINKET)) {
                text = TrinketItem.isIdentified(stack) ? ChatFormatting.YELLOW.toString() + (TrinketItem.getUses(stack) - TrinketItem.getUsedVaults(stack).size()) : text;
            } else if (stack.m_150930_((Item)ModItems.VAULT_GOD_CHARM)) {
                text = VaultCharmItem.isIdentified(stack) ? ChatFormatting.YELLOW.toString() + (VaultCharmItem.getUses(stack) - VaultCharmItem.getUsedVaults(stack).size()) : text;
            } else if (stack.m_150930_((Item)ModItems.VOID_STONE)) {
                String string = text = VoidStoneItem.isIdentified(stack) ? ChatFormatting.YELLOW.toString() + (VoidStoneItem.getUses(stack) - VoidStoneItem.getUsedVaults(stack).size()) : text;
            }
        }
        if (((IVaultOptions)Minecraft.m_91087_().f_91066_).getShowKeyringContents() && stack.m_150930_((Item)ModItems.TREAUSURE_KEYRING)) {
            text = MixinItemRenderer.getKeyringDisplayText(stack);
        }
        return text;
    }

    private static String getKeyringDisplayText(ItemStack keyring) {
        List<OverSizedItemStack> keys = ItemVaultKeyring.getStoredStacks(keyring);
        int totalKeys = keys.stream().mapToInt(stack -> stack.isEmpty() ? 0 : stack.amount()).sum();
        return totalKeys > 0 ? ChatFormatting.AQUA.toString() + totalKeys : "";
    }

    @Inject(method={"renderGuiItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isBarVisible()Z")})
    public void renderModifierCategoryOverlay(Font font, ItemStack stack, int x, int y, String text, CallbackInfo ci) {
        GearDataCache cache = GearDataCache.of(stack);
        ArrayList<ResourceLocation> icons = new ArrayList<ResourceLocation>();
        Stream.of(VaultGearModifier.AffixCategory.values()).filter(cat -> cat.getOverlayIcon() != null).filter(cache::hasModifierOfCategory).forEach(cat -> icons.add(cat.getOverlayIcon()));
        if (cache.getState() == VaultGearState.UNIDENTIFIED && cache.hasAttribute(ModGearAttributes.IS_LEGENDARY)) {
            icons.add(VaultGearModifier.AffixCategory.LEGENDARY.getOverlayIcon());
        }
        if (cache.getState() == VaultGearState.IDENTIFIED && cache.hasAttribute(ModGearAttributes.LIVING)) {
            icons.add(VaultMod.id("textures/item/gear/living_overlay.png"));
        }
        if (icons.isEmpty()) {
            return;
        }
        icons.forEach(icon -> {
            RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69465_();
            ScreenDrawHelper.drawTexturedQuads(buf -> {
                PoseStack pose = new PoseStack();
                ScreenDrawHelper.rect((VertexConsumer)buf, pose).at(x, y).dim(16.0f, 16.0f).draw();
            });
            RenderSystem.m_69482_();
            RenderSystem.m_69461_();
        });
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/ItemRenderer;render(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/renderer/block/model/ItemTransforms$TransformType;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/resources/model/BakedModel;)V"}, at={@At(value="HEAD")})
    public void animateBottle(ItemStack stack, ItemTransforms.TransformType transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model, CallbackInfo ci) {
        if (transformType == ItemTransforms.TransformType.GUI && stack.m_41720_() == ModItems.BOTTLE) {
            BottleItem.onBeforeGuiItemRender(stack, poseStack);
        } else if (transformType == ItemTransforms.TransformType.GUI && stack.m_41720_() == ModItems.COIN_POUCH) {
            CoinPouchItem.onBeforeGuiItemRender(stack, poseStack);
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/ItemRenderer;render(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/renderer/block/model/ItemTransforms$TransformType;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/resources/model/BakedModel;)V"}, at={@At(value="TAIL")})
    public void animateBottlePop(ItemStack stack, ItemTransforms.TransformType transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model, CallbackInfo ci) {
        if (transformType == ItemTransforms.TransformType.GUI && stack.m_41720_() == ModItems.BOTTLE) {
            BottleItem.onAfterGuiItemRender(stack, poseStack);
        } else if (transformType == ItemTransforms.TransformType.GUI && stack.m_41720_() == ModItems.COIN_POUCH) {
            CoinPouchItem.onAfterGuiItemRender(stack, poseStack);
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/ItemRenderer;renderGuiItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="TAIL")})
    public void renderBottleProgressNotification(Font font, ItemStack stack, int xPosition, int yPosition, String text, CallbackInfo ci) {
        if (stack.m_41720_() == ModItems.BOTTLE) {
            BottleItem.renderBottleProgressNotification(font, stack, xPosition, yPosition);
        }
    }
}

