/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModModelDiscoveryGoals;
import iskallia.vault.mana.ManaAction;
import iskallia.vault.mana.ManaPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class MixinManaPlayerEntity
extends LivingEntity
implements ManaPlayer {
    private static EntityDataAccessor<Float> MANA;

    protected MixinManaPlayerEntity(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    protected void ifYouImmediatelyKnowTheCandleLightIsFireThenTheMealWasCookedALongTimeAgo(CallbackInfo ci) {
        if (MANA == null) {
            MANA = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        }
        this.player().m_20088_().m_135372_(MANA, (Object)Float.valueOf(100.0f));
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    protected void load(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128425_("mana", 5)) {
            this.player().m_20088_().m_135381_(MANA, (Object)Float.valueOf(nbt.m_128457_("mana")));
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    protected void save(CompoundTag nbt, CallbackInfo ci) {
        float mana = ((Float)this.player().m_20088_().m_135370_(MANA)).floatValue();
        nbt.m_128350_("mana", mana);
    }

    private Player player() {
        return (Player)this;
    }

    @Override
    public float getMana() {
        return ((Float)this.player().m_20088_().m_135370_(MANA)).floatValue();
    }

    @Override
    public float setMana(ManaAction action, float amount) {
        ServerPlayer serverPlayer;
        Player player = this.player();
        ManaPlayer manaSource = (ManaPlayer)player;
        float manaMax = manaSource.getManaMax();
        float oldAmount = this.getMana();
        float newAmount = Mth.m_14036_((float)amount, (float)0.0f, (float)manaMax);
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            if (newAmount < manaMax) {
                ModModelDiscoveryGoals.LV50_VAULT_COMPLETED_WITHOUT_MANA_USAGE.markFailed(serverPlayer);
            }
        } else {
            throw new IllegalStateException("Don't call this from the client!");
        }
        serverPlayer.m_20088_().m_135381_(MANA, (Object)Float.valueOf(newAmount));
        this.onModify(action, oldAmount, newAmount);
        return newAmount;
    }

    @Override
    public float getManaMax() {
        AttributeInstance attributeInstance = this.player().m_21051_(ModAttributes.MANA_MAX);
        return attributeInstance != null ? (float)attributeInstance.m_22135_() : 0.0f;
    }

    @Override
    public float getManaRegenPerSecond() {
        AttributeInstance attributeInstance = this.player().m_21051_(ModAttributes.MANA_REGEN);
        return attributeInstance != null ? (float)attributeInstance.m_22135_() : 0.0f;
    }

    @Override
    public float increaseMana(ManaAction action, float amount) {
        return this.setMana(action, this.getMana() + amount);
    }

    @Override
    public float decreaseMana(ManaAction action, float amount) {
        return this.increaseMana(action, -amount);
    }
}

