/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import com.mojang.authlib.GameProfile;
import iskallia.vault.core.SkyVaultsChunkGenerator;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.VirtualWorlds;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.event.TickEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer {
    @Shadow
    protected abstract ServerLevel[] getWorldArray();

    @Shadow
    protected abstract boolean m_7038_() throws IOException;

    @Redirect(method={"tickChildren"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getWorldArray()[Lnet/minecraft/server/level/ServerLevel;"))
    public ServerLevel[] tickChildren(MinecraftServer instance) {
        return (ServerLevel[])Arrays.stream(this.getWorldArray()).filter(world -> !(world instanceof VirtualWorld)).toArray(ServerLevel[]::new);
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", ordinal=0, shift=At.Shift.AFTER)})
    public void tickChildrenStart(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        VirtualWorlds.tick(hasTimeLeft, TickEvent.Phase.START);
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", ordinal=1, shift=At.Shift.BEFORE)})
    public void tickChildrenEnd(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        VirtualWorlds.tick(hasTimeLeft, TickEvent.Phase.END);
    }

    @Inject(method={"createLevels"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/border/WorldBorder;applySettings(Lnet/minecraft/world/level/border/WorldBorder$Settings;)V", shift=At.Shift.BEFORE)})
    public void createLevels(ChunkProgressListener holder, CallbackInfo ci) {
        VirtualWorlds.load();
    }

    @Inject(method={"setInitialSpawn"}, at={@At(value="HEAD")}, cancellable=true)
    private static void setInitialSpawn(ServerLevel world, ServerLevelData data, boolean p_177899_, boolean p_177900_, CallbackInfo ci) {
        if (world.m_7726_().m_8481_() instanceof SkyVaultsChunkGenerator) {
            ci.cancel();
        }
    }

    @Redirect(method={"tickServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getGameProfile()Lcom/mojang/authlib/GameProfile;"))
    public GameProfile setPlayerNameForStatus(ServerPlayer serverPlayer) {
        Object name = serverPlayer.m_7755_().getString();
        UUID id = serverPlayer.m_142081_();
        if (ServerVaults.get(serverPlayer.f_19853_).isPresent()) {
            name = (String)name + " (Vault)";
        }
        return new GameProfile(id, (String)name);
    }
}

