/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.item.render.core.IManualModelLoading;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelBakery.class})
public abstract class MixinModelBakery {
    @Final
    @Shadow
    protected ResourceManager f_119243_;

    @Shadow
    protected abstract void m_119306_(ModelResourceLocation var1);

    @Inject(method={"loadBlockModel"}, at={@At(value="HEAD")}, cancellable=true)
    public void loadBlockModel(ResourceLocation id, CallbackInfoReturnable<BlockModel> cir) {
        if (!id.m_135815_().startsWith("item/")) {
            return;
        }
        ResourceLocation itemModelLocation = DynamicModel.removePrefixFromId("item/", id);
        ModDynamicModels.REGISTRIES.getModelByResourceLocation(itemModelLocation).ifPresent(dynamicModel -> {
            BlockModel itemModel = this.loadItemModel(id, (DynamicModel<?>)dynamicModel);
            itemModel.f_111416_ = id.toString();
            cir.setReturnValue((Object)itemModel);
        });
        if (id.m_135827_().equals("the_vault") && id.m_135815_().startsWith("item/tool/")) {
            StringReader reader = new StringReader("{\"parent\":\"item/handheld\",\"textures\":{\"layer0\":\"%s\"}}".formatted(id.toString()));
            try {
                BlockModel model = BlockModel.m_111461_((Reader)reader);
                model.f_111416_ = id.toString();
                cir.setReturnValue((Object)model);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private BlockModel loadItemModel(ResourceLocation resourceLocation, DynamicModel<?> dynamicModel) {
        ResourceManager resourceManager = this.f_119243_;
        if (ModDynamicModels.jsonModelExists(resourceManager, resourceLocation)) {
            try {
                ResourceLocation modelPath = new ResourceLocation(resourceLocation.m_135827_(), "models/" + resourceLocation.m_135815_() + ".json");
                Resource resource = resourceManager.m_142591_(modelPath);
                InputStreamReader reader = new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8);
                return BlockModel.m_111461_((Reader)reader);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Map<String, ResourceLocation> textures = dynamicModel.resolveTextures(resourceManager, resourceLocation);
        return dynamicModel.generateItemModel(textures);
    }

    @Redirect(method={"processLoading"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", ordinal=2))
    private void onItemLoading(ProfilerFiller profiler, String phase) {
        ForgeRegistries.ITEMS.forEach(item -> {
            if (item instanceof IManualModelLoading) {
                IManualModelLoading loader = (IManualModelLoading)item;
                loader.loadModels(this::m_119306_);
            }
        });
        profiler.m_6182_(phase);
    }
}

