/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.overlay.VaultMapOverlay;
import iskallia.vault.client.render.HudPosition;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.client.render.InventoryHudRenderer;
import iskallia.vault.client.render.healthbar.HealthbarAccessibilityHeightOption;
import iskallia.vault.client.render.healthbar.HealthbarDisplayOption;
import iskallia.vault.client.render.hunter.HunterParticleDensityOption;
import iskallia.vault.entity.entity.VaultDamageNumberEntity;
import iskallia.vault.util.ColorOption;
import iskallia.vault.util.CooldownGuiOption;
import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Options.class})
public abstract class MixinOptions
implements IVaultOptions {
    public CooldownGuiOption cooldownOption = CooldownGuiOption.OFF;
    public boolean doVanillaPotionDamageEffects = false;
    public boolean abilityScrollingEnabled = true;
    public boolean showTreasureDoorNames = false;
    public boolean highlightRarityEnabled = true;
    public boolean showPointMessages = true;
    public boolean showRarityNames = false;
    public boolean abilityQuickbindEditingEnabled = false;
    public ColorOption chestHunterSpec = new ColorOption(ColorOption.HunterSpec.WOODEN, 0.8901961f, 0.5529412f, 0.0f);
    public ColorOption blockHunterSpec = new ColorOption(ColorOption.HunterSpec.OBSERVER, 0.14509805f, 0.6745098f, 0.0f);
    public ColorOption gildedHunterSpec = new ColorOption(ColorOption.HunterSpec.GILDED, 1.0f, 1.0f, 0.0f);
    public ColorOption livingHunterSpec = new ColorOption(ColorOption.HunterSpec.LIVING, 0.0f, 1.0f, 0.0f);
    public ColorOption ornateHunterSpec = new ColorOption(ColorOption.HunterSpec.ORNATE, 0.93333334f, 0.0f, 0.0f);
    public ColorOption coinsHunterSpec = new ColorOption(ColorOption.HunterSpec.COINS, 0.8039216f, 0.44705883f, 0.15294118f);
    public HunterParticleDensityOption hunterParticleDensity = HunterParticleDensityOption.NORMAL;
    private boolean showHudOnlyOnTab = false;
    private InventoryHudRenderer.InventoryHudDisplayMode inventoryHudMode = InventoryHudRenderer.InventoryHudDisplayMode.LOW;
    private InventoryHudRenderer.InventoryHudDisplayMode inventoryUsesHudMode = InventoryHudRenderer.InventoryHudDisplayMode.LOW;
    private InventoryHudRenderer.PositionMode inventoryHudPercentageDisplayMode = InventoryHudRenderer.PositionMode.OFF;
    private boolean showOverlay = false;
    private final Map<String, HudPosition> hudPositions = new HashMap<String, HudPosition>();
    public HealthbarDisplayOption healthBarEnabled = HealthbarDisplayOption.VAULT_ONLY;
    public Color healthBarColor = new Color(255, 0, 0);
    public boolean enableCustomHealthBarColor = false;
    public HealthbarAccessibilityHeightOption healthBarHeight = HealthbarAccessibilityHeightOption.SMALL;
    public boolean showMobGroupIcons = true;
    public float mapScale = 1.0f;
    public float mapZoom = 1.0f;
    public float objectiveScale = 1.0f;
    public boolean isVaultLevelBarHidden = false;
    public Map<VaultDamageNumberEntity.DamageType, Color> damageTypeColorMap = new HashMap<VaultDamageNumberEntity.DamageType, Color>();
    public boolean isFlooredDamageParticles = false;
    public HealthbarDisplayOption isDamageParticlesEnabled = HealthbarDisplayOption.VAULT_ONLY;
    public boolean toggleMapOverlay = false;
    public VaultMapOverlay.MapVisibilityOption mapVisibilityOption = VaultMapOverlay.MapVisibilityOption.ALWAYS;
    public float vaultMapOverlayOpacity = 1.0f;
    public IVaultOptions.ScaleMode mapScaleMode = IVaultOptions.ScaleMode.NORMAL;
    public IVaultOptions.ScaleMode mapOverlayScaleMode = IVaultOptions.ScaleMode.NORMAL;
    public IVaultOptions.ScaleMode modifierListScaleMode = IVaultOptions.ScaleMode.NORMAL;
    public HudPosition minimapPosition = new HudPosition(-1.0f, -1.0f);
    public IVaultOptions.GearVisibilityMode gearVisibilityMode = IVaultOptions.GearVisibilityMode.BAR;
    public IVaultOptions.UsesVisibilityMode usesVisibilityMode = IVaultOptions.UsesVisibilityMode.NUMBER;
    public boolean showUsesAsStackSize = false;
    public boolean showKeyringContents = false;
    public boolean showPotionVisibility = true;
    public InventoryHudRenderer.PositionMode usesItemsTextPositionMode = InventoryHudRenderer.PositionMode.LEFT;
    public InventoryHudRenderer.BackpackDisplayMode backpackDisplayMode = InventoryHudRenderer.BackpackDisplayMode.NEAR_PORTAL;
    public IVaultOptions.CompanionNametagMode companionNametagMode = IVaultOptions.CompanionNametagMode.LOOKING;
    public boolean showScavengerInventoryCount = true;
    public float modifierListScale = 1.0f;
    public boolean showAbilitiesWithManaBar = true;
    public float potionScale = 1.0f;
    public float invHudScale = 1.0f;
    public HudPosition mapOverlayPosition = new HudPosition(-1.0f, -1.0f);

    @Shadow
    public abstract void m_92169_();

    @Inject(method={"processOptions"}, at={@At(value="HEAD")})
    private void processVaultOptions(Options.FieldAccess pAccessor, CallbackInfo ci) {
        this.doVanillaPotionDamageEffects = pAccessor.m_142682_("doVanillaPotionDamageEffects", this.doVanillaPotionDamageEffects);
        this.abilityScrollingEnabled = pAccessor.m_142682_("abilityScrollingEnabled", this.abilityScrollingEnabled);
        this.showTreasureDoorNames = pAccessor.m_142682_("showTreasureDoorNames", this.showTreasureDoorNames);
        this.highlightRarityEnabled = pAccessor.m_142682_("highlightRarityEnabled", this.highlightRarityEnabled);
        this.showPointMessages = pAccessor.m_142682_("showPointMessages", this.showPointMessages);
        this.showRarityNames = pAccessor.m_142682_("showRarityNames", this.showRarityNames);
        this.abilityQuickbindEditingEnabled = pAccessor.m_142682_("abilityQuickbindEditingEnabled", this.abilityQuickbindEditingEnabled);
        this.cooldownOption = (CooldownGuiOption)((Object)pAccessor.m_142634_("cooldownGuiOption", (Object)this.cooldownOption, CooldownGuiOption::fromString, CooldownGuiOption::m_7912_));
        this.chestHunterSpec = (ColorOption)pAccessor.m_142634_(ColorOption.HunterSpec.WOODEN.toString(), (Object)this.chestHunterSpec, this::readColorOption, this::writeColorOption);
        this.blockHunterSpec = (ColorOption)pAccessor.m_142634_(ColorOption.HunterSpec.OBSERVER.toString(), (Object)this.blockHunterSpec, this::readColorOption, this::writeColorOption);
        this.gildedHunterSpec = (ColorOption)pAccessor.m_142634_(ColorOption.HunterSpec.GILDED.toString(), (Object)this.gildedHunterSpec, this::readColorOption, this::writeColorOption);
        this.livingHunterSpec = (ColorOption)pAccessor.m_142634_(ColorOption.HunterSpec.LIVING.toString(), (Object)this.livingHunterSpec, this::readColorOption, this::writeColorOption);
        this.ornateHunterSpec = (ColorOption)pAccessor.m_142634_(ColorOption.HunterSpec.ORNATE.toString(), (Object)this.ornateHunterSpec, this::readColorOption, this::writeColorOption);
        this.coinsHunterSpec = (ColorOption)pAccessor.m_142634_(ColorOption.HunterSpec.COINS.toString(), (Object)this.coinsHunterSpec, this::readColorOption, this::writeColorOption);
        this.hunterParticleDensity = (HunterParticleDensityOption)((Object)pAccessor.m_142634_("hunterParticleDensity", (Object)this.hunterParticleDensity, HunterParticleDensityOption::fromString, HunterParticleDensityOption::getSerializedName));
        this.healthBarEnabled = (HealthbarDisplayOption)((Object)pAccessor.m_142634_("healthBarEnabled", (Object)this.healthBarEnabled, HealthbarDisplayOption::fromString, HealthbarDisplayOption::m_7912_));
        this.healthBarColor = (Color)pAccessor.m_142634_("healthBarColor", (Object)this.healthBarColor, this::readColor, this::writeColor);
        this.enableCustomHealthBarColor = pAccessor.m_142682_("enableCustomHealthBarColor", this.enableCustomHealthBarColor);
        this.healthBarHeight = (HealthbarAccessibilityHeightOption)((Object)pAccessor.m_142634_("healthBarHeight", (Object)this.healthBarHeight, value -> {
            HealthbarAccessibilityHeightOption option = HealthbarAccessibilityHeightOption.fromString(value);
            return option != null ? option : HealthbarAccessibilityHeightOption.SMALL;
        }, HealthbarAccessibilityHeightOption::m_7912_));
        this.showMobGroupIcons = pAccessor.m_142682_("showMobGroupIcons", this.showMobGroupIcons);
        this.mapScale = pAccessor.m_142432_("mapScale", this.mapScale);
        this.isVaultLevelBarHidden = pAccessor.m_142682_("isVaultLevelBarHidden", this.isVaultLevelBarHidden);
        for (VaultDamageNumberEntity.DamageType damageType : VaultDamageNumberEntity.DamageType.values()) {
            this.damageTypeColorMap.put(damageType, (Color)pAccessor.m_142634_("vault.damage_particle." + damageType.name().toLowerCase(Locale.ROOT), (Object)this.damageTypeColorMap.getOrDefault((Object)damageType, damageType.getDefaultColorObject()), this::readColor, this::writeColor));
        }
        this.modifierListScale = pAccessor.m_142432_("modifierListScale", this.modifierListScale);
        this.isFlooredDamageParticles = pAccessor.m_142682_("flooredDamageParticles", this.isFlooredDamageParticles);
        this.isDamageParticlesEnabled = (HealthbarDisplayOption)((Object)pAccessor.m_142634_("damageParticlesEnabled", (Object)this.isDamageParticlesEnabled, HealthbarDisplayOption::fromString, HealthbarDisplayOption::m_7912_));
        this.inventoryHudMode = (InventoryHudRenderer.InventoryHudDisplayMode)((Object)pAccessor.m_142634_("inventoryHudMode", (Object)this.inventoryHudMode, InventoryHudRenderer.InventoryHudDisplayMode::fromString, InventoryHudRenderer.InventoryHudDisplayMode::getSerializedName));
        this.inventoryUsesHudMode = (InventoryHudRenderer.InventoryHudDisplayMode)((Object)pAccessor.m_142634_("inventoryUsesHudMode", (Object)this.inventoryUsesHudMode, InventoryHudRenderer.InventoryHudDisplayMode::fromString, InventoryHudRenderer.InventoryHudDisplayMode::getSerializedName));
        this.objectiveScale = pAccessor.m_142432_("objectiveScale", this.objectiveScale);
        this.showAbilitiesWithManaBar = pAccessor.m_142682_("showAbilitiesWithManaBar", this.showAbilitiesWithManaBar);
        for (String slot2 : InventoryHudRenderer.HUD_KEYS) {
            float x = pAccessor.m_142432_("hudPos_" + slot2 + "_x", -1.0f);
            float y = pAccessor.m_142432_("hudPos_" + slot2 + "_y", -1.0f);
            if (x == -1.0f || y == -1.0f) continue;
            if (x > 1.0f || y > 1.0f) {
                int sw = Minecraft.m_91087_().m_91268_().m_85445_();
                int sh = Minecraft.m_91087_().m_91268_().m_85446_();
                this.hudPositions.put(slot2, HudPosition.fromPixels((int)x, (int)y, sw, sh));
                VaultMod.LOGGER.debug("Migrated HUD position for {}", (Object)slot2);
                continue;
            }
            this.hudPositions.put(slot2, new HudPosition(x, y));
        }
        this.hudPositions.forEach((slot, pos) -> {
            pAccessor.m_142432_("hudPos_" + slot + "_x", pos.xPct());
            pAccessor.m_142432_("hudPos_" + slot + "_y", pos.yPct());
        });
        this.potionScale = pAccessor.m_142432_("potionScale", this.potionScale);
        this.invHudScale = pAccessor.m_142432_("invHudScale", this.invHudScale);
        this.mapZoom = pAccessor.m_142432_("mapZoom", this.mapZoom);
        this.showHudOnlyOnTab = pAccessor.m_142682_("showHudOnlyOnTab", this.showHudOnlyOnTab);
        this.inventoryHudPercentageDisplayMode = (InventoryHudRenderer.PositionMode)((Object)pAccessor.m_142634_("inventoryHudPercentageDisplayMode", (Object)this.inventoryHudPercentageDisplayMode, InventoryHudRenderer.PositionMode::fromString, InventoryHudRenderer.PositionMode::getSerializedName));
        this.showOverlay = pAccessor.m_142682_("showOverlay", this.showOverlay);
        this.toggleMapOverlay = pAccessor.m_142682_("toggleMapOverlay", this.toggleMapOverlay);
        this.mapVisibilityOption = (VaultMapOverlay.MapVisibilityOption)((Object)pAccessor.m_142634_("mapVisibilityOption", (Object)this.mapVisibilityOption, VaultMapOverlay.MapVisibilityOption::fromString, VaultMapOverlay.MapVisibilityOption::getSerializedName));
        this.vaultMapOverlayOpacity = pAccessor.m_142432_("vaultMapOverlayOpacity", this.vaultMapOverlayOpacity);
        this.mapScaleMode = (IVaultOptions.ScaleMode)((Object)pAccessor.m_142634_("mapScaleMode", (Object)this.mapScaleMode, IVaultOptions.ScaleMode::fromSerializedName, IVaultOptions.ScaleMode::getSerializedName));
        this.modifierListScaleMode = (IVaultOptions.ScaleMode)((Object)pAccessor.m_142634_("modifierListScaleMode", (Object)this.modifierListScaleMode, IVaultOptions.ScaleMode::fromSerializedName, IVaultOptions.ScaleMode::getSerializedName));
        if (this.minimapPosition.xPct() > 1.0f || this.minimapPosition.yPct() > 1.0f) {
            int sw = Minecraft.m_91087_().m_91268_().m_85445_();
            int sh = Minecraft.m_91087_().m_91268_().m_85446_();
            this.minimapPosition = HudPosition.fromPixels((int)this.minimapPosition.xPct(), (int)this.minimapPosition.yPct(), sw, sh);
            VaultMod.LOGGER.debug("Migrated minimap HUD position");
        }
        this.gearVisibilityMode = (IVaultOptions.GearVisibilityMode)((Object)pAccessor.m_142634_("gearVisibilityMode", (Object)this.gearVisibilityMode, IVaultOptions.GearVisibilityMode::fromSerializedName, IVaultOptions.GearVisibilityMode::getSerializedName));
        this.usesVisibilityMode = (IVaultOptions.UsesVisibilityMode)((Object)pAccessor.m_142634_("usesVisibilityMode", (Object)this.usesVisibilityMode, IVaultOptions.UsesVisibilityMode::fromSerializedName, IVaultOptions.UsesVisibilityMode::getSerializedName));
        this.showUsesAsStackSize = pAccessor.m_142682_("showUsesAsStackSize", this.showUsesAsStackSize);
        this.showKeyringContents = pAccessor.m_142682_("showKeyringContents", this.showKeyringContents);
        this.showPotionVisibility = pAccessor.m_142682_("showPotionVisibility", this.showPotionVisibility);
        this.usesItemsTextPositionMode = (InventoryHudRenderer.PositionMode)((Object)pAccessor.m_142634_("usesItemsTextPositionMode", (Object)this.usesItemsTextPositionMode, InventoryHudRenderer.PositionMode::fromString, InventoryHudRenderer.PositionMode::getSerializedName));
        this.showScavengerInventoryCount = pAccessor.m_142682_("showScavengerInventoryCount", this.showScavengerInventoryCount);
        this.mapOverlayPosition = (HudPosition)pAccessor.m_142634_("mapOverlayPosition", (Object)this.mapOverlayPosition, HudPosition::deserialize, HudPosition::serialize);
        this.backpackDisplayMode = (InventoryHudRenderer.BackpackDisplayMode)((Object)pAccessor.m_142634_("backpackDisplayMode", (Object)this.backpackDisplayMode, InventoryHudRenderer.BackpackDisplayMode::fromString, InventoryHudRenderer.BackpackDisplayMode::getSerializedName));
        this.companionNametagMode = (IVaultOptions.CompanionNametagMode)((Object)pAccessor.m_142634_("companionNametagMode", (Object)this.companionNametagMode, IVaultOptions.CompanionNametagMode::fromSerializedName, IVaultOptions.CompanionNametagMode::getSerializedName));
    }

    private String writeColorOption(ColorOption t) {
        return String.format("%s,%s,%s,%s", t.getHunterSpec().name(), Float.valueOf(t.getRed()), Float.valueOf(t.getGreen()), Float.valueOf(t.getBlue()));
    }

    private String writeColor(Color t) {
        return String.format("%s,%s,%s", t.getRed(), t.getGreen(), t.getBlue());
    }

    private Color readColor(String string) {
        String[] split = string.split(",");
        return new Color(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
    }

    private ColorOption readColorOption(String string) {
        String[] split = string.split(",");
        return new ColorOption(split[0], Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
    }

    @Override
    public CooldownGuiOption getCooldownOption() {
        return this.cooldownOption;
    }

    @Override
    public void cycleCooldownGuiOption() {
        this.cooldownOption = this.cooldownOption.cycle();
        this.m_92169_();
    }

    @Override
    public HunterParticleDensityOption getHunterParticleDensity() {
        return this.hunterParticleDensity;
    }

    @Override
    public void setHunterParticleDensity(HunterParticleDensityOption density) {
        this.hunterParticleDensity = density;
        this.m_92169_();
    }

    @Override
    public void cycleHunterParticleDensity() {
        this.hunterParticleDensity = this.hunterParticleDensity.next();
        this.m_92169_();
    }

    @Override
    public boolean doVanillaPotionDamageEffects() {
        return this.doVanillaPotionDamageEffects;
    }

    @Override
    public void setVanillaPotionDamageEffects(boolean vanillaPotionDamageEffects) {
        this.doVanillaPotionDamageEffects = vanillaPotionDamageEffects;
        this.m_92169_();
    }

    @Override
    public boolean isAbilityScrollingEnabled() {
        return this.abilityScrollingEnabled;
    }

    @Override
    public void setAbilityScrollingEnabled(boolean abilityScrollingEnabled) {
        this.abilityScrollingEnabled = abilityScrollingEnabled;
        this.m_92169_();
    }

    @Override
    public boolean isQuickbindEditingEnabled() {
        return this.abilityQuickbindEditingEnabled;
    }

    @Override
    public void setQuickbindEditingEnabled(boolean enabled) {
        this.abilityQuickbindEditingEnabled = enabled;
        this.m_92169_();
    }

    @Override
    public boolean isTreasureDoorNamesEnabled() {
        return this.showTreasureDoorNames;
    }

    @Override
    public void setTreasureDoorNamesEnabled(boolean treasureDoorNamesEnabled) {
        this.showTreasureDoorNames = treasureDoorNamesEnabled;
        this.m_92169_();
    }

    @Override
    public boolean isHighlightRarityEnabled() {
        return this.highlightRarityEnabled;
    }

    @Override
    public void setHighlightRarityEnabled(boolean highlightRarityEnabled) {
        this.highlightRarityEnabled = highlightRarityEnabled;
        this.m_92169_();
    }

    @Override
    public boolean showPointMessages() {
        return this.showPointMessages;
    }

    @Override
    public void setShowPointMessages(boolean showPointMessages) {
        this.showPointMessages = showPointMessages;
        this.m_92169_();
    }

    @Override
    public boolean showRarityNames() {
        return this.showRarityNames;
    }

    @Override
    public void setShowRarityNames(boolean showRarityNames) {
        this.showRarityNames = showRarityNames;
        this.m_92169_();
    }

    @Override
    public ColorOption getChestHunterSpec() {
        return this.chestHunterSpec;
    }

    @Override
    public void setChestHunterSpec(ColorOption option) {
        this.chestHunterSpec = option;
        this.m_92169_();
    }

    @Override
    public ColorOption getBlockHunterSpec() {
        return this.blockHunterSpec;
    }

    @Override
    public void setBlockHunterSpec(ColorOption option) {
        this.blockHunterSpec = option;
        this.m_92169_();
    }

    @Override
    public ColorOption getGildedHunterSpec() {
        return this.gildedHunterSpec;
    }

    @Override
    public void setGildedHunterSpec(ColorOption option) {
        this.gildedHunterSpec = option;
        this.m_92169_();
    }

    @Override
    public ColorOption getLivingHunterSpec() {
        return this.livingHunterSpec;
    }

    @Override
    public void setLivingHunterSpec(ColorOption option) {
        this.livingHunterSpec = option;
        this.m_92169_();
    }

    @Override
    public ColorOption getOrnateHunterSpec() {
        return this.ornateHunterSpec;
    }

    @Override
    public void setOrnateHunterSpec(ColorOption option) {
        this.ornateHunterSpec = option;
        this.m_92169_();
    }

    @Override
    public ColorOption getCoinsHunterSpec() {
        return this.coinsHunterSpec;
    }

    @Override
    public void setCoinsHunterSpec(ColorOption option) {
        this.coinsHunterSpec = option;
        this.m_92169_();
    }

    @Override
    public ColorOption getBySpec(ColorOption.HunterSpec spec) {
        switch (spec) {
            case WOODEN: {
                return this.chestHunterSpec;
            }
            case OBSERVER: {
                return this.blockHunterSpec;
            }
            case GILDED: {
                return this.gildedHunterSpec;
            }
            case LIVING: {
                return this.livingHunterSpec;
            }
            case ORNATE: {
                return this.ornateHunterSpec;
            }
            case COINS: {
                return this.coinsHunterSpec;
            }
        }
        return this.chestHunterSpec;
    }

    @Override
    public ColorOption resetColorOption(ColorOption.HunterSpec spec) {
        switch (spec) {
            case WOODEN: {
                this.chestHunterSpec = new ColorOption(ColorOption.HunterSpec.WOODEN, 0.7607843f, 0.63529414f, 0.0f);
                return this.chestHunterSpec;
            }
            case OBSERVER: {
                this.blockHunterSpec = new ColorOption(ColorOption.HunterSpec.OBSERVER, 0.14509805f, 0.6745098f, 0.0f);
                return this.blockHunterSpec;
            }
            case GILDED: {
                this.gildedHunterSpec = new ColorOption(ColorOption.HunterSpec.GILDED, 1.0f, 1.0f, 0.0f);
                return this.gildedHunterSpec;
            }
            case LIVING: {
                this.livingHunterSpec = new ColorOption(ColorOption.HunterSpec.LIVING, 0.0f, 1.0f, 0.0f);
                return this.livingHunterSpec;
            }
            case ORNATE: {
                this.ornateHunterSpec = new ColorOption(ColorOption.HunterSpec.ORNATE, 0.93333334f, 0.0f, 0.0f);
                return this.ornateHunterSpec;
            }
            case COINS: {
                this.coinsHunterSpec = new ColorOption(ColorOption.HunterSpec.COINS, 0.8039216f, 0.44705883f, 0.15294118f);
                return this.coinsHunterSpec;
            }
        }
        this.m_92169_();
        return null;
    }

    @Override
    public void setColorOption(ColorOption.HunterSpec spec, ColorOption option) {
        switch (spec) {
            case WOODEN: {
                this.chestHunterSpec = option;
                break;
            }
            case OBSERVER: {
                this.blockHunterSpec = option;
                break;
            }
            case GILDED: {
                this.gildedHunterSpec = option;
                break;
            }
            case LIVING: {
                this.livingHunterSpec = option;
                break;
            }
            case ORNATE: {
                this.ornateHunterSpec = option;
                break;
            }
            case COINS: {
                this.coinsHunterSpec = option;
            }
        }
        this.m_92169_();
    }

    @Override
    public HealthbarDisplayOption isHealthbarEnabled() {
        if (this.healthBarEnabled == null) {
            this.healthBarEnabled = HealthbarDisplayOption.VAULT_ONLY;
            this.m_92169_();
        }
        return this.healthBarEnabled;
    }

    @Override
    public Color healthbarColor() {
        return this.healthBarColor;
    }

    @Override
    public HealthbarAccessibilityHeightOption getHealthbarHeight() {
        return this.healthBarHeight;
    }

    @Override
    public boolean enableCustomHealthbarColor() {
        return this.enableCustomHealthBarColor;
    }

    @Override
    public void setHealthbarColor(Color color) {
        this.healthBarColor = color;
        this.m_92169_();
    }

    @Override
    public void setHealthbarEnabled(HealthbarDisplayOption enabled) {
        this.healthBarEnabled = enabled;
        this.m_92169_();
    }

    @Override
    public void cycleHealthbarDisplayOption() {
        if (this.healthBarEnabled == null) {
            this.healthBarEnabled = HealthbarDisplayOption.VAULT_ONLY;
        }
        this.healthBarEnabled = this.healthBarEnabled.cycle();
        this.m_92169_();
    }

    @Override
    public void setHealthbarHeight(HealthbarAccessibilityHeightOption height) {
        this.healthBarHeight = height;
        this.m_92169_();
    }

    @Override
    public boolean isHealthbarGroupEnabled() {
        return this.showMobGroupIcons;
    }

    @Override
    public void setHealthbarGroupEnabled(boolean enabled) {
        this.showMobGroupIcons = enabled;
        this.m_92169_();
    }

    @Override
    public boolean isVaultLevelBarHidden() {
        return this.isVaultLevelBarHidden;
    }

    @Override
    public void setVaultLevelBarHidden(boolean vaultLevelBarHidden) {
        this.isVaultLevelBarHidden = vaultLevelBarHidden;
        this.m_92169_();
    }

    @Override
    public void cycleHealthbarHeightOption() {
        this.healthBarHeight = this.healthBarHeight.cycle();
        this.m_92169_();
    }

    @Override
    public Color getDamageTypeColour(VaultDamageNumberEntity.DamageType type) {
        return this.damageTypeColorMap.getOrDefault((Object)type, type.getDefaultColorObject());
    }

    @Override
    public void setDamageTypeColour(VaultDamageNumberEntity.DamageType type, Color color) {
        this.damageTypeColorMap.put(type, color);
        this.m_92169_();
    }

    @Override
    public Color getDefaultDamageTypeColour(VaultDamageNumberEntity.DamageType type) {
        return type.getDefaultColorObject();
    }

    @Override
    public boolean isFlooredDamageNumbersEnabled() {
        return this.isFlooredDamageParticles;
    }

    @Override
    public void setFlooredDamageNumbersEnabled(boolean enabled) {
        this.isFlooredDamageParticles = enabled;
        this.m_92169_();
    }

    @Override
    public void cycleDamageParticlesDisplayOption() {
        if (this.isDamageParticlesEnabled == null) {
            this.isDamageParticlesEnabled = HealthbarDisplayOption.VAULT_ONLY;
        }
        this.isDamageParticlesEnabled = this.isDamageParticlesEnabled.cycle();
        this.m_92169_();
    }

    @Override
    public HealthbarDisplayOption isDamageParticlesEnabled() {
        return this.isDamageParticlesEnabled;
    }

    @Override
    public void setDamageParticlesEnabled(HealthbarDisplayOption enabled) {
        this.isDamageParticlesEnabled = enabled;
    }

    @Override
    public InventoryHudRenderer.InventoryHudDisplayMode getInventoryHudMode() {
        return this.inventoryHudMode;
    }

    @Override
    public void cycleInventoryHudDisplayMode() {
        this.inventoryHudMode = this.inventoryHudMode.cycle();
        this.m_92169_();
    }

    @Override
    public Map<String, HudPosition> getHudPositions() {
        return this.hudPositions;
    }

    @Override
    public void setHudPosition(String slotId, HudPosition pos) {
        this.hudPositions.put(slotId, pos);
        this.m_92169_();
    }

    @Override
    public boolean isShowOverlay() {
        return this.showOverlay;
    }

    @Override
    public void toggleShowOverlay() {
        this.showOverlay = !this.showOverlay;
        this.m_92169_();
    }

    @Override
    public boolean isShowHudOnlyOnTab() {
        return this.showHudOnlyOnTab;
    }

    @Override
    public void toggleHudShowOnlyOnTab() {
        this.showHudOnlyOnTab = !this.showHudOnlyOnTab;
        this.m_92169_();
    }

    @Override
    public InventoryHudRenderer.PositionMode getInventoryHudPercentageDisplayMode() {
        return this.inventoryHudPercentageDisplayMode;
    }

    @Override
    public void cycleInventoryHudPercentageDisplayMode() {
        this.inventoryHudPercentageDisplayMode = this.inventoryHudPercentageDisplayMode.cycle();
        this.m_92169_();
    }

    @Override
    public VaultMapOverlay.MapVisibilityOption getMapVisibilityOption() {
        return this.mapVisibilityOption;
    }

    @Override
    public void cycleMapVisibilityOption() {
        this.mapVisibilityOption = this.mapVisibilityOption.cycle();
        this.m_92169_();
    }

    @Override
    public void setMapVisibilityOption(VaultMapOverlay.MapVisibilityOption mapVisibilityOption) {
        this.mapVisibilityOption = mapVisibilityOption;
        this.m_92169_();
    }

    @Override
    public boolean isToggleMapOverlay() {
        return this.toggleMapOverlay;
    }

    @Override
    public void setToggleMapOverlay(boolean toggleMapOverlay) {
        this.toggleMapOverlay = toggleMapOverlay;
        this.m_92169_();
    }

    @Override
    public float getMapOverlayOpacity() {
        return this.vaultMapOverlayOpacity;
    }

    @Override
    public void setMapOverlayOpacity(float opacity) {
        this.vaultMapOverlayOpacity = opacity;
        this.m_92169_();
    }

    @Override
    public IVaultOptions.ScaleMode getMapScaleMode() {
        return this.mapScaleMode;
    }

    @Override
    public void setMapScaleMode(IVaultOptions.ScaleMode mapScaleMode) {
        this.mapScaleMode = mapScaleMode;
        this.m_92169_();
    }

    @Override
    public void cycleMapScaleMode() {
        this.mapScaleMode = this.mapScaleMode.cycle();
        this.m_92169_();
    }

    @Override
    public float getModifierListScale() {
        return this.modifierListScale;
    }

    @Override
    public void setModifierListScale(float scale) {
        this.modifierListScale = scale;
        this.m_92169_();
    }

    @Override
    public HudPosition getMinimapPosition() {
        if (this.minimapPosition.xPct() < 0.0f || this.minimapPosition.yPct() < 0.0f) {
            int sw = Minecraft.m_91087_().m_91268_().m_85445_();
            int sh = Minecraft.m_91087_().m_91268_().m_85446_();
            this.minimapPosition = HudPosition.fromPixels(3, 3, sw, sh);
        }
        return this.minimapPosition;
    }

    @Override
    public void setMinimapPosition(HudPosition minimapPosition) {
        this.minimapPosition = minimapPosition;
        this.m_92169_();
    }

    @Override
    public IVaultOptions.GearVisibilityMode getGearVisibilityMode() {
        return this.gearVisibilityMode;
    }

    @Override
    public void setGearVisibilityMode(IVaultOptions.GearVisibilityMode gearVisibilityMode) {
        this.gearVisibilityMode = gearVisibilityMode;
        this.m_92169_();
    }

    @Override
    public void cycleGearVisibilityMode() {
        this.gearVisibilityMode = this.gearVisibilityMode.cycle();
        this.m_92169_();
    }

    @Override
    public IVaultOptions.UsesVisibilityMode getUsesVisibilityMode() {
        return this.usesVisibilityMode;
    }

    @Override
    public void setUsesVisibilityMode(IVaultOptions.UsesVisibilityMode usesVisibilityMode) {
        this.usesVisibilityMode = usesVisibilityMode;
        this.m_92169_();
    }

    @Override
    public void cycleUsesVisibilityMode() {
        this.usesVisibilityMode = this.usesVisibilityMode.cycle();
        this.m_92169_();
    }

    @Override
    public boolean getShowUsesAsStackSize() {
        return this.showUsesAsStackSize;
    }

    @Override
    public void setShowUsesAsStackSize(boolean show) {
        this.showUsesAsStackSize = show;
        this.m_92169_();
    }

    @Override
    public void toggleShowUsesAsStackSize() {
        this.showUsesAsStackSize = !this.showUsesAsStackSize;
        this.m_92169_();
    }

    @Override
    public boolean getShowKeyringContents() {
        return this.showKeyringContents;
    }

    @Override
    public void setShowKeyringContents(boolean showKeyringContents) {
        this.showKeyringContents = showKeyringContents;
        this.m_92169_();
    }

    @Override
    public void toggleShowKeyringContents() {
        this.showKeyringContents = !this.showKeyringContents;
        this.m_92169_();
    }

    @Override
    public float getPotionScale() {
        return this.potionScale;
    }

    @Override
    public void setPotionScale(float scale) {
        this.potionScale = scale;
        this.m_92169_();
    }

    @Override
    public boolean getShowPotionVisibility() {
        return this.showPotionVisibility;
    }

    @Override
    public void setShowPotionVisibility(boolean showPotionVisibility) {
        this.showPotionVisibility = showPotionVisibility;
        this.m_92169_();
    }

    @Override
    public void toggleShowPotionVisibility() {
        this.showPotionVisibility = !this.showPotionVisibility;
        this.m_92169_();
    }

    @Override
    public InventoryHudRenderer.PositionMode getUsesItemsTextPositionMode() {
        return this.usesItemsTextPositionMode;
    }

    @Override
    public void cycleUsesItemsTextPositionMode() {
        this.usesItemsTextPositionMode = this.usesItemsTextPositionMode.cycle();
        this.m_92169_();
    }

    @Override
    public InventoryHudRenderer.InventoryHudDisplayMode getInventoryUsesHudMode() {
        return this.inventoryUsesHudMode;
    }

    @Override
    public void setInventoryUsesHudDisplayMode(InventoryHudRenderer.InventoryHudDisplayMode mode) {
        this.inventoryUsesHudMode = mode;
        this.m_92169_();
    }

    @Override
    public void cycleInventoryUsesHudDisplayMode() {
        this.inventoryUsesHudMode = this.inventoryUsesHudMode.cycle();
        this.m_92169_();
    }

    @Override
    public IVaultOptions.ScaleMode getMapOverlayScale() {
        return this.mapOverlayScaleMode;
    }

    @Override
    public void setMapOverlayScale(IVaultOptions.ScaleMode scaleMode) {
        this.mapOverlayScaleMode = scaleMode;
        this.m_92169_();
    }

    @Override
    public void cycleMapOverlayScale() {
        this.mapOverlayScaleMode = this.mapOverlayScaleMode.cycle();
        this.m_92169_();
    }

    @Override
    public float getInvHudScale() {
        return this.invHudScale;
    }

    @Override
    public void setInvHudScale(float scale) {
        this.invHudScale = scale;
        this.m_92169_();
    }

    @Override
    public boolean isScavengerInventoryCountEnabled() {
        return this.showScavengerInventoryCount;
    }

    @Override
    public void setScavengerInventoryCountEnabled(boolean enabled) {
        this.showScavengerInventoryCount = enabled;
        this.m_92169_();
    }

    @Override
    public void toggleScavengerInventoryCountEnabled() {
        this.showScavengerInventoryCount = !this.showScavengerInventoryCount;
        this.m_92169_();
    }

    @Override
    public float getMapScale() {
        return this.mapScale;
    }

    @Override
    public void setMapScale(float scale) {
        this.mapScale = scale;
        this.m_92169_();
    }

    @Override
    public float getMapZoom() {
        return this.mapZoom;
    }

    @Override
    public void setMapZoom(float zoom) {
        this.mapZoom = zoom;
        this.m_92169_();
    }

    @Override
    public float getObjectiveScale() {
        return this.objectiveScale;
    }

    @Override
    public void setObjectiveScale(float scale) {
        this.objectiveScale = scale;
        this.m_92169_();
    }

    @Override
    public boolean isShowAbilitiesWithManaBar() {
        return this.showAbilitiesWithManaBar;
    }

    @Override
    public void setShowAbilitiesWithManaBar(boolean show) {
        this.showAbilitiesWithManaBar = show;
        this.m_92169_();
    }

    @Override
    public void toggleShowAbilitiesWithManaBar() {
        this.showAbilitiesWithManaBar = !this.showAbilitiesWithManaBar;
        this.m_92169_();
    }

    @Override
    public HudPosition mapOverlayPosition() {
        if (this.mapOverlayPosition.xPct() < 0.0f || this.mapOverlayPosition.yPct() < 0.0f) {
            int sw = Minecraft.m_91087_().m_91268_().m_85445_();
            int sh = Minecraft.m_91087_().m_91268_().m_85446_();
            this.mapOverlayPosition = HudPosition.fromPixels(sw / 2, sh / 2, sw, sh);
        }
        return this.mapOverlayPosition;
    }

    @Override
    public void setMapOverlayPosition(HudPosition mapOverlayPosition) {
        this.mapOverlayPosition = mapOverlayPosition;
        this.m_92169_();
    }

    @Override
    public InventoryHudRenderer.BackpackDisplayMode getBackpackHudMode() {
        return this.backpackDisplayMode;
    }

    @Override
    public void setBackpackHudMode(InventoryHudRenderer.BackpackDisplayMode mode) {
        this.backpackDisplayMode = mode;
        this.m_92169_();
    }

    @Override
    public void cycleBackpackHudMode() {
        this.backpackDisplayMode = this.backpackDisplayMode.cycle();
        this.m_92169_();
    }

    @Override
    public IVaultOptions.CompanionNametagMode getCompanionNametagMode() {
        return this.companionNametagMode;
    }

    @Override
    public void setCompanionNametagMode(IVaultOptions.CompanionNametagMode mode) {
        this.companionNametagMode = mode;
        this.m_92169_();
    }

    @Override
    public void cycleCompanionNametagMode() {
        this.companionNametagMode = this.companionNametagMode.cycle();
        this.m_92169_();
    }
}

