/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.entity.Targeting;
import iskallia.vault.world.data.ServerVaults;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PiglinAi.class})
public class MixinPiglinAi {
    @Inject(method={"findNearestValidAttackTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private static void findNearestValidAttackTarget(Piglin piglin, CallbackInfoReturnable<Optional<? extends LivingEntity>> cir) {
        if (ServerVaults.get(piglin.f_19853_).isPresent()) {
            cir.setReturnValue(Optional.ofNullable(piglin.m_5448_()));
        }
    }

    @Inject(method={"setAngerTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private static void checkAttackable(AbstractPiglin piglin, LivingEntity target, CallbackInfo ci) {
        if (Targeting.getTargetingResult((LivingEntity)piglin, (Entity)target) == Targeting.TargetingResult.IGNORE) {
            ci.cancel();
        }
    }

    @Inject(method={"isNearestValidAttackTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private static void checkTargetOverrides(Piglin piglin, LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        Targeting.TargetingResult targetingResult = Targeting.getTargetingResult((LivingEntity)piglin, (Entity)entity);
        if (targetingResult != Targeting.TargetingResult.DEFAULT) {
            cir.setReturnValue((Object)targetingResult.getShouldTarget());
            cir.cancel();
        }
    }
}

