/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.SpiritEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.gear.trinket.effects.WingsTrinket;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.skill.prestige.WingsActivationPrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.BlockChanceHelper;
import iskallia.vault.world.SpectatorMode;
import iskallia.vault.world.data.PlayerPatreonDisplayData;
import iskallia.vault.world.data.PlayerTitlesData;
import iskallia.vault.world.data.VaultSpectatorData;
import iskallia.vault.www.patreon.PatreonTier;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class}, priority=1111)
public abstract class MixinPlayerEntity
extends LivingEntity
implements BlockChanceHelper.PlayerBlockAnimationAccess {
    private boolean actualOnGround;
    @Shadow
    @Final
    private Inventory f_36093_;
    @Shadow
    private Component displayname;
    private static EntityDataAccessor<Boolean> PLAYER_BLOCKING;
    private int shieldActiveTimeout = 0;

    @Shadow
    public abstract void m_6667_(DamageSource var1);

    @Shadow
    public abstract void m_142687_(Entity.RemovalReason var1);

    @Shadow
    public abstract void m_7822_(byte var1);

    @Shadow
    protected abstract void m_6475_(DamageSource var1, float var2);

    @Shadow
    protected abstract MutableComponent m_36218_(MutableComponent var1);

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    @Shadow
    public abstract int m_36323_();

    protected MixinPlayerEntity(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"blockActionRestricted"}, at={@At(value="RETURN")}, cancellable=true)
    public void blockActionRestricted(Level world, BlockPos pos, GameType gameMode, CallbackInfoReturnable<Boolean> cir) {
        boolean restricted = CommonEvents.PLAYER_ACTION.invoke((Player)this, world, pos, gameMode, (Boolean)cir.getReturnValue()).isRestricted();
        if (restricted != (Boolean)cir.getReturnValue()) {
            cir.setReturnValue((Object)restricted);
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    protected void addVisualBlockIndicatorEntry(CallbackInfo ci) {
        if (PLAYER_BLOCKING == null) {
            PLAYER_BLOCKING = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        }
        this.m_20088_().m_135372_(PLAYER_BLOCKING, (Object)false);
    }

    @Inject(method={"tryToStartFallFlying"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getItemBySlot(Lnet/minecraft/world/entity/EquipmentSlot;)Lnet/minecraft/world/item/ItemStack;")}, cancellable=true)
    protected void tryToStartFallFlying(CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        if (PrestigeHelper.getPrestige(player).hasActive(WingsActivationPrestigePower.class)) {
            player.m_36320_();
            cir.setReturnValue((Object)true);
            return;
        }
        TrinketHelper.getTrinkets((LivingEntity)player, WingsTrinket.class).forEach(wings -> {
            if (!wings.isUsable(player)) {
                return;
            }
            player.m_36320_();
            cir.setReturnValue((Object)true);
        });
    }

    @Inject(method={"tryToStartFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    protected void preventFallFlying(CallbackInfoReturnable<Boolean> cir) {
        ItemStack chestItem = this.m_6844_(EquipmentSlot.CHEST);
        if (chestItem.m_41619_()) {
            return;
        }
        Player player = (Player)this;
        if (player.m_36335_().m_41519_(chestItem.m_41720_())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    protected void shieldTick(CallbackInfo ci) {
        if (this.m_183503_().m_5776_()) {
            return;
        }
        if (this.shieldActiveTimeout > 0) {
            --this.shieldActiveTimeout;
        }
        if (this.shieldActiveTimeout <= 0) {
            this.m_20088_().m_135381_(PLAYER_BLOCKING, (Object)false);
        }
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getSweepingDamageRatio(Lnet/minecraft/world/entity/LivingEntity;)F"))
    private float getSweepingEdgeRatio(LivingEntity entity) {
        ActiveFlags.IS_AOE_ATTACKING.push();
        Player thisPlayer = (Player)this;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)thisPlayer);
        float sweepingDmgRatio = snapshot.getAttributeValue(ModGearAttributes.SWEEPING_HIT_DAMAGE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        return sweepingDmgRatio += snapshot.getAttributeValue(ModGearAttributes.SWEEPING_HIT_CHANCE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/player/Player;sweepAttack()V")})
    public void sweepAttack(Entity pTargetEntity, CallbackInfo ci) {
        ActiveFlags.IS_AOE_ATTACKING.pop();
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;sendParticles(Lnet/minecraft/core/particles/ParticleOptions;DDDIDDDD)I")}, cancellable=true)
    private void preventDamageIndicatorHearts(Entity entity, CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public void setForceBlocking() {
        this.shieldActiveTimeout = 20;
        this.m_20088_().m_135381_(PLAYER_BLOCKING, (Object)true);
    }

    @Override
    public boolean isForceBlocking() {
        return (Boolean)this.m_20088_().m_135370_(PLAYER_BLOCKING);
    }

    public boolean canBeRiddenInWater(Entity rider) {
        if (rider instanceof SpiritEntity) {
            return true;
        }
        return super.canBeRiddenInWater(rider);
    }

    @Redirect(method={"getDigSpeed"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;getDestroySpeed(Lnet/minecraft/world/level/block/state/BlockState;)F"))
    public float getDigSpeed(Inventory inventory, BlockState state) {
        float base = inventory.m_36020_(state);
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(this);
        float bonus = snapshot.getAttributeValue(ModGearAttributes.MINING_SPEED, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        if (inventory.m_36056_().m_41720_() == ModItems.TOOL) {
            return base > 1.0f ? bonus : base;
        }
        return base > 1.0f ? base + bonus : base;
    }

    @Inject(method={"getDigSpeed"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    private void adjustBreakSpeed(BlockState state, BlockPos pos, CallbackInfoReturnable<Float> cir) {
        Player thisPlayer = (Player)this;
        cir.setReturnValue((Object)Float.valueOf(CommonEvents.BLOCK_BREAK_SPEED.invoke(thisPlayer, pos, state, cir.getReturnValueF()).getSpeed()));
    }

    @ModifyArg(method={"attack"}, index=4, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V"))
    private SoundEvent playNoDamageSoundWhenBroken(SoundEvent sound) {
        VaultGearItem gearItem;
        Player thisPlayer = (Player)this;
        ItemStack mainHandItem = thisPlayer.m_21205_();
        Item item = mainHandItem.m_41720_();
        if (item instanceof VaultGearItem && (gearItem = (VaultGearItem)item).isBroken(mainHandItem)) {
            return SoundEvents.f_12315_;
        }
        return sound;
    }

    @Inject(method={"getDisplayName"}, at={@At(value="RETURN")}, cancellable=true)
    public void getDisplayName(CallbackInfoReturnable<Component> cir) {
        ServerLevel sl;
        if (this.f_19853_.f_46443_) {
            return;
        }
        AtomicReference<MutableComponent> playerName = new AtomicReference<MutableComponent>(((Component)cir.getReturnValue()).m_6881_());
        Style playerNameStyle = playerName.get().m_7383_();
        PlayerTitlesData.getCustomName((Player)this, (Component)cir.getReturnValue(), PlayerTitlesData.Type.CHAT).ifPresent(playerName::set);
        PatreonTier tier = null;
        PlayerPatreonDisplayData.PatreonDisplay display = new PlayerPatreonDisplayData.PatreonDisplay(null, false, false);
        Level level = this.m_183503_();
        if (level instanceof ServerLevel && (display = PlayerPatreonDisplayData.get(sl = (ServerLevel)level).getDisplaySettings(this.m_142081_())) != null) {
            tier = display.displayTier;
        }
        MutableComponent response = playerName.get().m_130948_(playerNameStyle);
        if (tier == null) {
            cir.setReturnValue((Object)playerName.get().m_130948_(playerNameStyle));
            return;
        }
        if (display.enableColour) {
            response = response.m_130948_(Style.f_131099_.m_131148_(tier.getColor()));
        }
        if (display.enableEmblem) {
            response = tier.getPrefix().m_130946_(" ").m_7220_((Component)response.m_130948_(response.m_7383_()));
        }
        cir.setReturnValue((Object)response);
    }

    @Redirect(method={"wantsToStopRiding"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isShiftKeyDown()Z"))
    private boolean redirectWantsToStopRiding(Player instance) {
        ServerPlayer serverPlayer;
        if (instance instanceof ServerPlayer && VaultUtils.isVaultLevel((Level)(serverPlayer = (ServerPlayer)instance).m_183503_())) {
            VaultSpectatorData spectatorData;
            SpectatorMode mode = ((SpectatorMode.GameRuleValue)serverPlayer.m_183503_().m_46469_().m_46170_(ModGameRules.SPECTATOR_MODE)).get();
            if (mode == SpectatorMode.PLAYER) {
                return false;
            }
            if (serverPlayer.f_8941_.m_9290_() == GameType.SPECTATOR && (spectatorData = VaultSpectatorData.get(serverPlayer.m_183503_())).isPlayerSpectating(serverPlayer.m_142081_())) {
                return false;
            }
        }
        return instance.m_6144_();
    }
}

