/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.init.ModGameRules;
import iskallia.vault.world.SpectatorMode;
import iskallia.vault.world.data.VaultSpectatorData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class MixinServerPlayer {
    @Inject(method={"tick"}, at={@At(value="INVOKE", target="net/minecraft/server/level/ServerPlayer.wantsToStopRiding ()Z")}, cancellable=true)
    private void cancelTickWhenSpectatingPlayer(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        SpectatorMode mode = ((SpectatorMode.GameRuleValue)player.m_183503_().m_46469_().m_46170_(ModGameRules.SPECTATOR_MODE)).get();
        if (mode != SpectatorMode.PLAYER) {
            return;
        }
        if (player.f_8941_.m_9290_() != GameType.SPECTATOR) {
            return;
        }
        VaultSpectatorData spectatorData = VaultSpectatorData.get(player.m_183503_());
        if (spectatorData == null) {
            return;
        }
        if (!spectatorData.isPlayerSpectating(player.m_142081_())) {
            return;
        }
        ci.cancel();
    }
}

