/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.block.CompanionHomeBlock;
import iskallia.vault.block.RoyaleCrateBlock;
import iskallia.vault.block.RunePillarBlock;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.block.entity.CompanionHomeTileEntity;
import iskallia.vault.block.entity.DehammerizerTileEntity;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.tool.HammerManager;
import iskallia.vault.item.tool.HammerTile;
import iskallia.vault.item.tool.IHammer;
import iskallia.vault.item.tool.ToolItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockBreakAckPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayerGameMode.class})
public abstract class MixinServerPlayerGameMode
implements IHammer {
    @Shadow
    @Final
    protected ServerPlayer f_9245_;
    @Shadow
    protected ServerLevel f_9244_;
    @Shadow
    private GameType f_9247_;
    @Shadow
    private int f_9252_;
    @Shadow
    private BlockPos f_9254_;
    @Shadow
    private int f_9250_;
    @Shadow
    private boolean f_9253_;
    @Shadow
    private BlockPos f_9251_;
    @Shadow
    private int f_9255_;
    private HammerManager hammer = new HammerManager();

    @Shadow
    public abstract boolean m_9295_();

    @Shadow
    public abstract void m_7712_();

    @Shadow
    public abstract void m_9286_(BlockPos var1, ServerboundPlayerActionPacket.Action var2, String var3);

    @Shadow
    public abstract boolean m_9280_(BlockPos var1);

    @Override
    public HammerManager getHammer() {
        return this.hammer;
    }

    @Redirect(method={"useItemOn"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;doesSneakBypassUse(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;)Z"))
    public boolean doesSneakBypassUse(ItemStack instance, LevelReader levelReader, BlockPos pos, Player player) {
        BlockState state = levelReader.m_8055_(pos);
        if (state.m_60734_() instanceof RunePillarBlock && player.m_6144_() && player.m_21205_().m_41619_()) {
            return true;
        }
        Block block = state.m_60734_();
        if (block instanceof CompanionHomeBlock) {
            CompanionHomeTileEntity entity;
            CompanionHomeBlock block2 = (CompanionHomeBlock)block;
            if (player.m_6144_() && (block = levelReader.m_7702_(pos)) instanceof CompanionHomeTileEntity && !(entity = (CompanionHomeTileEntity)block).getCompanion().m_41619_()) {
                return true;
            }
        }
        return state.m_60734_() instanceof VaultCrateBlock || state.m_60734_() instanceof RoyaleCrateBlock;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        this.hammer.tiles.removeIf(tile -> !tile.isDestroyingBlock);
        if (this.f_9253_) {
            BlockState blockstate = this.f_9244_.m_8055_(this.f_9254_);
            if (blockstate.m_60795_()) {
                return;
            }
            for (HammerTile tile2 : this.hammer.tiles) {
                BlockState state = this.f_9244_.m_8055_(tile2.destroyPos);
                float f = this.doDestroyProgress(state, tile2.destroyPos, this.f_9255_, tile2);
                if (!(f >= 1.0f)) continue;
                this.m_9280_(tile2.destroyPos);
            }
        }
        for (HammerTile tile3 : this.hammer.tiles) {
            if (!tile3.isDestroyingBlock) continue;
            BlockState blockstate = this.f_9244_.m_8055_(this.f_9251_);
            if (blockstate.m_60795_()) {
                this.f_9244_.m_6801_(-1, tile3.destroyPos, -1);
                tile3.lastSentState = -1;
                tile3.isDestroyingBlock = false;
                continue;
            }
            this.doDestroyProgress(this.f_9244_.m_8055_(tile3.destroyPos), tile3.destroyPos, tile3.destroyProgressStart, tile3);
        }
    }

    private float doDestroyProgress(BlockState state, BlockPos pos, int destroyProgressStart, HammerTile tile) {
        int i = this.f_9252_ - destroyProgressStart;
        float f = state.m_60625_((Player)this.f_9245_, (BlockGetter)this.f_9245_.f_19853_, pos) * (float)(i + 1);
        int j = Math.min(9, (int)(f * 10.0f));
        if (j != tile.lastSentState) {
            this.f_9244_.m_6801_(-1, pos, j);
            tile.lastSentState = j;
        }
        return f;
    }

    @Inject(method={"handleBlockBreakAction"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;canInteractWith(Lnet/minecraft/core/BlockPos;D)Z", shift=At.Shift.BEFORE)})
    public void handleBlockBreakAction(BlockPos pos, ServerboundPlayerActionPacket.Action action, Direction facing, int buildHeight, CallbackInfo ci) {
        if (!this.f_9245_.canInteractWith(pos, 1.0) || pos.m_123342_() >= buildHeight) {
            return;
        }
        if (action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
            if (!this.f_9244_.m_7966_((Player)this.f_9245_, pos)) {
                return;
            }
            if (this.m_9295_()) {
                if (this.hasHammer(this.f_9245_)) {
                    this.computeHammerTiles(this.f_9244_, pos, facing, buildHeight);
                }
                this.hammer.tiles.removeIf(tile -> {
                    this.m_9286_(tile.destroyPos, action, "creative destroy");
                    return true;
                });
                return;
            }
            if (this.f_9245_.m_36187_((Level)this.f_9244_, pos, this.f_9247_)) {
                return;
            }
            if (this.hasHammer(this.f_9245_)) {
                this.computeHammerTiles(this.f_9244_, pos, facing, buildHeight);
            }
            BlockState initialBlockState = this.f_9244_.m_8055_(pos);
            float f1 = initialBlockState.m_60625_((Player)this.f_9245_, (BlockGetter)this.f_9245_.f_19853_, pos);
            this.hammer.tiles.removeIf(tile -> {
                tile.destroyProgressStart = this.f_9252_;
                float f2 = 1.0f;
                BlockState blockstate = this.f_9244_.m_8055_(tile.destroyPos);
                if (!blockstate.m_60795_()) {
                    blockstate.m_60686_((Level)this.f_9244_, tile.destroyPos, (Player)this.f_9245_);
                    f2 = blockstate.m_60625_((Player)this.f_9245_, (BlockGetter)this.f_9245_.f_19853_, tile.destroyPos);
                }
                if (!blockstate.m_60795_() && f1 >= 1.0f && f2 >= 1.0f) {
                    this.m_9286_(tile.destroyPos, action, "insta mine");
                    return true;
                }
                if (f1 < 1.0f) {
                    if (tile.isDestroyingBlock) {
                        this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockBreakAckPacket(tile.destroyPos, this.f_9244_.m_8055_(tile.destroyPos), ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, false, "abort destroying since another started (client insta mine, server disagreed)"));
                    }
                    tile.isDestroyingBlock = true;
                    int i = (int)(f2 * 10.0f);
                    this.f_9244_.m_6801_(-1, tile.destroyPos, i);
                    this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockBreakAckPacket(tile.destroyPos, this.f_9244_.m_8055_(tile.destroyPos), action, true, "actual start of destroying"));
                    tile.lastSentState = i;
                    return false;
                }
                return true;
            });
        } else if (action == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK) {
            if (pos.equals((Object)this.f_9251_)) {
                int j = this.f_9252_ - this.f_9250_;
                BlockState initialBlockState = this.f_9244_.m_8055_(pos);
                if (!initialBlockState.m_60795_()) {
                    float f1 = initialBlockState.m_60625_((Player)this.f_9245_, (BlockGetter)this.f_9245_.f_19853_, pos) * (float)(j + 1);
                    if (f1 >= 0.7f) {
                        this.hammer.tiles.removeIf(tile -> {
                            tile.isDestroyingBlock = false;
                            this.f_9244_.m_6801_(-1, tile.destroyPos, -1);
                            BlockState blockState = this.f_9244_.m_8055_(tile.destroyPos);
                            float f2 = blockState.m_60625_((Player)this.f_9245_, (BlockGetter)this.f_9245_.f_19853_, tile.destroyPos) * (float)(this.f_9252_ - tile.destroyProgressStart + 1);
                            if (f2 >= f1) {
                                this.m_9286_(tile.destroyPos, action, "destroyed");
                                return true;
                            }
                            return false;
                        });
                        return;
                    }
                    if (!this.f_9253_) {
                        for (HammerTile tile2 : this.hammer.tiles) {
                            tile2.isDestroyingBlock = false;
                        }
                    }
                }
            }
            for (HammerTile tile3 : this.hammer.tiles) {
                this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockBreakAckPacket(tile3.destroyPos, this.f_9244_.m_8055_(tile3.destroyPos), action, true, "stopped destroying"));
            }
        } else if (action == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK) {
            this.hammer.tiles.removeIf(tile -> {
                this.f_9244_.m_6801_(-1, tile.destroyPos, -1);
                this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockBreakAckPacket(tile.destroyPos, this.f_9244_.m_8055_(tile.destroyPos), action, true, "aborted destroying"));
                return true;
            });
        }
    }

    @Redirect(method={"handleBlockBreakAction"}, at=@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V"))
    public void handleDestroyMismatchSuppress(Logger instance, String strFormat, Object arg1, Object arg2) {
    }

    private boolean hasHammer(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != ModItems.TOOL) {
            return false;
        }
        if (DehammerizerTileEntity.hasDemhammerizerAround((Entity)player)) {
            return false;
        }
        VaultGearData data = VaultGearData.read(stack);
        return data.get(ModGearAttributes.HAMMERING, VaultGearAttributeTypeMerger.anyTrue());
    }

    private boolean hasHydroVoid(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != ModItems.TOOL) {
            return false;
        }
        VaultGearData data = VaultGearData.read(stack);
        return data.get(ModGearAttributes.HYDROVOID, VaultGearAttributeTypeMerger.anyTrue());
    }

    private void computeHammerTiles(ServerLevel world, BlockPos pos, Direction facing, int buildHeight) {
        ToolItem.getHammerPositions((Level)world, this.f_9245_.m_21205_(), pos, facing, (Entity)this.f_9245_).forEachRemaining(p -> {
            if (!p.equals((Object)pos)) {
                this.hammer.tiles.add(new HammerTile(true, this.f_9252_, (BlockPos)p, -1));
            }
        });
    }

    @Redirect(method={"removeBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;"))
    private FluidState removeBlock(ServerLevel instance, BlockPos pos) {
        if (this.hasHydroVoid(this.f_9245_)) {
            return Fluids.f_76191_.m_76145_();
        }
        return instance.m_6425_(pos);
    }
}

