/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.block.base.IAllowZone;
import iskallia.vault.core.world.storage.IZonedWorld;
import iskallia.vault.core.world.storage.WorldZone;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunk.class})
public abstract class MixinWorldChunk {
    @Shadow
    public abstract Level m_62953_();

    @Inject(method={"setBlockState"}, at={@At(value="HEAD")}, cancellable=true)
    private void setBlockState(BlockPos pos, BlockState state, boolean isMoving, CallbackInfoReturnable<BlockState> ci) {
        if (this.m_62953_().m_5776_()) {
            return;
        }
        if (this.m_62953_().m_8055_(pos).m_60734_() instanceof WebBlock) {
            return;
        }
        if (this.m_62953_().m_8055_(pos).m_60734_() instanceof IAllowZone) {
            return;
        }
        IZonedWorld proxy = IZonedWorld.of(this.m_62953_()).orElse(null);
        if (proxy == null) {
            return;
        }
        List<WorldZone> zones = proxy.getZones().get(pos);
        if (zones.isEmpty()) {
            return;
        }
        for (WorldZone zone : zones) {
            if (zone.canModify() != Boolean.FALSE) continue;
            ci.setReturnValue(null);
            return;
        }
    }
}

