/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkMap.class})
public abstract class ParallelVaultGen {
    private Executor mainWorker;
    @Shadow
    @Final
    private ServerLevel f_140133_;
    @Shadow
    @Final
    private BlockableEventLoop<Runnable> f_140135_;
    @Shadow
    @Final
    private ChunkProgressListener f_140144_;
    @Shadow
    private ChunkGenerator f_140136_;
    @Shadow
    @Final
    private StructureManager f_140147_;
    @Shadow
    @Final
    private ThreadedLevelLightEngine f_140134_;

    @Shadow
    protected abstract ChunkStatus m_140262_(ChunkStatus var1, int var2);

    @Shadow
    protected abstract CompletableFuture<Either<List<ChunkAccess>, ChunkHolder.ChunkLoadingFailure>> m_140210_(ChunkPos var1, int var2, IntFunction<ChunkStatus> var3);

    @Shadow
    protected abstract void m_140375_(ChunkPos var1);

    @Shadow
    protected abstract CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140383_(ChunkHolder var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void initMainWorker(ServerLevel serverLevel, LevelStorageSource.LevelStorageAccess levelStorage, DataFixer dataFixer, StructureManager structureManager, Executor backgroundExecutor, BlockableEventLoop<Runnable> mainThreadExecutor, LightChunkGetter lightChunkGetter, ChunkGenerator chunkGenerator, ChunkProgressListener progressListener, ChunkStatusUpdateListener statusListener, Supplier<Boolean> supplyEnabled, int viewDistance, boolean sync, CallbackInfo ci) {
        this.mainWorker = backgroundExecutor;
    }

    @Inject(method={"scheduleChunkGeneration"}, at={@At(value="HEAD")}, cancellable=true)
    private void VaultGeneration(ChunkHolder chunkHolder, ChunkStatus targetStatus, CallbackInfoReturnable<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> cir) {
        if (this.f_140133_ instanceof VirtualWorld) {
            ChunkPos chunkPos = chunkHolder.m_140092_();
            CompletableFuture<Either<List<ChunkAccess>, ChunkHolder.ChunkLoadingFailure>> chunkDependenciesFuture = this.m_140210_(chunkPos, targetStatus.m_62488_(), distance -> this.m_140262_(targetStatus, distance));
            this.f_140133_.m_46473_().m_6525_(() -> "chunkGenerate " + targetStatus.m_62467_());
            CompletionStage future = chunkDependenciesFuture.thenComposeAsync(dependencyResult -> (CompletionStage)dependencyResult.map(dependencies -> {
                try {
                    CompletableFuture generationFuture = targetStatus.m_187788_(this.mainWorker, this.f_140133_, this.f_140136_, this.f_140147_, this.f_140134_, finisherFunction -> this.m_140383_(chunkHolder), dependencies, false);
                    this.f_140144_.m_5511_(chunkPos, targetStatus);
                    return generationFuture;
                }
                catch (Exception exception) {
                    exception.getStackTrace();
                    CrashReport report = CrashReport.m_127521_((Throwable)exception, (String)"Exception generating new chunk. Please report to developers!");
                    CrashReportCategory reportCategory = report.m_127514_("Chunk information");
                    reportCategory.m_128159_("Location", (Object)String.format("%d,%d", chunkPos.f_45578_, chunkPos.f_45579_));
                    reportCategory.m_128159_("Generator", (Object)this.f_140136_);
                    this.f_140135_.execute(() -> {
                        throw new ReportedException(report);
                    });
                    throw new ReportedException(report);
                }
            }, failure -> {
                this.m_140375_(chunkPos);
                return CompletableFuture.completedFuture(Either.right((Object)failure));
            }), this.mainWorker);
            cir.setReturnValue((Object)future);
        }
    }
}

