/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModBlocks;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.CoinDefinition;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class AbilityLevelMessage {
    private final String abilityName;
    private final boolean isUpgrade;

    public AbilityLevelMessage(String abilityName, boolean isUpgrade) {
        this.abilityName = abilityName;
        this.isUpgrade = isUpgrade;
    }

    public static void encode(AbilityLevelMessage message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.abilityName);
        buffer.writeBoolean(message.isUpgrade);
    }

    public static AbilityLevelMessage decode(FriendlyByteBuf buffer) {
        return new AbilityLevelMessage(buffer.m_130277_(), buffer.readBoolean());
    }

    public static void handle(AbilityLevelMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            if (message.isUpgrade) {
                AbilityLevelMessage.upgradeAbility(message, sender);
            } else {
                AbilityLevelMessage.downgradeAbility(message, sender);
            }
        });
        context.setPacketHandled(true);
    }

    private static void upgradeAbility(AbilityLevelMessage message, ServerPlayer player) {
        ServerLevel level = player.m_183503_();
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(level);
        PlayerAbilitiesData abilitiesData = PlayerAbilitiesData.get(level);
        AbilityTree abilityTree = abilitiesData.getAbilities((Player)player);
        abilityTree.getForId(message.abilityName).ifPresent(skill -> {
            LearnableSkill learnable;
            SkillContext context = SkillContext.of(player);
            if (skill instanceof LearnableSkill && (learnable = (LearnableSkill)skill).canLearn(context)) {
                learnable.learn(context);
                PlayerVaultStats stats = statsData.getVaultStats((Player)player);
                stats.setSkillPoints(context.getLearnPoints());
                abilityTree.sync(context);
            }
        });
    }

    private static void downgradeAbility(AbilityLevelMessage message, ServerPlayer player) {
        ServerLevel level = player.m_183503_();
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(level);
        PlayerAbilitiesData abilitiesData = PlayerAbilitiesData.get(level);
        AbilityTree abilityTree = abilitiesData.getAbilities((Player)player);
        abilityTree.getForId(message.abilityName).ifPresent(skill -> {
            LearnableSkill learnable;
            SkillContext context = SkillContext.of(player);
            if (skill instanceof LearnableSkill && (learnable = (LearnableSkill)skill).canRegret(context)) {
                List<InventoryUtil.ItemAccess> items = InventoryUtil.findAllItems((Player)player);
                boolean hasEnoughCurrency = CoinDefinition.hasEnoughCurrency(items, new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, learnable.getRegretCost()));
                if (!hasEnoughCurrency) {
                    return;
                }
                CoinDefinition.extractCurrency((Player)player, items, new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, learnable.getRegretCost()));
                learnable.regret(context);
                PlayerVaultStats stats = statsData.getVaultStats((Player)player);
                stats.setSkillPoints(context.getLearnPoints());
                abilityTree.sync(context);
            }
        });
    }
}

