/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.particles.AbsorbingParticle;
import iskallia.vault.init.ModParticles;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class AbsorbingParticleMessage {
    private final Vec3 startPos;
    private final int targetEntity;
    private final Vec3 targetPos;
    private final int color;

    private AbsorbingParticleMessage(Vec3 startPos, int targetEntity, Vec3 targetPos, int color) {
        this.startPos = startPos;
        this.targetEntity = targetEntity;
        this.targetPos = targetPos;
        this.color = color;
    }

    public AbsorbingParticleMessage(Vec3 startPos, Entity targetEntity, int color) {
        this.startPos = startPos;
        this.targetEntity = targetEntity.m_142049_();
        this.targetPos = targetEntity.m_20182_();
        this.color = color;
    }

    public AbsorbingParticleMessage(Vec3 startPos, Vec3 targetPos, int color) {
        this.startPos = startPos;
        this.targetEntity = -1;
        this.targetPos = targetPos;
        this.color = color;
    }

    public static void encode(AbsorbingParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.startPos.f_82479_);
        buffer.writeDouble(message.startPos.f_82480_);
        buffer.writeDouble(message.startPos.f_82481_);
        buffer.m_130130_(message.targetEntity);
        buffer.writeDouble(message.targetPos.f_82479_);
        buffer.writeDouble(message.targetPos.f_82480_);
        buffer.writeDouble(message.targetPos.f_82481_);
        buffer.writeInt(message.color);
    }

    public static AbsorbingParticleMessage decode(FriendlyByteBuf buffer) {
        return new AbsorbingParticleMessage(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.m_130242_(), new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readInt());
    }

    public static void handle(AbsorbingParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                message.spawnParticles();
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        float rotation;
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Random random = new Random();
        ParticleEngine pe = Minecraft.m_91087_().f_91061_;
        for (i = 0; i < 80; ++i) {
            rotation = random.nextFloat() * 360.0f;
            float radius = 1.0f + random.nextFloat();
            Vec3 offset = new Vec3((double)(radius / 5.0f) * Math.cos(rotation), 0.0, (double)(radius / 5.0f) * Math.sin(rotation));
            offset.m_82490_(random.nextDouble() + 0.5);
            Particle particle = pe.m_107370_((ParticleOptions)ModParticles.ABSORBING.get(), this.startPos.m_7096_() + 0.5, this.startPos.m_7098_() + random.nextDouble() * 0.6 + 0.15, this.startPos.m_7094_() + 0.5, offset.f_82479_ / 2.0, random.nextDouble() * 0.25 + 0.1, offset.f_82481_ / 2.0);
            if (!(particle instanceof AbsorbingParticle)) continue;
            AbsorbingParticle pylonParticle = (AbsorbingParticle)particle;
            pylonParticle.setTarget(() -> this.lambda$spawnParticles$1((Level)level));
            pylonParticle.m_107253_((float)(this.color >>> 16 & 0xFF) / 255.0f, (float)(this.color >>> 8 & 0xFF) / 255.0f, (float)(this.color & 0xFF) / 255.0f);
        }
        for (i = 0; i < 12; ++i) {
            rotation = random.nextFloat() * 360.0f;
            Vec3 offset = new Vec3((double)0.4f * Math.cos(rotation), 0.0, (double)0.4f * Math.sin(rotation));
            offset.m_82490_(random.nextDouble() + 0.5);
            Particle particle = pe.m_107370_((ParticleOptions)ModParticles.NOVA_CLOUD.get(), this.startPos.m_7096_() + 0.5 + offset.f_82479_, this.startPos.m_7098_() + random.nextDouble() * 0.15, this.startPos.m_7094_() + 0.5 + offset.f_82481_, offset.f_82479_ / 8.0, random.nextDouble() * 0.125, offset.f_82481_ / 8.0);
            if (particle != null) {
                particle.m_107257_(60 + random.nextInt(20));
            }
            offset = new Vec3(0.25 * Math.cos(rotation), 0.0, 0.25 * Math.sin(rotation));
            offset.m_82490_(random.nextDouble() + 0.5);
            particle = pe.m_107370_((ParticleOptions)ModParticles.NOVA_CLOUD.get(), this.startPos.m_7096_() + 0.5 + offset.f_82479_, this.startPos.m_7098_() + random.nextDouble() * 0.15, this.startPos.m_7094_() + 0.5 + offset.f_82481_, offset.f_82479_ / 8.0, random.nextDouble() * 0.125, offset.f_82481_ / 8.0);
            if (particle == null) continue;
            particle.m_107257_(60 + random.nextInt(20));
        }
    }

    private /* synthetic */ Vec3 lambda$spawnParticles$1(Level level) {
        Entity patt3905$temp = level.m_6815_(this.targetEntity);
        if (patt3905$temp instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)patt3905$temp;
            return entity.m_20182_().m_82520_((double)entity.m_20205_() / 2.0, (double)entity.m_20206_() / 2.0, (double)(entity.m_20205_() / 2.0f));
        }
        return this.targetPos;
    }
}

