/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.AlchemyArchiveTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class AlchemyArchiveDiscoverEffectMessage {
    private final BlockPos pos;
    private final String effectId;

    public AlchemyArchiveDiscoverEffectMessage(BlockPos pos, String effectId) {
        this.pos = pos;
        this.effectId = effectId;
    }

    public static void encode(AlchemyArchiveDiscoverEffectMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.m_130070_(message.effectId);
    }

    public static AlchemyArchiveDiscoverEffectMessage decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        String effectId = buffer.m_130277_();
        return new AlchemyArchiveDiscoverEffectMessage(pos, effectId);
    }

    public static void handle(AlchemyArchiveDiscoverEffectMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            BlockPos pos = message.pos;
            BlockEntity tile = player.m_183503_().m_7702_(pos);
            if (tile instanceof AlchemyArchiveTileEntity) {
                AlchemyArchiveTileEntity alchemyTableTile = (AlchemyArchiveTileEntity)tile;
                alchemyTableTile.discoverEffect(player, message.effectId);
            }
        });
        context.setPacketHandled(true);
    }
}

