/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.AlchemyTableTileEntity;
import iskallia.vault.config.AlchemyTableConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.bottle.BottleEffect;
import iskallia.vault.item.bottle.BottleItem;
import iskallia.vault.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class AlchemyTableEffectCraftMessage {
    private final BlockPos pos;
    private final String effectId;

    public AlchemyTableEffectCraftMessage(BlockPos pos, @Nullable String effectId) {
        this.pos = pos;
        this.effectId = effectId;
    }

    public static void encode(AlchemyTableEffectCraftMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.m_182687_(Optional.ofNullable(message.effectId), FriendlyByteBuf::m_130070_);
    }

    public static AlchemyTableEffectCraftMessage decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        String effectId = buffer.m_182698_(FriendlyByteBuf::m_130277_).orElse(null);
        return new AlchemyTableEffectCraftMessage(pos, effectId);
    }

    public static void handle(AlchemyTableEffectCraftMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            BlockPos pos = message.pos;
            BlockEntity tile = player.m_183503_().m_7702_(pos);
            if (!(tile instanceof AlchemyTableTileEntity)) {
                return;
            }
            AlchemyTableTileEntity alchemyTableTile = (AlchemyTableTileEntity)tile;
            ItemStack input = alchemyTableTile.getInventory().m_8020_(0);
            if (input.m_41619_()) {
                return;
            }
            AlchemyTableConfig cfg = ModConfigs.VAULT_ALCHEMY_TABLE;
            ItemStack inputCopy = input.m_41777_();
            ArrayList<ItemStack> cost = new ArrayList<ItemStack>();
            AlchemyTableConfig.CraftableEffectConfig effectConfig = cfg.getConfig(message.effectId);
            if (effectConfig == null) {
                return;
            }
            if (!effectConfig.hasPrerequisites((Player)player)) {
                return;
            }
            BottleEffect createdEffect = BottleItem.getType(input).flatMap(effectConfig::createEffect).orElse(null);
            if (createdEffect == null) {
                return;
            }
            BottleEffect currentEffect = BottleItem.getEffect(input).orElse(null);
            if (currentEffect != null && currentEffect.getEffectId().equals(createdEffect.getEffectId())) {
                return;
            }
            cost.addAll(effectConfig.createCraftingCost(inputCopy));
            List<ItemStack> missing = InventoryUtil.getMissingInputs(cost, player.m_150109_());
            if (!missing.isEmpty()) {
                return;
            }
            if (!InventoryUtil.consumeInputs(cost, player.m_150109_(), true)) {
                return;
            }
            if (InventoryUtil.consumeInputs(cost, player.m_150109_(), false)) {
                alchemyTableTile.startCrafting();
                BottleItem.setEffect(input, createdEffect);
            }
        });
        context.setPacketHandled(true);
    }
}

