/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.BingoObjective;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.world.data.ServerVaults;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public record BingoScrollMessage(double delta) {
    public static void encode(BingoScrollMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.delta);
    }

    public static BingoScrollMessage decode(FriendlyByteBuf buffer) {
        return new BingoScrollMessage(buffer.readDouble());
    }

    public static void handle(BingoScrollMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerLevel patt1058$temp;
            ServerPlayer player = context.getSender();
            if (player == null || !((patt1058$temp = player.m_183503_()) instanceof VirtualWorld)) {
                return;
            }
            VirtualWorld world = (VirtualWorld)patt1058$temp;
            ServerVaults.get((Level)world).ifPresent(vault -> vault.get(Vault.OBJECTIVES).forEach(BingoObjective.class, objective -> {
                objective.onScroll((Player)player, message.delta);
                return false;
            }));
        });
        context.setPacketHandled(true);
    }
}

