/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModSounds;
import iskallia.vault.item.BoosterPackItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public record BoosterPackSelectionMessage(int index) {
    public static void encode(BoosterPackSelectionMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.index);
    }

    public static BoosterPackSelectionMessage decode(FriendlyByteBuf buffer) {
        return new BoosterPackSelectionMessage(buffer.readInt());
    }

    public static void handle(BoosterPackSelectionMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!(stack.m_41720_() instanceof BoosterPackItem)) {
                return;
            }
            List<ItemStack> outcomes = BoosterPackItem.getOutcomes(stack);
            if (outcomes == null || message.index < 0 || message.index >= outcomes.size()) {
                return;
            }
            player.m_21008_(InteractionHand.MAIN_HAND, outcomes.get(message.index()).m_41777_());
            BoosterPackSelectionMessage.successEffects(player.f_19853_, player.m_20182_());
        });
        context.setPacketHandled(true);
    }

    public static void successEffects(Level world, Vec3 pos) {
        world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, ModSounds.BOOSTER_PACK_SUCCESS_SFX, SoundSource.PLAYERS, 1.0f, 1.0f);
        ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123799_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 500, 1.0, 1.0, 1.0, 0.5);
    }
}

