/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.CardEssenceExtractorTileEntity;
import iskallia.vault.config.CardEssenceExtractorConfig;
import iskallia.vault.container.inventory.CardEssenceExtractorContainer;
import iskallia.vault.core.card.Card;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.CardItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class CardEssenceExtractorUpgradeCardMessage {
    public static final CardEssenceExtractorUpgradeCardMessage INSTANCE = new CardEssenceExtractorUpgradeCardMessage();

    private CardEssenceExtractorUpgradeCardMessage() {
    }

    public static void encode(CardEssenceExtractorUpgradeCardMessage msg, FriendlyByteBuf buf) {
    }

    public static CardEssenceExtractorUpgradeCardMessage decode(FriendlyByteBuf buf) {
        return INSTANCE;
    }

    public static void handle(CardEssenceExtractorUpgradeCardMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu openCt = sender.f_36096_;
            if (!(openCt instanceof CardEssenceExtractorContainer)) {
                return;
            }
            CardEssenceExtractorContainer extractorContainer = (CardEssenceExtractorContainer)openCt;
            CardEssenceExtractorTileEntity tile = extractorContainer.getTileEntity();
            if (tile == null || tile.m_58901_()) {
                return;
            }
            if (!tile.getCardUpgradeOutputStack().m_41619_()) {
                return;
            }
            ItemStack upgradeable = tile.getCardUpgradeStack();
            if (upgradeable.m_41619_() || !(upgradeable.m_41720_() instanceof CardItem)) {
                return;
            }
            Card card = CardItem.getCard(upgradeable);
            int tier = card.getTier();
            CardEssenceExtractorConfig.TierConfig cfg = ModConfigs.CARD_ESSENCE_EXTRACTOR.getConfig(tier).orElse(null);
            if (cfg == null || tile.getEssence() < cfg.getEssencePerUpgrade() || !card.canUpgrade()) {
                return;
            }
            ItemStack upgraded = upgradeable.m_41777_();
            card.onUpgrade();
            CardItem.setCard(upgraded, card);
            tile.setCardUpgradeStack(ItemStack.f_41583_);
            tile.setCardUpgradeOutputStack(upgraded);
            tile.setEssence(tile.getEssence() - cfg.getEssencePerUpgrade());
            sender.f_19853_.m_6263_(null, sender.m_20185_(), sender.m_20186_(), sender.m_20189_(), SoundEvents.f_11824_, SoundSource.PLAYERS, 0.8f, sender.f_19853_.f_46441_.nextFloat() * 0.3f + 1.7f);
        });
        context.setPacketHandled(true);
    }
}

