/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModParticles;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ChainingParticleMessage {
    private final List<Vec3> chainingPos;

    public ChainingParticleMessage(List<Vec3> chainingPos) {
        this.chainingPos = chainingPos;
    }

    public static void encode(ChainingParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.chainingPos.size());
        for (int i = 0; i < message.chainingPos.size(); ++i) {
            buffer.writeDouble(message.chainingPos.get((int)i).f_82479_);
            buffer.writeDouble(message.chainingPos.get((int)i).f_82480_);
            buffer.writeDouble(message.chainingPos.get((int)i).f_82481_);
        }
    }

    public static ChainingParticleMessage decode(FriendlyByteBuf buffer) {
        ArrayList<Vec3> list = new ArrayList<Vec3>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            list.add(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()));
        }
        return new ChainingParticleMessage(list);
    }

    public static void handle(ChainingParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                ChainingParticleMessage.spawnParticles(message.chainingPos);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(List<Vec3> pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (int i = 0; i < pos.size(); ++i) {
            Random random = level.m_5822_();
            if (i + 1 >= pos.size()) continue;
            Vec3 pos1 = pos.get(i);
            Vec3 pos2 = pos.get(i + 1);
            double dist = pos1.m_82554_(pos2);
            int count = (int)(dist / (double)0.15f);
            for (double delta = 0.0; delta < 1.0; delta += count == 0 ? (double)0.15f : (double)(1.0f / (float)count)) {
                Vec3 chainingPos = pos1.m_165921_(pos2, delta);
                Vec3 offset = new Vec3(0.0, 0.0, 0.0);
                level.m_6493_((ParticleOptions)ModParticles.CHAINING.get(), true, chainingPos.m_7096_() + offset.f_82479_, chainingPos.m_7098_() + random.nextDouble() * (double)0.15f, chainingPos.m_7094_() + offset.f_82481_, offset.f_82479_ / 2.0, random.nextDouble() * 0.1, offset.f_82481_ / 2.0);
            }
        }
    }
}

