/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.particles.AlchemyTableParticle;
import iskallia.vault.init.ModParticles;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundAlchemyParticleMessage {
    public final BlockPos pos;
    public final Direction dir;
    public final int color;
    public final float yOffset;

    public ClientboundAlchemyParticleMessage(BlockPos pos, Direction dir, int color, float yOffset) {
        this.pos = pos;
        this.dir = dir;
        this.color = color;
        this.yOffset = yOffset;
    }

    public static void encode(ClientboundAlchemyParticleMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.m_130068_((Enum)message.dir);
        buffer.writeInt(message.color);
        buffer.writeFloat(message.yOffset);
    }

    public static ClientboundAlchemyParticleMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundAlchemyParticleMessage(buffer.m_130135_(), (Direction)buffer.m_130066_(Direction.class), buffer.readInt(), buffer.readFloat());
    }

    public static void handle(ClientboundAlchemyParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundAlchemyParticleMessage.renderParticles(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderParticles(ClientboundAlchemyParticleMessage message) {
        ClientboundAlchemyParticleMessage.renderParticlesFirst(message.pos, message.dir, message.color, message.yOffset);
    }

    public static void renderParticlesFirst(BlockPos pos, Direction dir, int color, float yOffset) {
        AlchemyTableParticle alchemyTableParticle;
        int rot = 0;
        if (dir == Direction.WEST) {
            rot = 90;
        }
        if (dir == Direction.SOUTH) {
            rot = 180;
        }
        if (dir == Direction.EAST) {
            rot = 270;
        }
        Vec3 vec3 = new Vec3((double)0.325f, 0.0, (double)0.325f).m_82524_((float)Math.toRadians(rot));
        Particle particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ModParticles.ALCHEMY_TABLE.get(), (double)pos.m_123341_() + 0.5 + vec3.m_7096_(), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5 + vec3.m_7094_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.7 + (double)yOffset, (double)pos.m_123343_() + 0.5);
        if (particle instanceof AlchemyTableParticle) {
            alchemyTableParticle = (AlchemyTableParticle)particle;
            alchemyTableParticle.setColorStart(0.9f, 0.0f, 0.5f);
            alchemyTableParticle.setColorEnd((float)(color >>> 16 & 0xFF) / 255.0f, (float)(color >>> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        }
        vec3 = new Vec3((double)-0.325f, 0.0, (double)-0.325f).m_82524_((float)Math.toRadians(rot));
        particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ModParticles.ALCHEMY_TABLE.get(), (double)pos.m_123341_() + 0.5 + vec3.m_7096_(), (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5 + vec3.m_7094_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.7 + (double)yOffset, (double)pos.m_123343_() + 0.5);
        if (particle instanceof AlchemyTableParticle) {
            alchemyTableParticle = (AlchemyTableParticle)particle;
            alchemyTableParticle.setColorStart(0.0f, 0.9f, 0.4f);
            alchemyTableParticle.setColorEnd((float)(color >>> 16 & 0xFF) / 255.0f, (float)(color >>> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        }
    }
}

