/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.VaultBossTraitRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundBossSyncTraitsMessage {
    private final int entityId;
    private final List<CompoundTag> traitsNbt;

    public ClientboundBossSyncTraitsMessage(int entityId, Map<String, ITrait> traits) {
        this.entityId = entityId;
        this.traitsNbt = new ArrayList<CompoundTag>();
        traits.forEach((id, trait) -> {
            CompoundTag traitNbt = trait.serializeNBT();
            traitNbt.m_128359_("Type", trait.getType());
            traitNbt.m_128359_("Id", id);
            this.traitsNbt.add(traitNbt);
        });
    }

    private ClientboundBossSyncTraitsMessage(int entityId, List<CompoundTag> traitsNbt, boolean dummy) {
        this.entityId = entityId;
        this.traitsNbt = traitsNbt;
    }

    public static void encode(ClientboundBossSyncTraitsMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        buffer.m_178352_(message.traitsNbt, FriendlyByteBuf::m_130079_);
    }

    public static ClientboundBossSyncTraitsMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundBossSyncTraitsMessage(buffer.readInt(), (List)buffer.m_178371_(size -> new ArrayList(), FriendlyByteBuf::m_130260_), true);
    }

    public static void handle(ClientboundBossSyncTraitsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundBossSyncTraitsMessage.updateAffixes(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateAffixes(ClientboundBossSyncTraitsMessage message) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(message.entityId)) instanceof VaultBossEntity) {
            VaultBossEntity vaultBoss = (VaultBossEntity)entity;
            HashMap<String, ITrait> traits = new HashMap<String, ITrait>();
            message.traitsNbt.forEach(traitNbt -> VaultBossTraitRegistry.createTrait(traitNbt.m_128461_("Type"), vaultBoss, traitNbt).ifPresent(trait -> {
                String id = traitNbt.m_128461_("Id");
                traits.put(id, (ITrait)trait);
            }));
            vaultBoss.setTraits(traits);
        }
    }
}

