/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.particles.FireballParticle;
import iskallia.vault.init.ModParticles;
import iskallia.vault.util.MathUtilities;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record ClientboundFireballExplosionMessage(double x, double y, double z, double r, int count) {
    private static final Random RANDOM = new Random();

    public static void encode(ClientboundFireballExplosionMessage pkt, FriendlyByteBuf buffer) {
        buffer.writeDouble(pkt.x);
        buffer.writeDouble(pkt.y);
        buffer.writeDouble(pkt.z);
        buffer.writeDouble(pkt.r);
        buffer.writeInt(pkt.count);
    }

    public static ClientboundFireballExplosionMessage decode(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        double r = buffer.readDouble();
        int count = buffer.readInt();
        return new ClientboundFireballExplosionMessage(x, y, z, r, count);
    }

    public static void handle(ClientboundFireballExplosionMessage pkt, Supplier<NetworkEvent.Context> contextSupplier) {
        ClientboundFireballExplosionMessage.createParticles(pkt.x, pkt.y, pkt.z, pkt.r, pkt.count);
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void createParticles(double x, double y, double z, double r, int count) {
        ParticleEngine pm = Minecraft.m_91087_().f_91061_;
        for (int i = 0; i < count; ++i) {
            Vec3 position = MathUtilities.getRandomPointOnSphere(x, y, z, r - 0.5, RANDOM);
            Particle particle = pm.m_107370_((ParticleOptions)ModParticles.FIREBALL_CLOUD.get(), position.f_82479_, position.f_82480_, position.f_82481_, 0.0, 0.0, 0.0);
            if (!(particle instanceof FireballParticle)) continue;
            FireballParticle fireballParticle = (FireballParticle)particle;
            float colorOffset = RANDOM.nextFloat() * 0.2f;
            if (RANDOM.nextBoolean()) {
                fireballParticle.setStartColor(0.48359376f + colorOffset, 0.06953125f + colorOffset, 0.0703125f);
            } else {
                fireballParticle.setStartColor(0.75f + colorOffset, 0.35f + colorOffset, 0.0f);
            }
            float col = Mth.m_14068_((Random)RANDOM, (float)0.01f, (float)0.15f);
            fireballParticle.setEndColor(col, col, col);
        }
    }
}

