/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModParticles;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record ClientboundHealSpellParticleMessage(double x, double y, double z, List<Integer> healedEntityIds) {
    public static void encode(ClientboundHealSpellParticleMessage pkt, FriendlyByteBuf buffer) {
        buffer.writeDouble(pkt.x);
        buffer.writeDouble(pkt.y);
        buffer.writeDouble(pkt.z);
        buffer.m_178352_(pkt.healedEntityIds, FriendlyByteBuf::writeInt);
    }

    public static ClientboundHealSpellParticleMessage decode(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        List healedEntityIds = (List)buffer.m_178371_(ArrayList::new, FriendlyByteBuf::readInt);
        return new ClientboundHealSpellParticleMessage(x, y, z, healedEntityIds);
    }

    public static void handle(ClientboundHealSpellParticleMessage pkt, Supplier<NetworkEvent.Context> contextSupplier) {
        ClientboundHealSpellParticleMessage.createParticles(pkt.x, pkt.y, pkt.z, pkt.healedEntityIds);
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void createParticles(double x, double y, double z, List<Integer> healedEntityIds) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        healedEntityIds.forEach(healedEntityId -> {
            Random rnd = level.f_46441_;
            for (int i = 0; i < 2 + rnd.nextInt(4); ++i) {
                double xStart = x + ((double)rnd.nextFloat() - 0.5) * 0.2;
                double yStart = y + ((double)rnd.nextFloat() - 0.5) * 0.2;
                double zStart = z + ((double)rnd.nextFloat() - 0.5) * 0.2;
                level.m_7106_((ParticleOptions)ModParticles.HEAL_SPELL.get(), xStart, yStart, zStart, (double)healedEntityId.intValue(), 0.0, 0.0);
            }
        });
    }
}

