/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.render.HunterOutlineRenderer;
import iskallia.vault.init.ModOptions;
import iskallia.vault.init.ModParticles;
import iskallia.vault.skill.ability.effect.spi.HunterAbility;
import iskallia.vault.util.MiscUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record ClientboundHunterPositionsMessage(List<HunterAbility.HighlightPosition> positions, int duration) {
    private static final Random RANDOM = new Random();

    public ClientboundHunterPositionsMessage(List<HunterAbility.HighlightPosition> positions) {
        this(positions, 48 + RANDOM.nextInt(12));
    }

    public static void encode(ClientboundHunterPositionsMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.positions.size());
        for (HunterAbility.HighlightPosition position : msg.positions) {
            buf.writeDouble((double)position.blockPos().m_123341_());
            buf.writeDouble((double)position.blockPos().m_123342_());
            buf.writeDouble((double)position.blockPos().m_123343_());
            buf.writeBoolean(position.target() != null);
            if (position.target() != null) {
                buf.m_130070_(position.target().name());
            }
            buf.writeInt(position.color());
        }
        buf.writeInt(msg.duration);
    }

    public static ClientboundHunterPositionsMessage decode(FriendlyByteBuf buf) {
        ArrayList<HunterAbility.HighlightPosition> positions = new ArrayList<HunterAbility.HighlightPosition>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            positions.add(new HunterAbility.HighlightPosition(new BlockPos(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readBoolean() ? HunterAbility.Target.of(buf.m_130277_()) : null, buf.readInt()));
        }
        return new ClientboundHunterPositionsMessage(positions, buf.readInt());
    }

    public static void handle(ClientboundHunterPositionsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        if (!ModOptions.HUNTER_PARTICLES.getValue().booleanValue()) {
            HunterOutlineRenderer.addHighlightPositions(msg.positions, msg.duration);
        } else {
            for (HunterAbility.HighlightPosition position : msg.positions) {
                int color = ModOptions.getHunterColor(position.target(), position.color());
                int particles = (int)Math.floor(8.0 * ModOptions.HUNTER_PARTICLE_DENSITY.getValue().getDensity());
                for (int i = 0; i < particles; ++i) {
                    Vec3 offset = MiscUtils.getRandomOffset(position.blockPos(), RANDOM);
                    ClientboundHunterPositionsMessage.creatParticle(offset.f_82479_, offset.f_82480_, offset.f_82481_, color, msg.duration);
                }
            }
        }
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void creatParticle(double x, double y, double z, int intColor, int duration) {
        Color color = new Color(intColor);
        Particle particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ModParticles.DEPTH_FIREWORK.get(), x, y, z, (double)((float)color.getRed() / 255.0f), (double)((float)color.getGreen() / 255.0f), (double)((float)color.getBlue() / 255.0f));
        if (particle != null) {
            particle.m_107257_(duration);
        }
    }
}

