/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import com.mojang.math.Vector3f;
import iskallia.vault.client.particles.ArtifactBossImmunityParticleOptions;
import iskallia.vault.init.ModParticles;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSafePointPlaceParticleMessage {
    private final BlockPos safePointPos;

    public ClientboundSafePointPlaceParticleMessage(BlockPos safePointPos) {
        this.safePointPos = safePointPos;
    }

    public static void encode(ClientboundSafePointPlaceParticleMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.safePointPos);
    }

    public static ClientboundSafePointPlaceParticleMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundSafePointPlaceParticleMessage(buffer.m_130135_());
    }

    public static void handle(ClientboundSafePointPlaceParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                ClientboundSafePointPlaceParticleMessage.spawnParticles(message.safePointPos);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(BlockPos safePointPos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Random random = new Random();
        Vec3 center = new Vec3((double)((float)safePointPos.m_123341_() + 0.5f), (double)(safePointPos.m_123342_() + 1), (double)((float)safePointPos.m_123343_() + 0.5f));
        int col = 16769280;
        int col2 = 16774829;
        float r = (float)(col >> 16 & 0xFF) / 255.0f;
        float g = (float)(col >> 8 & 0xFF) / 255.0f;
        float b = (float)(col & 0xFF) / 255.0f;
        float r2 = (float)(col2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(col2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(col2 & 0xFF) / 255.0f;
        for (int i = 0; i < 100; ++i) {
            float rotation = random.nextFloat() * 360.0f;
            float radius = 4.0f * random.nextFloat();
            Vec3 offset = new Vec3((double)radius * Math.cos(rotation), 0.0, (double)radius * Math.sin(rotation));
            Vec3 spawnPos = center.m_82549_(offset);
            level.m_6493_((ParticleOptions)new ArtifactBossImmunityParticleOptions((ParticleType<ArtifactBossImmunityParticleOptions>)((ParticleType)ModParticles.ARTIFACT_BOSS_IMMUNITY.get()), 20, new Vector3f(r, g, b), new Vector3f(r2, g2, b2)), true, spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_(), 0.0, (double)random.nextFloat(0.5f, 2.0f), 0.0);
        }
    }
}

